/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.v5;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.common.CommonValueUnpacker;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.packstream.PackInput;
import org.neo4j.jdbc.internal.shaded.bolt.values.Node;
import org.neo4j.jdbc.internal.shaded.bolt.values.Path;
import org.neo4j.jdbc.internal.shaded.bolt.values.Relationship;
import org.neo4j.jdbc.internal.shaded.bolt.values.Segment;
import org.neo4j.jdbc.internal.shaded.bolt.values.Type;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;

public class ValueUnpackerV5
extends CommonValueUnpacker {
    private static final int NODE_FIELDS = 4;
    private static final int RELATIONSHIP_FIELDS = 8;

    public ValueUnpackerV5(PackInput input, ValueFactory valueFactory) {
        super(input, true, valueFactory);
    }

    @Override
    protected int getNodeFields() {
        return 4;
    }

    @Override
    protected int getRelationshipFields() {
        return 8;
    }

    @Override
    protected Node unpackNode() throws IOException {
        long urn = this.unpacker.unpackLong();
        int numLabels = (int)this.unpacker.unpackListHeader();
        ArrayList<String> labels = new ArrayList<String>(numLabels);
        for (int i = 0; i < numLabels; ++i) {
            labels.add(this.unpacker.unpackString());
        }
        int numProps = (int)this.unpacker.unpackMapHeader();
        HashMap<String, Value> props = new HashMap<String, Value>(numProps);
        for (int j = 0; j < numProps; ++j) {
            String key = this.unpacker.unpackString();
            props.put(key, this.unpack());
        }
        String elementId = this.unpacker.unpackString();
        return this.valueFactory.node(urn, elementId, labels, props);
    }

    @Override
    protected Path unpackPath() throws IOException {
        Node prevNode;
        Node[] uniqNodes = new Node[(int)this.unpacker.unpackListHeader()];
        for (int i = 0; i < uniqNodes.length; ++i) {
            this.ensureCorrectStructSize(Type.NODE, this.getNodeFields(), this.unpacker.unpackStructHeader());
            this.ensureCorrectStructSignature("NODE", (byte)78, this.unpacker.unpackStructSignature());
            uniqNodes[i] = this.unpackNode();
        }
        Relationship[] uniqRels = new Relationship[(int)this.unpacker.unpackListHeader()];
        for (int i = 0; i < uniqRels.length; ++i) {
            this.ensureCorrectStructSize(Type.RELATIONSHIP, 4, this.unpacker.unpackStructHeader());
            this.ensureCorrectStructSignature("UNBOUND_RELATIONSHIP", (byte)114, this.unpacker.unpackStructSignature());
            long id = this.unpacker.unpackLong();
            String relType = this.unpacker.unpackString();
            Map<String, Value> props = this.unpackMap();
            String elementId = this.unpacker.unpackString();
            uniqRels[i] = this.valueFactory.relationship(id, elementId, -1L, String.valueOf(-1), -1L, String.valueOf(-1), relType, props);
        }
        int length = (int)this.unpacker.unpackListHeader();
        Segment[] segments = new Segment[length / 2];
        Node[] nodes = new Node[segments.length + 1];
        Relationship[] rels = new Relationship[segments.length];
        nodes[0] = prevNode = uniqNodes[0];
        for (int i = 0; i < segments.length; ++i) {
            Relationship rel;
            int relIdx = (int)this.unpacker.unpackLong();
            Node nextNode = uniqNodes[(int)this.unpacker.unpackLong()];
            if (relIdx < 0) {
                rel = uniqRels[-relIdx - 1];
                this.setStartAndEnd(rel, nextNode, prevNode);
            } else {
                rel = uniqRels[relIdx - 1];
                this.setStartAndEnd(rel, prevNode, nextNode);
            }
            nodes[i + 1] = nextNode;
            rels[i] = rel;
            segments[i] = this.valueFactory.segment(prevNode, rel, nextNode);
            prevNode = nextNode;
        }
        return this.valueFactory.path(Arrays.asList(segments), Arrays.asList(nodes), Arrays.asList(rels));
    }

    private void setStartAndEnd(Relationship rel, Node start, Node end) {
        rel.setStartAndEnd(start.id(), start.elementId(), end.id(), end.elementId());
    }

    @Override
    protected Relationship unpackRelationship() throws IOException {
        long urn = this.unpacker.unpackLong();
        long startUrn = this.unpacker.unpackLong();
        long endUrn = this.unpacker.unpackLong();
        String relType = this.unpacker.unpackString();
        Map<String, Value> props = this.unpackMap();
        String elementId = this.unpacker.unpackString();
        String startElementId = this.unpacker.unpackString();
        String endElementId = this.unpacker.unpackString();
        return this.valueFactory.relationship(urn, elementId, startUrn, startElementId, endUrn, endElementId, relType, props);
    }
}

