/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Aliased;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expressions;
import org.neo4j.jdbc.internal.shaded.cypherdsl.IdentifiableElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RendererBridge;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public final class AliasedExpression
implements Aliased,
Expression,
IdentifiableElement {
    private final Expression delegate;
    private final String alias;

    AliasedExpression(Expression delegate, String alias) {
        this.delegate = delegate;
        this.alias = alias;
    }

    @Override
    @NotNull
    public String getAlias() {
        return this.alias;
    }

    @Override
    @NotNull
    public AliasedExpression as(String newAlias) {
        Assertions.hasText(newAlias, "The alias may not be null or empty.");
        return new AliasedExpression(this.delegate, newAlias);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        Expressions.nameOrExpression(this.delegate).accept(visitor);
        visitor.leave(this);
    }

    Expression getDelegate() {
        return this.delegate;
    }

    @Override
    @NotNull
    public Expression asExpression() {
        return this;
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }
}

