/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import org.apiguardian.api.API;
import org.jetbrains.annotations.Nullable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.IdentifiableElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ImportingWith;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Neo4jVersion;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Statement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SubqueryExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.With;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;

@API(status=API.Status.STABLE, since="2023.0.0")
@Neo4jVersion(minimum="5.6")
public final class CollectExpression
implements SubqueryExpression {
    private final ImportingWith optionalWith;
    private final Statement resultStatement;

    static CollectExpression collect(Statement statement, IdentifiableElement ... imports) {
        return new CollectExpression(ImportingWith.of(imports), statement);
    }

    static CollectExpression collect(Statement resultStatement) {
        return new CollectExpression(new ImportingWith(), resultStatement);
    }

    static CollectExpression collect(@Nullable With optionalWith, Statement resultStatement) {
        return new CollectExpression(new ImportingWith(optionalWith, null), resultStatement);
    }

    private CollectExpression(ImportingWith optionalWith, Statement resultStatement) {
        this.optionalWith = optionalWith;
        this.resultStatement = resultStatement;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.optionalWith.accept(visitor);
        this.resultStatement.accept(visitor);
        visitor.leave(this);
    }
}

