/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.List;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Nullable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Condition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.IdentifiableElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ImportingWith;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Match;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Neo4jVersion;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PatternElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Statement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SubqueryExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Where;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;

@API(status=API.Status.STABLE, since="2020.1.2")
@Neo4jVersion(minimum="4.0.0")
public final class ExistentialSubquery
implements SubqueryExpression,
Condition {
    private final ImportingWith importingWith;
    private final List<Visitable> fragments;
    @Nullable
    private final Where innerWhere;

    static ExistentialSubquery exists(Match fragment) {
        return new ExistentialSubquery(fragment);
    }

    static Condition exists(Statement statement, IdentifiableElement ... imports) {
        return new ExistentialSubquery(statement, imports);
    }

    static Condition exists(List<PatternElement> patternElements, @Nullable Where innerWhere) {
        return new ExistentialSubquery(patternElements, innerWhere);
    }

    ExistentialSubquery(List<PatternElement> fragments, @Nullable Where innerWhere) {
        this.fragments = List.copyOf(fragments);
        this.importingWith = new ImportingWith();
        this.innerWhere = innerWhere;
    }

    ExistentialSubquery(Match fragment) {
        this.fragments = List.of(fragment);
        this.importingWith = new ImportingWith();
        this.innerWhere = null;
    }

    ExistentialSubquery(Statement statement, IdentifiableElement ... imports) {
        this.fragments = List.of(statement);
        this.importingWith = ImportingWith.of(imports);
        this.innerWhere = null;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.importingWith.accept(visitor);
        this.fragments.forEach(v -> v.accept(visitor));
        Visitable.visitIfNotNull(this.innerWhere, visitor);
        visitor.leave(this);
    }
}

