/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Condition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.NodeLabel;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public final class HasLabelCondition
implements Condition {
    private final SymbolicName nodeName;
    private final List<NodeLabel> nodeLabels;

    static HasLabelCondition create(SymbolicName nodeName, String ... labels) {
        Assertions.notNull(nodeName, "A symbolic name for the node is required.");
        Assertions.notNull(labels, "Labels to query are required.");
        Assertions.notEmpty(labels, "At least one label to query is required.");
        ArrayList<NodeLabel> nodeLabels = new ArrayList<NodeLabel>(labels.length);
        for (String label : labels) {
            nodeLabels.add(new NodeLabel(label));
        }
        return new HasLabelCondition(nodeName, nodeLabels);
    }

    private HasLabelCondition(SymbolicName nodeName, List<NodeLabel> nodeLabels) {
        this.nodeName = nodeName;
        this.nodeLabels = nodeLabels;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.nodeName.accept(visitor);
        this.nodeLabels.forEach(label -> label.accept(visitor));
        visitor.leave(this);
    }
}

