/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.List;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.jdbc.internal.shaded.cypherdsl.AliasedExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Condition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExposesProperties;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExposesRelationships;
import org.neo4j.jdbc.internal.shaded.cypherdsl.FunctionInvocation;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Functions;
import org.neo4j.jdbc.internal.shaded.cypherdsl.LabelExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.NodeLabel;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PatternElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PropertyContainer;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Relationship;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SortItem;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;

@API(status=API.Status.STABLE, since="1.0")
public interface Node
extends PatternElement,
PropertyContainer,
ExposesProperties<Node>,
ExposesRelationships<Relationship> {
    @NotNull
    @Contract(pure=true)
    public List<NodeLabel> getLabels();

    @NotNull
    @Contract(pure=true)
    public Node named(String var1);

    @NotNull
    @Contract(pure=true)
    public Node named(SymbolicName var1);

    @NotNull
    @Contract(pure=true)
    public Condition hasLabels(String ... var1);

    @NotNull
    @Contract(pure=true)
    public Condition hasLabels(LabelExpression var1);

    @NotNull
    @Contract(pure=true)
    public Condition isEqualTo(Node var1);

    @NotNull
    @Contract(pure=true)
    public Condition isNotEqualTo(Node var1);

    @NotNull
    @Contract(pure=true)
    public Condition isNull();

    @NotNull
    @Contract(pure=true)
    public Condition isNotNull();

    @NotNull
    @Contract(pure=true)
    public SortItem descending();

    @NotNull
    @Contract(pure=true)
    public SortItem ascending();

    @NotNull
    @Contract(pure=true)
    public AliasedExpression as(String var1);

    @Deprecated(since="2022.6.0")
    @NotNull
    @Contract(pure=true)
    public FunctionInvocation internalId();

    @NotNull
    @Contract(pure=true)
    default public FunctionInvocation elementId() {
        return Functions.elementId(this);
    }

    @NotNull
    @Contract(pure=true)
    public FunctionInvocation labels();
}

