/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.time.Period;
import org.jetbrains.annotations.NotNull;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Literal;
import org.neo4j.jdbc.internal.shaded.cypherdsl.LiteralBase;

final class PeriodLiteral
extends LiteralBase<Period> {
    static Literal<Period> of(Period duration) {
        return new PeriodLiteral(duration);
    }

    private PeriodLiteral(Period content) {
        super(content);
    }

    @Override
    public Period getContent() {
        return (Period)this.content;
    }

    @Override
    @NotNull
    public String asString() {
        StringBuilder result = new StringBuilder();
        result.append("duration('P");
        if (((Period)this.content).getYears() != 0) {
            result.append(((Period)this.content).getYears()).append("Y");
        }
        if (((Period)this.content).getMonths() != 0) {
            result.append(((Period)this.content).getMonths()).append("M");
        }
        if (((Period)this.content).getDays() != 0) {
            result.append(((Period)this.content).getDays()).append("D");
        }
        result.append("')");
        return result.toString();
    }
}

