/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.AbstractClause;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExpressionList;
import org.neo4j.jdbc.internal.shaded.cypherdsl.UpdatingClause;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;

@API(status=API.Status.STABLE, since="1.0")
public final class Set
extends AbstractClause
implements UpdatingClause {
    private final ExpressionList setItems;

    static Set set(Expression update, Expression ... more) {
        if (more == null || more.length == 0) {
            return new Set(new ExpressionList(List.of(update)));
        }
        ArrayList<Expression> finalExpressionList = new ArrayList<Expression>();
        finalExpressionList.add(update);
        Collections.addAll(finalExpressionList, more);
        return new Set(new ExpressionList((List<Expression>)finalExpressionList));
    }

    Set(ExpressionList setItems) {
        this.setItems = setItems;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.setItems.accept(visitor);
        visitor.leave(this);
    }
}

