/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl.executables;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.driver.SimpleQueryRunner;
import org.neo4j.driver.async.AsyncQueryRunner;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ResultStatement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Statement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.executables.DefaultExecutableResultStatement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.executables.DefaultExecutableStatement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.executables.ExecutableResultStatement;

@API(status=API.Status.STABLE, since="2021.2.1")
public interface ExecutableStatement {
    public static ExecutableStatement makeExecutable(Statement statement) {
        if (statement.doesReturnOrYield()) {
            return new DefaultExecutableResultStatement(statement);
        }
        return new DefaultExecutableStatement(statement);
    }

    public static ExecutableResultStatement makeExecutable(ResultStatement statement) {
        return new DefaultExecutableResultStatement(statement);
    }

    public static ExecutableStatement of(Statement statement) {
        return ExecutableStatement.makeExecutable(statement);
    }

    public static ExecutableResultStatement of(ResultStatement statement) {
        return ExecutableStatement.makeExecutable(statement);
    }

    @NotNull
    @Contract(pure=true)
    public Map<String, Object> getParameters();

    @NotNull
    @Contract(pure=true)
    public Collection<String> getParameterNames();

    @NotNull
    @Contract(pure=true)
    public String getCypher();

    public ResultSummary executeWith(SimpleQueryRunner var1);

    public CompletableFuture<ResultSummary> executeWith(AsyncQueryRunner var1);
}

