/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.dotenv;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.jdbc.internal.shaded.dotenv.Dotenv;
import org.neo4j.jdbc.internal.shaded.dotenv.DotenvEntry;
import org.neo4j.jdbc.internal.shaded.dotenv.DotenvException;
import org.neo4j.jdbc.internal.shaded.dotenv.internal.DotenvParser;
import org.neo4j.jdbc.internal.shaded.dotenv.internal.DotenvReader;

public class DotenvBuilder {
    private String filename = ".env";
    private String directoryPath = "./";
    private boolean systemProperties = false;
    private boolean throwIfMissing = true;
    private boolean throwIfMalformed = true;

    public DotenvBuilder directory(String path) {
        this.directoryPath = path;
        return this;
    }

    public DotenvBuilder filename(String name) {
        this.filename = name;
        return this;
    }

    public DotenvBuilder ignoreIfMissing() {
        this.throwIfMissing = false;
        return this;
    }

    public DotenvBuilder ignoreIfMalformed() {
        this.throwIfMalformed = false;
        return this;
    }

    public DotenvBuilder systemProperties() {
        this.systemProperties = true;
        return this;
    }

    public Dotenv load() throws DotenvException {
        DotenvParser reader = new DotenvParser(new DotenvReader(this.directoryPath, this.filename), this.throwIfMissing, this.throwIfMalformed);
        List<DotenvEntry> env = reader.parse();
        if (this.systemProperties) {
            env.forEach(it -> System.setProperty(it.getKey(), it.getValue()));
        }
        return new DotenvImpl(env);
    }

    static class DotenvImpl
    implements Dotenv {
        private final Map<String, String> envVars;
        private final Set<DotenvEntry> set;
        private final Set<DotenvEntry> setInFile;

        public DotenvImpl(List<DotenvEntry> envVars) {
            Map<String, String> envVarsInFile = envVars.stream().collect(Collectors.toMap(DotenvEntry::getKey, DotenvEntry::getValue, (a, b) -> b));
            this.envVars = new HashMap<String, String>(envVarsInFile);
            this.envVars.putAll(System.getenv());
            this.set = this.envVars.entrySet().stream().map(it -> new DotenvEntry((String)it.getKey(), (String)it.getValue())).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
            this.setInFile = envVarsInFile.entrySet().stream().map(it -> new DotenvEntry((String)it.getKey(), (String)it.getValue())).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
        }

        @Override
        public Set<DotenvEntry> entries() {
            return this.set;
        }

        @Override
        public Set<DotenvEntry> entries(Dotenv.Filter filter) {
            return filter == null ? this.entries() : this.setInFile;
        }

        @Override
        public String get(String key) {
            String value = System.getenv(key);
            return value == null ? this.envVars.get(key) : value;
        }

        @Override
        public String get(String key, String defaultValue) {
            String value = this.get(key);
            return value == null ? defaultValue : value;
        }
    }
}

