/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq;

import org.neo4j.jdbc.internal.shaded.jooq.ContextConverter;
import org.neo4j.jdbc.internal.shaded.jooq.ConverterContext;
import org.neo4j.jdbc.internal.shaded.jooq.Converters;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractContextConverter;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Internal;
import org.neo4j.jdbc.internal.shaded.jooq.tools.Convert;

final class ArrayConverter<T, U>
extends AbstractContextConverter<T[], U[]> {
    final ContextConverter<T, U> converter;
    final ContextConverter<U, T> inverse;

    public ArrayConverter(ContextConverter<T, U> converter) {
        super(Internal.arrayType(converter.fromType()), Internal.arrayType(converter.toType()));
        this.converter = converter;
        this.inverse = Converters.inverse(converter);
    }

    @Override
    public final boolean fromSupported() {
        return this.converter.fromSupported();
    }

    @Override
    public final boolean toSupported() {
        return this.converter.toSupported();
    }

    @Override
    public final U[] from(T[] t, ConverterContext scope) {
        return Convert.convertArray((Object[])t, this.converter);
    }

    @Override
    public final T[] to(U[] t, ConverterContext scope) {
        return Convert.convertArray((Object[])t, this.inverse);
    }
}

