/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Name;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.TableOptions;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractTable;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AutoAlias;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.TableAlias;

abstract class AbstractAutoAliasTable<R extends Record>
extends AbstractTable<R>
implements AutoAlias<Table<R>> {
    final Name alias;
    final Name[] fieldAliases;

    AbstractAutoAliasTable(Name alias) {
        this(alias, (Name[])null);
    }

    AbstractAutoAliasTable(Name alias, Name[] fieldAliases) {
        super(TableOptions.expression(), alias != null ? alias : Names.N_T);
        this.alias = alias;
        this.fieldAliases = fieldAliases;
    }

    abstract AbstractAutoAliasTable<R> construct(Name var1, Name[] var2);

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    public final Table<R> autoAlias(Context<?> ctx, Table<R> t) {
        return t.as(this.alias, this.fieldAliases);
    }

    @Override
    public final Table<R> as(Name as) {
        return new TableAlias<R>(this.construct(as, null), as, this.fieldAliases);
    }

    @Override
    public final Table<R> as(Name as, Name ... fields) {
        return new TableAlias<R>(this.construct(as, fields), as, fields);
    }

    @Override
    public final Table<R> $aliased() {
        return this.construct(this.alias, null);
    }

    @Override
    public final Name $alias() {
        return this.alias;
    }
}

