/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Arrays;
import java.util.Collection;
import org.neo4j.jdbc.internal.shaded.jooq.Condition;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.JoinType;
import org.neo4j.jdbc.internal.shaded.jooq.Name;
import org.neo4j.jdbc.internal.shaded.jooq.QueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.SQL;
import org.neo4j.jdbc.internal.shaded.jooq.Select;
import org.neo4j.jdbc.internal.shaded.jooq.TableLike;
import org.neo4j.jdbc.internal.shaded.jooq.TableOnConditionStep;
import org.neo4j.jdbc.internal.shaded.jooq.TableOptionalOnStep;
import org.neo4j.jdbc.internal.shaded.jooq.TableOptions;
import org.neo4j.jdbc.internal.shaded.jooq.TableOuterJoinStep;
import org.neo4j.jdbc.internal.shaded.jooq.TablePartitionByStep;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractTable;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;

abstract class AbstractJoinTable<J extends AbstractJoinTable<J>>
extends AbstractTable<Record>
implements TableOuterJoinStep<Record>,
TableOptionalOnStep<Record>,
TablePartitionByStep<Record>,
TableOnConditionStep<Record> {
    AbstractJoinTable(TableOptions options, Name name) {
        super(options, name);
    }

    abstract J partitionBy0(Collection<? extends Field<?>> var1);

    public abstract J on(Condition var1);

    public abstract J on(Condition ... var1);

    public final J on(Field<Boolean> c) {
        return (J)this.on(DSL.condition(c));
    }

    public final J on(SQL sql) {
        this.and(sql);
        return (J)this;
    }

    public final J on(String sql) {
        this.and(sql);
        return (J)this;
    }

    public final J on(String sql, Object ... bindings) {
        this.and(sql, bindings);
        return (J)this;
    }

    public final J on(String sql, QueryPart ... parts) {
        this.and(sql, parts);
        return (J)this;
    }

    public final J using(Field<?> ... fields) {
        return (J)this.using(Arrays.asList(fields));
    }

    public abstract J using(Collection<? extends Field<?>> var1);

    public abstract J and(Condition var1);

    public final J and(Field<Boolean> c) {
        return (J)this.and(DSL.condition(c));
    }

    public final J and(SQL sql) {
        return (J)this.and(DSL.condition(sql));
    }

    public final J and(String sql) {
        return (J)this.and(DSL.condition(sql));
    }

    public final J and(String sql, Object ... bindings) {
        return (J)this.and(DSL.condition(sql, bindings));
    }

    public final J and(String sql, QueryPart ... parts) {
        return (J)this.and(DSL.condition(sql, parts));
    }

    public final J andNot(Condition c) {
        return (J)this.and(c.not());
    }

    public final J andNot(Field<Boolean> c) {
        return (J)this.andNot(DSL.condition(c));
    }

    public final J andExists(Select<?> select) {
        return (J)this.and(DSL.exists(select));
    }

    public final J andNotExists(Select<?> select) {
        return (J)this.and(DSL.notExists(select));
    }

    public abstract J or(Condition var1);

    public final J or(Field<Boolean> c) {
        return (J)this.or(DSL.condition(c));
    }

    public final J or(SQL sql) {
        return (J)this.or(DSL.condition(sql));
    }

    public final J or(String sql) {
        return (J)this.or(DSL.condition(sql));
    }

    public final J or(String sql, Object ... bindings) {
        return (J)this.or(DSL.condition(sql, bindings));
    }

    public final J or(String sql, QueryPart ... parts) {
        return (J)this.or(DSL.condition(sql, parts));
    }

    public final J orNot(Condition c) {
        return (J)this.or(c.not());
    }

    public final J orNot(Field<Boolean> c) {
        return (J)this.orNot(DSL.condition(c));
    }

    public final J orExists(Select<?> select) {
        return (J)this.or(DSL.exists(select));
    }

    public final J orNotExists(Select<?> select) {
        return (J)this.or(DSL.notExists(select));
    }

    public final J join(TableLike<?> table, JoinType type) {
        return (J)((AbstractJoinTable)super.join(table, type));
    }

    public final J join(TableLike<?> table, JoinType type, QOM.JoinHint hint) {
        return (J)((AbstractJoinTable)super.join(table, type, hint));
    }
}

