/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Collection;
import java.util.Set;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.DataType;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.QueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.RenderContext;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Cast;
import org.neo4j.jdbc.internal.shaded.jooq.impl.FieldsImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class Array<T>
extends AbstractField<T[]>
implements QOM.Array<T> {
    private static final Set<SQLDialect> REQUIRES_CAST = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    final FieldsImpl<Record> fields;

    Array(Collection<? extends Field<T>> fields) {
        super(Names.N_ARRAY, Array.type(fields));
        this.fields = new FieldsImpl(fields);
    }

    @Override
    public boolean generatesCast() {
        return true;
    }

    private static <T> DataType<T[]> type(Collection<? extends Field<T>> fields) {
        if (fields == null || fields.isEmpty()) {
            return SQLDataType.OTHER.getArrayDataType();
        }
        return fields.iterator().next().getDataType().getArrayDataType();
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        Cast.renderCastIf(ctx, c -> {
            switch (ctx.family()) {
                default: 
            }
            ctx.visit(Keywords.K_ARRAY).sql('[').visit(this.fields).sql(']');
        }, c -> {
            DataType type = (DataType)c.data(Tools.ExtendedDataKey.DATA_EMPTY_ARRAY_BASE_TYPE);
            if (type != null && !type.isOther()) {
                c.sql(type.getCastTypeName(ctx.configuration())).sql("[]");
            } else {
                c.visit(Keywords.K_INT).sql("[]");
            }
        }, () -> this.fields.fields.length == 0 && REQUIRES_CAST.contains((Object)ctx.dialect()) && ctx.castMode() != RenderContext.CastMode.NEVER);
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<T>> $elements() {
        return QOM.unmodifiable((QueryPart[])this.fields.fields);
    }
}

