/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Condition;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.DataType;
import org.neo4j.jdbc.internal.shaded.jooq.Name;
import org.neo4j.jdbc.internal.shaded.jooq.Param;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.Select;
import org.neo4j.jdbc.internal.shaded.jooq.SelectFieldOrAsterisk;
import org.neo4j.jdbc.internal.shaded.jooq.SelectSelectStep;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractQueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class ArrayTableEmulation
extends AbstractQueryPart
implements QOM.UTransient {
    private final Object[] array;
    private final DataType<?> type;
    private final Name fieldAlias;
    private transient Select<?> table;

    ArrayTableEmulation(Object[] array, Name[] fieldAliases) {
        if (Tools.isEmpty(fieldAliases)) {
            this.fieldAlias = Names.N_COLUMN_VALUE;
        } else if (fieldAliases.length == 1) {
            this.fieldAlias = fieldAliases[0];
        } else {
            throw new IllegalArgumentException("Array table simulations can only have a single field alias");
        }
        this.array = array;
        this.type = Tools.componentDataType(array);
    }

    @Override
    public final void accept(Context<?> ctx) {
        Tools.visitSubquery(ctx, this.table(), 1, true);
    }

    private final Select<?> table() {
        if (this.table == null) {
            Select<Record> select = null;
            for (Object element : this.array) {
                Param<?> val = DSL.val(element, this.type);
                SelectSelectStep<Record> subselect = DSL.select(val.as(this.fieldAlias)).select(new SelectFieldOrAsterisk[0]);
                select = select == null ? subselect : select.unionAll(subselect);
            }
            if (select == null) {
                select = DSL.select(DSL.one().as(this.fieldAlias)).select(new SelectFieldOrAsterisk[0]).where((Condition)DSL.falseCondition());
            }
            this.table = select;
        }
        return this.table;
    }
}

