/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Wrapper;
import org.neo4j.jdbc.internal.shaded.jooq.Unwrapper;
import org.neo4j.jdbc.internal.shaded.jooq.UnwrapperProvider;

final class DefaultUnwrapperProvider
implements UnwrapperProvider {
    static final Unwrapper INSTANCE = new DefaultUnwrapper();

    DefaultUnwrapperProvider() {
    }

    @Override
    public Unwrapper provide() {
        return INSTANCE;
    }

    static final class DefaultUnwrapper
    implements Unwrapper {
        private static int maxUnwrappedConnections = 256;
        private static int maxUnwrappedStatements = 256;

        DefaultUnwrapper() {
        }

        static final boolean isWrapperFor(Wrapper w, Class<?> iface) {
            try {
                return w.isWrapperFor(iface);
            }
            catch (SQLException ignore) {
                return false;
            }
        }

        @Override
        public <T> T unwrap(Wrapper wrapper, Class<T> iface) {
            if (wrapper instanceof Connection) {
                Connection c = (Connection)wrapper;
                return this.unwrap(c, iface);
            }
            if (wrapper instanceof Statement) {
                Statement s = (Statement)wrapper;
                return this.unwrap(s, iface);
            }
            throw new IllegalArgumentException("Cannot unwrap: " + String.valueOf(wrapper));
        }

        private <T> T unwrap(Connection wrapper, Class<T> iface) {
            Connection result = wrapper;
            return (T)result;
        }

        private <T> T unwrap(Statement wrapper, Class<T> iface) {
            Statement result = wrapper;
            return (T)result;
        }
    }
}

