/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.math.BigDecimal;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function1;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Internal;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;

final class Degrees
extends AbstractField<BigDecimal>
implements QOM.Degrees {
    final Field<? extends Number> radians;

    Degrees(Field<? extends Number> radians) {
        super(Names.N_DEGREES, Tools.allNotNull(SQLDataType.NUMERIC, radians));
        this.radians = Tools.nullSafeNotNull(radians, SQLDataType.INTEGER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: {
                return false;
            }
            case SQLITE: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: {
                ctx.visit(Internal.idiv(Internal.imul(Tools.castIfNeeded(this.radians, BigDecimal.class), DSL.inline(180)), DSL.pi()));
                break;
            }
            case SQLITE: {
                ctx.visit(DSL.function(Names.N_DEGREES, this.getDataType(), this.radians));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_DEGREES, this.getDataType(), this.radians));
            }
        }
    }

    @Override
    public final Field<? extends Number> $arg1() {
        return this.radians;
    }

    @Override
    public final QOM.Degrees $arg1(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<? extends Number>)newValue);
    }

    @Override
    public final Function1<? super Field<? extends Number>, ? extends QOM.Degrees> $constructor() {
        return a1 -> new Degrees((Field<? extends Number>)a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Degrees) {
            QOM.Degrees o = (QOM.Degrees)that;
            return StringUtils.equals(this.$radians(), o.$radians());
        }
        return super.equals(that);
    }
}

