/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.Parser;
import org.neo4j.jdbc.internal.shaded.jooq.Queries;
import org.neo4j.jdbc.internal.shaded.jooq.RenderContext;
import org.neo4j.jdbc.internal.shaded.jooq.conf.ParamType;
import org.neo4j.jdbc.internal.shaded.jooq.conf.Settings;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultDiagnosticsContext;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DiagnosticsListeners;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DiagnosticsStatement;
import org.neo4j.jdbc.internal.shaded.jooq.impl.ParserException;
import org.neo4j.jdbc.internal.shaded.jooq.tools.jdbc.DefaultConnection;

final class DiagnosticsConnection
extends DefaultConnection {
    static final int LRU_SIZE_GLOBAL = 50000;
    static final int LRU_SIZE_LOCAL = 500;
    static final int DUP_SIZE = 500;
    final Map<String, List<String>> repeatedSQL = new LRU<List<String>>(500);
    final Map<String, List<String>> consecutiveAgg = new LRU<List<String>>(500);
    final Configuration configuration;
    final Configuration configurationTranformPatterns;
    final RenderContext normalisingRenderer;
    final Parser parser;
    final DiagnosticsListeners listeners;
    final boolean release;

    DiagnosticsConnection(Configuration configuration) {
        this(configuration, null);
    }

    DiagnosticsConnection(Configuration configuration, Connection c) {
        super(c != null ? c : configuration.connectionProvider().acquire());
        this.release = c == null;
        this.configuration = configuration;
        this.configurationTranformPatterns = configuration.deriveSettings(s -> s.withTransformPatterns(true));
        this.normalisingRenderer = configuration.deriveSettings(s -> s.withParamType(ParamType.FORCE_INDEXED).withInListPadding(true).withInListPadBase(16)).dsl().renderContext();
        this.parser = configuration.dsl().parser();
        this.listeners = DiagnosticsListeners.get(configuration);
    }

    @Override
    public final Statement createStatement() throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().createStatement());
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql)), sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql), resultSetType, resultSetConcurrency), sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql), resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql), autoGeneratedKeys), sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql), columnIndexes), sql);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareStatement(this.parse(sql), columnNames), sql);
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareCall(this.parse(sql)), sql);
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareCall(this.parse(sql), resultSetType, resultSetConcurrency), sql);
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new DiagnosticsStatement(this, this.getDelegate().prepareCall(this.parse(sql), resultSetType, resultSetConcurrency, resultSetHoldability), sql);
    }

    @Override
    public final void close() throws SQLException {
        this.repeatedSQL.clear();
        if (this.release) {
            this.configuration.connectionProvider().release(this.getDelegate());
        }
    }

    final boolean checkPattern(Predicate<? super Settings> test) {
        return DiagnosticsListeners.checkPattern(this.configuration.settings(), test);
    }

    final boolean check(Predicate<? super Settings> test) {
        return DiagnosticsListeners.check(this.configuration.settings(), test);
    }

    final Map<String, Set<String>> duplicateSql() {
        return (Map)this.configuration.data().computeIfAbsent("org.neo4j.jdbc.internal.shaded.jooq.diagnostics.duplicate-sql", k -> Collections.synchronizedMap(new LRU(50000)));
    }

    final boolean disabled() {
        return this.configuration.settings().getDiagnosticsConnection() == org.neo4j.jdbc.internal.shaded.jooq.conf.DiagnosticsConnection.OFF;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final String parse(String sql) {
        String normalised;
        if (this.disabled()) {
            return sql;
        }
        Queries queries = null;
        Queries transformed = null;
        try {
            transformed = queries = this.parser.parse(sql);
            normalised = this.normalisingRenderer.render(transformed);
        }
        catch (ParserException exception) {
            normalised = sql;
            this.listeners.exception(new DefaultDiagnosticsContext(this.configuration, "Query could not be parsed.", sql, exception));
        }
        try {
            List<String> repetitions;
            Set<String> duplicates;
            if (this.check(Settings::isDiagnosticsDuplicateStatements) && (duplicates = this.duplicates(this.duplicateSql(), sql, normalised)) != null) {
                this.listeners.duplicateStatements(new DefaultDiagnosticsContext(this.configuration, "Duplicate statements encountered.", sql, normalised, duplicates, null, queries, transformed, null));
            }
            if (this.check(Settings::isDiagnosticsRepeatedStatements) && (repetitions = this.repetitions(this.repeatedSQL, sql, normalised)) != null) {
                this.listeners.repeatedStatements(new DefaultDiagnosticsContext(this.configuration, "Repeated statements encountered.", sql, normalised, null, repetitions, queries, transformed, null));
            }
            if (queries == null) return sql;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable exception) {
            this.listeners.exception(new DefaultDiagnosticsContext(this.configuration, "An unexpected exception has occurred. See exception for details.", sql, normalised, null, null, queries, transformed, exception));
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<String> duplicates(Map<String, Set<String>> map, String sql, String normalised) {
        Map<String, Set<String>> map2 = map;
        synchronized (map2) {
            Set v = map.computeIfAbsent(normalised, k -> new HashSet());
            if (v.size() >= 500 || v.add(sql) && v.size() > 1) {
                return v;
            }
            return null;
        }
    }

    private final List<String> repetitions(Map<String, List<String>> map, String sql, String normalised) {
        List v = map.computeIfAbsent(normalised, k -> new ArrayList());
        if (v.size() >= 500 || v.add(sql) && v.size() > 1) {
            return v;
        }
        return null;
    }

    static final class LRU<V>
    extends LinkedHashMap<String, V> {
        private final int size;

        LRU(int size) {
            super(size + 1, 1.0f, true);
            this.size = size;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, V> eldest) {
            return this.size() > this.size;
        }
    }
}

