/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Set;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Keyword;
import org.neo4j.jdbc.internal.shaded.jooq.Query;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractQueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QueryPartCollectionView;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QueryPartList;
import org.neo4j.jdbc.internal.shaded.jooq.impl.TableList;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class ForLock
extends AbstractQueryPart
implements QOM.UNotYetImplemented {
    private static final Set<SQLDialect> NO_SUPPORT_FOR_UPDATE_QUALIFIED = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB);
    private static final Set<SQLDialect> NO_SUPPORT_STANDARD_FOR_SHARE = SQLDialect.supportedUntil(SQLDialect.MARIADB);
    private static final Set<SQLDialect> EMULATE_FOR_UPDATE_WAIT_MY = SQLDialect.supportedUntil(SQLDialect.MYSQL);
    private static final Set<SQLDialect> EMULATE_FOR_UPDATE_WAIT_PG = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    QueryPartList<Field<?>> forLockOf;
    TableList forLockOfTables;
    ForLockMode forLockMode;
    ForLockWaitMode forLockWaitMode;
    int forLockWait;

    ForLock() {
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (this.forLockMode.ordinal()) {
            case 2: {
                if (NO_SUPPORT_STANDARD_FOR_SHARE.contains((Object)ctx.dialect())) {
                    ctx.formatSeparator().visit(Keywords.K_LOCK_IN_SHARE_MODE);
                    break;
                }
                ctx.formatSeparator().visit(Keywords.K_FOR).sql(' ').visit(this.forLockMode.toKeyword());
                break;
            }
            default: {
                ctx.formatSeparator().visit(Keywords.K_FOR).sql(' ').visit(this.forLockMode.toKeyword());
            }
        }
        if (Tools.isNotEmpty(this.forLockOf)) {
            ctx.qualify(!NO_SUPPORT_FOR_UPDATE_QUALIFIED.contains((Object)ctx.dialect()) && ctx.qualify(), c -> c.sql(' ').visit(Keywords.K_OF).sql(' ').visit(this.forLockOf));
        } else if (Tools.isNotEmpty(this.forLockOfTables)) {
            ctx.sql(' ').visit(Keywords.K_OF).sql(' ');
            switch (ctx.family()) {
                case DERBY: {
                    this.forLockOfTables.toSQLFields(ctx);
                    break;
                }
                default: {
                    ctx.visit(QueryPartCollectionView.wrap(this.forLockOfTables).qualify(false));
                }
            }
        }
        if (ctx.family() == SQLDialect.FIREBIRD) {
            ctx.sql(' ').visit(Keywords.K_WITH_LOCK);
        }
        if (this.forLockWaitMode != null) {
            if (this.forLockWaitMode == ForLockWaitMode.WAIT && EMULATE_FOR_UPDATE_WAIT_PG.contains((Object)ctx.dialect())) {
                Tools.prependSQL(ctx.skipUpdateCount(), new Query[]{ctx.dsl().setLocal(Names.N_LOCK_TIMEOUT, DSL.inline(this.forLockWait * 1000))});
            } else if (this.forLockWaitMode == ForLockWaitMode.WAIT && EMULATE_FOR_UPDATE_WAIT_MY.contains((Object)ctx.dialect())) {
                if (ctx.data(Tools.BooleanDataKey.DATA_LOCK_WAIT_TIMEOUT_SET) == null) {
                    ctx.skipUpdateCounts(2).data(Tools.BooleanDataKey.DATA_LOCK_WAIT_TIMEOUT_SET, true);
                    Tools.prependSQL(ctx, ctx.dsl().query("{set} @t = @@innodb_lock_wait_timeout"), ctx.dsl().query("{set} @@innodb_lock_wait_timeout = {0}", DSL.inline(this.forLockWait)));
                    Tools.appendSQL(ctx, ctx.dsl().query("{set} @@innodb_lock_wait_timeout = @t"));
                }
            } else {
                ctx.sql(' ').visit(this.forLockWaitMode.toKeyword());
                if (this.forLockWaitMode == ForLockWaitMode.WAIT) {
                    ctx.sql(' ').sql(this.forLockWait);
                }
            }
        }
    }

    static enum ForLockMode {
        UPDATE("update"),
        NO_KEY_UPDATE("no key update"),
        SHARE("share"),
        KEY_SHARE("key share");

        private final Keyword keyword;

        private ForLockMode(String sql) {
            this.keyword = DSL.keyword(sql);
        }

        public final Keyword toKeyword() {
            return this.keyword;
        }
    }

    static enum ForLockWaitMode {
        WAIT("wait"),
        NOWAIT("nowait"),
        SKIP_LOCKED("skip locked");

        private final Keyword keyword;

        private ForLockWaitMode(String sql) {
            this.keyword = DSL.keyword(sql);
        }

        public final Keyword toKeyword() {
            return this.keyword;
        }
    }
}

