/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.neo4j.jdbc.internal.shaded.jooq.Binding;
import org.neo4j.jdbc.internal.shaded.jooq.Check;
import org.neo4j.jdbc.internal.shaded.jooq.Comment;
import org.neo4j.jdbc.internal.shaded.jooq.Converter;
import org.neo4j.jdbc.internal.shaded.jooq.ConverterContext;
import org.neo4j.jdbc.internal.shaded.jooq.DataType;
import org.neo4j.jdbc.internal.shaded.jooq.Domain;
import org.neo4j.jdbc.internal.shaded.jooq.EmbeddableRecord;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.ForeignKey;
import org.neo4j.jdbc.internal.shaded.jooq.Generator;
import org.neo4j.jdbc.internal.shaded.jooq.Identity;
import org.neo4j.jdbc.internal.shaded.jooq.Index;
import org.neo4j.jdbc.internal.shaded.jooq.InverseForeignKey;
import org.neo4j.jdbc.internal.shaded.jooq.Name;
import org.neo4j.jdbc.internal.shaded.jooq.OrderField;
import org.neo4j.jdbc.internal.shaded.jooq.ParamMode;
import org.neo4j.jdbc.internal.shaded.jooq.Parameter;
import org.neo4j.jdbc.internal.shaded.jooq.QueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.RecordQualifier;
import org.neo4j.jdbc.internal.shaded.jooq.Result;
import org.neo4j.jdbc.internal.shaded.jooq.Row;
import org.neo4j.jdbc.internal.shaded.jooq.Schema;
import org.neo4j.jdbc.internal.shaded.jooq.Sequence;
import org.neo4j.jdbc.internal.shaded.jooq.Support;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.TableField;
import org.neo4j.jdbc.internal.shaded.jooq.UDTField;
import org.neo4j.jdbc.internal.shaded.jooq.UDTPathField;
import org.neo4j.jdbc.internal.shaded.jooq.UDTPathTableField;
import org.neo4j.jdbc.internal.shaded.jooq.UniqueKey;
import org.neo4j.jdbc.internal.shaded.jooq.exception.DataAccessException;
import org.neo4j.jdbc.internal.shaded.jooq.exception.DataTypeException;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractRecord;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractRow;
import org.neo4j.jdbc.internal.shaded.jooq.impl.CheckImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Convert;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultBinding;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultConverterContext;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DomainImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.EmbeddableTableField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.IAdd;
import org.neo4j.jdbc.internal.shaded.jooq.impl.IDiv;
import org.neo4j.jdbc.internal.shaded.jooq.impl.IMul;
import org.neo4j.jdbc.internal.shaded.jooq.impl.ISub;
import org.neo4j.jdbc.internal.shaded.jooq.impl.IdentityImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.IndexImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Lazy;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Neg;
import org.neo4j.jdbc.internal.shaded.jooq.impl.ParameterImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.ReferenceImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.ResultImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SequenceImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.TableImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.impl.UDTPathFieldImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.UniqueKeyImpl;
import org.neo4j.jdbc.internal.shaded.jooq.tools.reflect.Reflect;
import org.neo4j.jdbc.internal.shaded.jooq.tools.reflect.ReflectException;
import org.neo4j.jdbc.internal.shaded.reactivestreams.Subscriber;
import org.neo4j.jdbc.internal.shaded.reactivestreams.Subscription;

@org.neo4j.jdbc.internal.shaded.jooq.Internal
public final class Internal {
    private static final Lazy<ConverterContext> CONVERTER_SCOPE = Lazy.of(() -> new DefaultConverterContext(Tools.CONFIG.get()));
    private static final Lazy<Integer> JAVA_VERSION = Lazy.of(() -> {
        try {
            return (Integer)Reflect.onClass(Runtime.class).call("version").call("feature").get();
        }
        catch (ReflectException e) {
            return 8;
        }
    });

    public static final <R extends Record, T, P extends UDTPathTableField<R, ?, T>> P createUDTPathTableField(Name name, DataType<T> type, Table<R> table, Class<P> returnType) {
        return Internal.createUDTPathTableField(name, type, table, null, returnType, null, null, null);
    }

    public static final <R extends Record, T, P extends UDTPathTableField<R, ?, T>> P createUDTPathTableField(Name name, DataType<T> type, Table<R> table, String comment, Class<P> returnType) {
        return Internal.createUDTPathTableField(name, type, table, comment, returnType, null, null, null);
    }

    public static final <R extends Record, T, U, P extends UDTPathTableField<R, ?, U>> P createUDTPathTableField(Name name, DataType<T> type, Table<R> table, String comment, Class<P> returnType, Converter<T, U> converter) {
        return Internal.createUDTPathTableField(name, type, table, comment, returnType, converter, null, null);
    }

    public static final <R extends Record, T, U, P extends UDTPathTableField<R, ?, U>> P createUDTPathTableField(Name name, DataType<T> type, Table<R> table, String comment, Class<P> returnType, Binding<T, U> binding) {
        return Internal.createUDTPathTableField(name, type, table, comment, returnType, null, binding, null);
    }

    public static final <R extends Record, T, X, U, P extends UDTPathTableField<R, ?, U>> P createUDTPathTableField(Name name, DataType<T> type, Table<R> table, String comment, Class<P> returnType, Converter<X, U> converter, Binding<T, X> binding) {
        return Internal.createUDTPathTableField(name, type, table, comment, returnType, converter, binding, null);
    }

    public static final <R extends Record, TR extends Table<R>, T, P extends UDTPathTableField<R, ?, T>> P createUDTPathTableField(Name name, DataType<T> type, TR table, String comment, Class<P> returnType, Generator<R, TR, T> generator) {
        return Internal.createUDTPathTableField(name, type, table, comment, returnType, null, null, generator);
    }

    public static final <R extends Record, TR extends Table<R>, T, U, P extends UDTPathTableField<R, ?, U>> P createUDTPathTableField(Name name, DataType<T> type, TR table, String comment, Class<P> returnType, Converter<T, U> converter, Generator<R, TR, U> generator) {
        return Internal.createUDTPathTableField(name, type, table, comment, returnType, converter, null, generator);
    }

    public static final <R extends Record, TR extends Table<R>, T, U, P extends UDTPathTableField<R, ?, U>> P createUDTPathTableField(Name name, DataType<T> type, TR table, String comment, Class<P> returnType, Binding<T, U> binding, Generator<R, TR, U> generator) {
        return Internal.createUDTPathTableField(name, type, table, comment, returnType, null, binding, generator);
    }

    public static final <R extends Record, TR extends Table<R>, T, X, U, P extends UDTPathTableField<R, ?, U>> P createUDTPathTableField(Name name, DataType<T> type, TR table, String comment, Class<P> returnType, Converter<X, U> converter, Binding<T, X> binding, Generator<R, TR, U> generator) {
        DataType<Object> actualType;
        Binding<T, U> actualBinding = DefaultBinding.newBinding(converter, type, binding);
        DataType<Object> dataType = actualType = converter == null && binding == null ? type : type.asConvertedDataType(actualBinding);
        if (generator != null) {
            actualType = actualType.generatedAlwaysAs(generator).generationLocation(QOM.GenerationLocation.CLIENT);
        }
        try {
            UDTPathTableField tableField = (UDTPathTableField)Internal.newInstance(name, table, null, comment, returnType, actualBinding, actualType);
            if (table instanceof TableImpl) {
                TableImpl t = (TableImpl)table;
                t.fields.add(tableField);
            }
            return (P)tableField;
        }
        catch (Exception e) {
            throw new DataTypeException("Cannot instantiate " + String.valueOf(returnType) + ".", e);
        }
    }

    public static final <T, P extends UDTField<?, T>> P createUDTPathField(Name name, DataType<T> type, UDTPathField<?, ?, ?> qualifier, Class<P> returnType) {
        return Internal.createUDTPathField(name, type, qualifier, null, returnType, null, null);
    }

    public static final <T, P extends UDTField<?, T>> P createUDTPathField(Name name, DataType<T> type, UDTPathField<?, ?, ?> qualifier, String comment, Class<P> returnType) {
        return Internal.createUDTPathField(name, type, qualifier, comment, returnType, null, null);
    }

    public static final <T, U, P extends UDTField<?, U>> P createUDTPathField(Name name, DataType<T> type, UDTPathField<?, ?, ?> qualifier, String comment, Class<P> returnType, Converter<T, U> converter) {
        return Internal.createUDTPathField(name, type, qualifier, comment, returnType, converter, null);
    }

    public static final <T, U, P extends UDTField<?, U>> P createUDTPathField(Name name, DataType<T> type, UDTPathField<?, ?, ?> qualifier, String comment, Class<P> returnType, Binding<T, U> binding) {
        return Internal.createUDTPathField(name, type, qualifier, comment, returnType, null, binding);
    }

    public static final <T, X, U, P extends UDTField<?, U>> P createUDTPathField(Name name, DataType<T> type, UDTPathField<?, ?, ?> qualifier, String comment, Class<P> returnType, Converter<X, U> converter, Binding<T, X> binding) {
        Binding<T, U> actualBinding = DefaultBinding.newBinding(converter, type, binding);
        DataType<Object> actualType = converter == null && binding == null ? type : type.asConvertedDataType(actualBinding);
        try {
            return Internal.newInstance(name, null, qualifier, comment, returnType, actualBinding, actualType);
        }
        catch (Exception e) {
            throw new DataTypeException("Cannot instantiate " + String.valueOf(returnType) + ".", e);
        }
    }

    private static <T, X, U, P extends UDTField<?, U>> P newInstance(Name name, RecordQualifier<?> qualifier, UDTPathField<?, ?, ?> path, String comment, Class<P> returnType, Binding<T, U> actualBinding, DataType<U> actualType) throws Exception {
        if (returnType == UDTField.class) {
            return (P)new UDTPathFieldImpl(name, actualType, path.asQualifier(), path.getUDT(), DSL.comment(comment), actualBinding);
        }
        return (P)((UDTField)returnType.getConstructor(Name.class, DataType.class, RecordQualifier.class, Comment.class, Binding.class).newInstance(name, actualType, qualifier == null ? path.asQualifier() : qualifier, DSL.comment(comment), actualBinding));
    }

    @SafeVarargs
    @NotNull
    public static final <R extends Record, E extends EmbeddableRecord<E>> TableField<R, E> createEmbeddable(Name name, Class<E> recordType, Table<R> table, TableField<R, ?> ... fields) {
        return Internal.createEmbeddable(name, recordType, false, table, fields);
    }

    @SafeVarargs
    @NotNull
    public static final <R extends Record, E extends EmbeddableRecord<E>> TableField<R, E> createEmbeddable(Name name, Class<E> recordType, boolean replacesFields, Table<R> table, TableField<R, ?> ... fields) {
        return new EmbeddableTableField<R, E>(name, recordType, replacesFields, table, fields);
    }

    @NotNull
    public static final Index createIndex(Name name, Table<?> table, OrderField<?>[] sortFields, boolean unique) {
        return new IndexImpl(name, table, sortFields, null, unique);
    }

    @NotNull
    public static final <R extends Record, T> Identity<R, T> createIdentity(Table<R> table, TableField<R, T> field) {
        return new IdentityImpl<R, T>(table, field);
    }

    @SafeVarargs
    @NotNull
    public static final <R extends Record> UniqueKey<R> createUniqueKey(Table<R> table, TableField<R, ?> ... fields) {
        return Internal.createUniqueKey(table, (Name)null, fields, true);
    }

    @SafeVarargs
    @NotNull
    public static final <R extends Record> UniqueKey<R> createUniqueKey(Table<R> table, Name name, TableField<R, ?> ... fields) {
        return Internal.createUniqueKey(table, name, fields, true);
    }

    @NotNull
    public static final <R extends Record> UniqueKey<R> createUniqueKey(Table<R> table, Name name, TableField<R, ?>[] fields, boolean enforced) {
        return new UniqueKeyImpl<R>(table, name, fields, enforced);
    }

    @NotNull
    public static final <R extends Record, ER extends EmbeddableRecord<ER>> UniqueKey<R> createUniqueKey(Table<R> table, Name name, TableField<R, ER> embeddableField, boolean enforced) {
        return Internal.createUniqueKey(table, name, Internal.fields(embeddableField), enforced);
    }

    @Deprecated
    @SafeVarargs
    @NotNull
    public static final <R extends Record, U extends Record> ForeignKey<R, U> createForeignKey(UniqueKey<U> key, Table<R> table, TableField<R, ?> ... fields) {
        return Internal.createForeignKey(table, (Name)null, fields, key, key.getFieldsArray(), true);
    }

    @NotNull
    public static final <R extends Record, U extends Record> ForeignKey<R, U> createForeignKey(Table<R> table, Name name, TableField<R, ?>[] fkFields, UniqueKey<U> uk, TableField<U, ?>[] ukFields, boolean enforced) {
        ReferenceImpl<R, Object> result = new ReferenceImpl<R, Object>(table, name, fkFields, uk, ukFields == null ? uk.getFieldsArray() : ukFields, enforced);
        if (uk instanceof UniqueKeyImpl) {
            UniqueKeyImpl u = (UniqueKeyImpl)uk;
            u.references.add(result);
        }
        return result;
    }

    @NotNull
    public static final <R extends Record, U extends Record, ER extends EmbeddableRecord<ER>> ForeignKey<R, U> createForeignKey(Table<R> table, Name name, TableField<R, ER> fkEmbeddableField, UniqueKey<U> uk, TableField<U, ER> ukEmbeddableField, boolean enforced) {
        return Internal.createForeignKey(table, name, Internal.fields(fkEmbeddableField), uk, Internal.fields(ukEmbeddableField), enforced);
    }

    @NotNull
    public static final <T extends Number> Sequence<T> createSequence(String name, Schema schema, DataType<T> type) {
        return new SequenceImpl<T>(name, schema, type, false);
    }

    @NotNull
    public static final <T extends Number> Sequence<T> createSequence(String name, Schema schema, DataType<T> type, Number startWith, Number incrementBy, Number minvalue, Number maxvalue, boolean cycle, Number cache) {
        return new SequenceImpl<T>(DSL.name(name), schema, type, false, startWith != null ? Tools.field((Object)startWith, type) : null, incrementBy != null ? Tools.field((Object)incrementBy, type) : null, minvalue != null ? Tools.field((Object)minvalue, type) : null, maxvalue != null ? Tools.field((Object)maxvalue, type) : null, cycle, cache != null ? Tools.field((Object)cache, type) : null);
    }

    @NotNull
    public static final <R extends Record> Check<R> createCheck(Table<R> table, Name name, String condition) {
        return Internal.createCheck(table, name, condition, true);
    }

    @NotNull
    public static final <R extends Record> Check<R> createCheck(Table<R> table, Name name, String condition, boolean enforced) {
        return new CheckImpl<R>(table, name, DSL.condition(condition), enforced);
    }

    @NotNull
    public static final <T> Domain<T> createDomain(Schema schema, Name name, DataType<T> type, Check<?> ... checks) {
        return Internal.createDomain(schema, name, type, null, null, checks);
    }

    @NotNull
    public static final <T, U> Domain<U> createDomain(Schema schema, Name name, DataType<T> type, Converter<T, U> converter, Check<?> ... checks) {
        return Internal.createDomain(schema, name, type, converter, null, checks);
    }

    @NotNull
    public static final <T, U> Domain<U> createDomain(Schema schema, Name name, DataType<T> type, Binding<T, U> binding, Check<?> ... checks) {
        return Internal.createDomain(schema, name, type, null, binding, checks);
    }

    @NotNull
    public static final <T, X, U> Domain<U> createDomain(Schema schema, Name name, DataType<T> type, Converter<X, U> converter, Binding<T, X> binding, Check<?> ... checks) {
        Binding<T, U> actualBinding = DefaultBinding.newBinding(converter, type, binding);
        DataType<Object> actualType = converter == null && binding == null ? type : type.asConvertedDataType(actualBinding);
        return new DomainImpl<T>(schema, name, actualType, checks);
    }

    @NotNull
    public static final Name createPathAlias(Table<?> path, ForeignKey<?, ?> childPath, InverseForeignKey<?, ?> parentPath) {
        Name name;
        Name name2 = name = childPath != null ? DSL.name(childPath.getName()) : DSL.name(parentPath.getName() + ".inverse." + parentPath.getForeignKey().getTable().getName());
        if (path instanceof TableImpl) {
            TableImpl t = (TableImpl)path;
            name = t.path != null ? Internal.createPathAlias(t.path, t.childPath, t.parentPath).append(name) : path.getQualifiedName().append(name);
        }
        return DSL.name("alias_" + Internal.hash(name));
    }

    @NotNull
    public static final <T> Parameter<T> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed) {
        return Internal.createParameter(name, type, isDefaulted, isUnnamed, null, null);
    }

    @NotNull
    public static final <T, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed, Converter<T, U> converter) {
        return Internal.createParameter(name, type, isDefaulted, isUnnamed, converter, null);
    }

    @NotNull
    public static final <T, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed, Binding<T, U> binding) {
        return Internal.createParameter(name, type, isDefaulted, isUnnamed, null, binding);
    }

    @NotNull
    public static final <T, X, U> Parameter<U> createParameter(String name, DataType<T> type, boolean isDefaulted, boolean isUnnamed, Converter<X, U> converter, Binding<T, X> binding) {
        Binding<T, U> actualBinding = DefaultBinding.newBinding(converter, type, binding);
        DataType<Object> actualType = converter == null && binding == null ? type : type.asConvertedDataType(actualBinding);
        return new ParameterImpl<T>(ParamMode.IN, DSL.name(name), actualType, isDefaulted, isUnnamed);
    }

    private Internal() {
    }

    @Deprecated(since="3.14", forRemoval=true)
    @NotNull
    public static final Index createIndex(String name, Table<?> table, OrderField<?>[] sortFields, boolean unique) {
        return Internal.createIndex(DSL.name(name), table, sortFields, unique);
    }

    @SafeVarargs
    @Deprecated(since="3.14", forRemoval=true)
    @NotNull
    public static final <R extends Record> UniqueKey<R> createUniqueKey(Table<R> table, String name, TableField<R, ?> ... fields) {
        return Internal.createUniqueKey(table, name, fields, true);
    }

    @Deprecated(since="3.14", forRemoval=true)
    @NotNull
    public static final <R extends Record> UniqueKey<R> createUniqueKey(Table<R> table, String name, TableField<R, ?>[] fields, boolean enforced) {
        return Internal.createUniqueKey(table, DSL.name(name), fields, enforced);
    }

    @SafeVarargs
    @Deprecated(since="3.14", forRemoval=true)
    @NotNull
    public static final <R extends Record, U extends Record> ForeignKey<R, U> createForeignKey(UniqueKey<U> key, Table<R> table, String name, TableField<R, ?> ... fields) {
        return Internal.createForeignKey(key, table, name, fields, true);
    }

    @Deprecated(since="3.14", forRemoval=true)
    @NotNull
    public static final <R extends Record, U extends Record> ForeignKey<R, U> createForeignKey(UniqueKey<U> key, Table<R> table, String name, TableField<R, ?>[] fields, boolean enforced) {
        return Internal.createForeignKey(table, DSL.name(name), fields, key, key.getFieldsArray(), enforced);
    }

    @Deprecated(since="3.14", forRemoval=true)
    @NotNull
    public static final <R extends Record, ER extends EmbeddableRecord<ER>> TableField<R, ?>[] fields(TableField<R, ER> embeddableField) {
        return ((EmbeddableTableField)embeddableField).fields;
    }

    @Deprecated(since="3.16", forRemoval=true)
    @NotNull
    public static final <R extends Record, ER extends EmbeddableRecord<ER>> Row fieldsRow(TableField<R, ER> embeddableField) {
        return embeddableField.getDataType().getRow();
    }

    @Support
    static final <T> Field<T> ineg(Field<T> field) {
        return new Neg<T>(field, true);
    }

    @Support
    static final <T> Field<T> iadd(Field<T> lhs, Field<?> rhs) {
        return new IAdd<T>(lhs, Tools.nullSafe(rhs, lhs.getDataType()));
    }

    @Support
    static final <T> Field<T> isub(Field<T> lhs, Field<?> rhs) {
        return new ISub<T>(lhs, Tools.nullSafe(rhs, lhs.getDataType()));
    }

    @Support
    static final <T> Field<T> imul(Field<T> lhs, Field<?> rhs) {
        return new IMul<T>(lhs, Tools.nullSafe(rhs, lhs.getDataType()));
    }

    @Support
    static final <T> Field<T> idiv(Field<T> lhs, Field<?> rhs) {
        return new IDiv<T>(lhs, Tools.nullSafe(rhs, lhs.getDataType()));
    }

    public static final <T> Subscriber<T> subscriber(final Consumer<? super Subscription> subscription, final Consumer<? super T> onNext, final Consumer<? super Throwable> onError, final Runnable onComplete) {
        return new Subscriber<T>(){

            @Override
            public void onSubscribe(Subscription s) {
                subscription.accept(s);
            }

            @Override
            public void onNext(T t) {
                onNext.accept(t);
            }

            @Override
            public void onError(Throwable t) {
                onError.accept(t);
            }

            @Override
            public void onComplete() {
                onComplete.run();
            }
        };
    }

    public static final <T> Class<T[]> arrayType(Class<T> type) {
        return type.arrayType();
    }

    public static final <R extends Record> Result<R> result(R record) {
        return new ResultImpl(Tools.configuration(record), (AbstractRow)((AbstractRecord)record).fields);
    }

    public static final boolean commercial() {
        return Tools.CONFIG.get().commercial();
    }

    public static final boolean commercial(Supplier<String> logMessage) {
        return Tools.CONFIG.get().commercial(logMessage);
    }

    public static final void requireCommercial(Supplier<String> logMessage) throws DataAccessException {
        Tools.CONFIG.get().requireCommercial(logMessage);
    }

    public static final int hash(QueryPart part) {
        return Internal.hash0(Tools.CTX.get().render(part));
    }

    static final int hash0(Object object) {
        if (object == null) {
            return 0;
        }
        return 0x7FFFFFF & object.hashCode();
    }

    public static final ConverterContext converterContext() {
        return CONVERTER_SCOPE.get();
    }

    public static final int javaVersion() {
        return JAVA_VERSION.get();
    }

    @Deprecated(forRemoval=true)
    public static final Object[] convert(Object[] values, Field<?>[] fields) {
        return Convert.convert(values, fields);
    }

    @Deprecated(forRemoval=true)
    public static final Object[] convert(Object[] values, Class<?>[] types) {
        return Convert.convert(values, types);
    }

    @Deprecated(forRemoval=true)
    public static final <U> U[] convertArray(Object[] from, Converter<?, ? extends U> converter) throws DataTypeException {
        return Convert.convertArray(from, converter);
    }

    @Deprecated(forRemoval=true)
    public static final Object[] convertArray(Object[] from, Class<?> toClass) throws DataTypeException {
        return Convert.convertArray(from, toClass);
    }

    @Deprecated(forRemoval=true)
    public static final <U> U[] convertCollection(Collection from, Class<? extends U[]> to) {
        return Convert.convertCollection(from, to);
    }

    @Deprecated(forRemoval=true)
    public static final <U> U convert(Object from, Converter<?, ? extends U> converter) throws DataTypeException {
        return Convert.convert(from, converter);
    }

    @Deprecated(forRemoval=true)
    public static final <T> T convert(Object from, Class<? extends T> toClass) throws DataTypeException {
        return Convert.convert(from, toClass);
    }

    @Deprecated(forRemoval=true)
    public static final <T> List<T> convert(Collection<?> collection, Class<? extends T> type) throws DataTypeException {
        return Convert.convert(collection, type);
    }

    @Deprecated(forRemoval=true)
    public static final <U> List<U> convert(Collection<?> collection, Converter<?, ? extends U> converter) throws DataTypeException {
        return Convert.convert(collection, converter);
    }
}

