/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Collection;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.DataType;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function0;
import org.neo4j.jdbc.internal.shaded.jooq.Function1;
import org.neo4j.jdbc.internal.shaded.jooq.Function4;
import org.neo4j.jdbc.internal.shaded.jooq.JSON;
import org.neo4j.jdbc.internal.shaded.jooq.JSONB;
import org.neo4j.jdbc.internal.shaded.jooq.JSONEntry;
import org.neo4j.jdbc.internal.shaded.jooq.JSONObjectNullStep;
import org.neo4j.jdbc.internal.shaded.jooq.JSONObjectReturningStep;
import org.neo4j.jdbc.internal.shaded.jooq.QueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractQueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.impl.CustomField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.JSONArray;
import org.neo4j.jdbc.internal.shaded.jooq.impl.JSONArrayAgg;
import org.neo4j.jdbc.internal.shaded.jooq.impl.JSONEntryImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.JSONNull;
import org.neo4j.jdbc.internal.shaded.jooq.impl.JSONReturning;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QueryPartCollectionView;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QueryPartList;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QueryPartListView;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.ScalarSubquery;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;

final class JSONObject<T>
extends AbstractField<T>
implements QOM.JSONObject<T>,
JSONObjectNullStep<T>,
JSONObjectReturningStep<T> {
    final DataType<T> type;
    final QueryPartListView<? extends JSONEntry<?>> entries;
    QOM.JSONOnNull onNull;
    DataType<?> returning;

    JSONObject(DataType<T> type, Collection<? extends JSONEntry<?>> entries) {
        this(type, entries, null, null);
    }

    JSONObject(DataType<T> type, Collection<? extends JSONEntry<?>> entries, QOM.JSONOnNull onNull, DataType<?> returning) {
        super(Names.N_JSON_OBJECT, type);
        this.type = type;
        this.entries = new QueryPartList((Iterable<JSONEntry<?>>)entries);
        this.onNull = onNull;
        this.returning = returning;
    }

    @Override
    public final JSONObject<T> nullOnNull() {
        this.onNull = QOM.JSONOnNull.NULL_ON_NULL;
        return this;
    }

    @Override
    public final JSONObject<T> absentOnNull() {
        this.onNull = QOM.JSONOnNull.ABSENT_ON_NULL;
        return this;
    }

    @Override
    public final JSONObject<T> returning(DataType<?> returning) {
        this.returning = returning;
        return this;
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                if (this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL) {
                    ctx.visit(DSL.unquotedName(this.getDataType().getType() == JSONB.class ? "jsonb_strip_nulls" : "json_strip_nulls")).sql('(');
                }
                ctx.visit(DSL.unquotedName(this.getDataType().getType() == JSONB.class ? "jsonb_build_object" : "json_build_object")).sql('(').visit(QueryPartCollectionView.wrap(this.entries)).sql(')');
                if (this.onNull != QOM.JSONOnNull.ABSENT_ON_NULL) break;
                ctx.sql(')');
                break;
            }
            case MARIADB: {
                JSONEntry first;
                if (this.entries.size() > 1) {
                    ctx.visit(JSONEntryImpl.jsonMerge(ctx, "{}", Tools.map(this.entries, e -> DSL.jsonObject(e), Field[]::new)));
                    break;
                }
                if (!this.entries.isEmpty() && JSONObject.isJSONArray((first = (JSONEntry)this.entries.iterator().next()).value())) {
                    ctx.visit(DSL.jsonObject(DSL.key(first.key()).value(JSONEntryImpl.jsonMerge(ctx, "[]", first.value()))));
                    break;
                }
                this.acceptStandard(ctx);
                break;
            }
            case MYSQL: {
                if (this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL) {
                    Field<String> k = DSL.field(DSL.name("jt", "k"), SQLDataType.VARCHAR);
                    Field<JSON> o = DSL.field(DSL.name("j", "o"), SQLDataType.JSON);
                    ctx.visit(DSL.field(DSL.select(DSL.coalesce(DSL.jsonObjectAgg(k, DSL.function(Names.N_JSON_EXTRACT, SQLDataType.JSON, o, DSL.concat(DSL.inline("$.\""), k, DSL.inline("\"")))), new Field[]{DSL.jsonObject()})).from(DSL.select(CustomField.of("o", SQLDataType.JSON, c -> this.acceptStandard((Context<?>)c)).as((Field)o)).asTable("j"), DSL.jsonTable(DSL.function(Names.N_JSON_KEYS, SQLDataType.JSON, o), DSL.inline("$[*]")).column("k", SQLDataType.VARCHAR).path("$").asTable("jt")).where(DSL.function(Names.N_JSON_EXTRACT, SQLDataType.JSON, o, DSL.concat(DSL.inline("$.\""), k, DSL.inline("\""))).ne(DSL.inline("null").cast(SQLDataType.JSON)))));
                    break;
                }
                this.acceptStandard(ctx);
                break;
            }
            case TRINO: {
                ctx.visit(DSL.function(Names.N_MAP_FROM_ENTRIES, SQLDataType.JSON, JSONObject.absentOnNullIf(() -> this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL, e -> DSL.field("{0}[2]", e.getDataType(), new QueryPart[]{e}), DSL.array(Tools.map(this.entries, e -> DSL.function(Names.N_ROW, SQLDataType.JSON, e.key(), JSONEntryImpl.jsonCast(ctx, e.value()).cast(SQLDataType.JSON)))))).cast(SQLDataType.JSON));
                break;
            }
            default: {
                this.acceptStandard(ctx);
            }
        }
    }

    static final Field<?> absentOnNullIf(Function0<Boolean> test, Function1<Field<?>, Field<?>> e, Field<?> array) {
        if (test.get().booleanValue()) {
            return DSL.function(Names.N_FILTER, array.getDataType(), array, DSL.field("e -> {0}", SQLDataType.BOOLEAN, new QueryPart[]{e.apply(DSL.field(DSL.raw("e"), array.getDataType())).isNotNull()}));
        }
        return array;
    }

    private static final boolean isJSONArray(Field<?> field) {
        return field instanceof JSONArray || field instanceof JSONArrayAgg || field instanceof ScalarSubquery && JSONObject.isJSONArray(((ScalarSubquery)field).query.getSelect().get(0));
    }

    private final void acceptStandard(Context<?> ctx) {
        JSONNull jsonNull = this.entries.isEmpty() && ctx.family() == SQLDialect.H2 ? new JSONNull(QOM.JSONOnNull.NULL_ON_NULL) : (this.entries.isEmpty() && JSONNull.NO_SUPPORT_NULL_ON_EMPTY.contains((Object)ctx.dialect()) ? new JSONNull(null) : new JSONNull(this.onNull));
        JSONReturning jsonReturning = new JSONReturning(this.returning);
        ctx.visit(Names.N_JSON_OBJECT).sql('(').visit(QueryPartListView.wrap((QueryPart[])new AbstractQueryPart[]{QueryPartCollectionView.wrap(this.entries), jsonNull, jsonReturning}).separator("")).sql(')');
    }

    @Override
    public final DataType<T> $arg1() {
        return this.type;
    }

    @Override
    public final QOM.UnmodifiableList<? extends JSONEntry<?>> $arg2() {
        return QOM.unmodifiable(this.entries);
    }

    @Override
    public final QOM.JSONOnNull $arg3() {
        return this.onNull;
    }

    @Override
    public final DataType<?> $arg4() {
        return this.returning;
    }

    @Override
    public final QOM.JSONObject<T> $arg1(DataType<T> newValue) {
        return this.$constructor().apply(newValue, (Collection<JSONEntry<?>>)this.$arg2(), this.$arg3(), (DataType<?>)this.$arg4());
    }

    @Override
    public final QOM.JSONObject<T> $arg2(QOM.UnmodifiableList<? extends JSONEntry<?>> newValue) {
        return this.$constructor().apply((DataType<T>)this.$arg1(), (Collection<JSONEntry<?>>)newValue, this.$arg3(), (DataType<?>)this.$arg4());
    }

    @Override
    public final QOM.JSONObject<T> $arg3(QOM.JSONOnNull newValue) {
        return this.$constructor().apply((DataType<T>)this.$arg1(), (Collection<JSONEntry<?>>)this.$arg2(), newValue, (DataType<?>)this.$arg4());
    }

    @Override
    public final QOM.JSONObject<T> $arg4(DataType<?> newValue) {
        return this.$constructor().apply((DataType<T>)this.$arg1(), (Collection<JSONEntry<?>>)this.$arg2(), this.$arg3(), newValue);
    }

    @Override
    public final Function4<? super DataType<T>, ? super Collection<? extends JSONEntry<?>>, ? super QOM.JSONOnNull, ? super DataType<?>, ? extends QOM.JSONObject<T>> $constructor() {
        return (a1, a2, a3, a4) -> new JSONObject(a1, (Collection<? extends JSONEntry<?>>)((Collection<JSONEntry<?>>)a2), (QOM.JSONOnNull)((Object)a3), (DataType<?>)a4);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.JSONObject) {
            QOM.JSONObject o = (QOM.JSONObject)that;
            return StringUtils.equals(this.$type(), o.$type()) && StringUtils.equals(this.$entries(), o.$entries()) && StringUtils.equals((Object)this.$onNull(), (Object)o.$onNull()) && StringUtils.equals(this.$returning(), o.$returning());
        }
        return super.equals(that);
    }
}

