/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.jdbc.internal.shaded.jooq.BindContext;
import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Param;
import org.neo4j.jdbc.internal.shaded.jooq.QueryPartInternal;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractBindContext;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;

final class ParamCollector
extends AbstractBindContext {
    final Map<String, Param<?>> resultFlat = new LinkedHashMap();
    final Map<String, List<Param<?>>> result = new LinkedHashMap();
    final List<Map.Entry<String, Param<?>>> resultList = new ArrayList();
    private final boolean includeInlinedParams;

    ParamCollector(Configuration configuration, boolean includeInlinedParams) {
        super(configuration, null, null);
        this.includeInlinedParams = includeInlinedParams;
    }

    @Override
    protected final void bindInternal(QueryPartInternal internal) {
        if (internal instanceof Param) {
            Param param = (Param)((Object)internal);
            if (this.includeInlinedParams || !param.isInline()) {
                String i = String.valueOf(this.nextIndex());
                String paramName = param.getParamName();
                if (StringUtils.isBlank(paramName)) {
                    this.resultFlat.put(i, param);
                    this.resultList.add(new AbstractMap.SimpleImmutableEntry<String, Param>(i, param));
                    this.result(i).add(param);
                } else {
                    this.resultFlat.put(param.getParamName(), param);
                    this.resultList.add(new AbstractMap.SimpleImmutableEntry<String, Param>(param.getParamName(), param));
                    this.result(param.getParamName()).add(param);
                }
            }
        } else {
            super.bindInternal(internal);
        }
    }

    private final List<Param<?>> result(String key) {
        return this.result.computeIfAbsent(key, k -> new ArrayList());
    }

    @Override
    protected final BindContext bindValue0(Object value, Field<?> field) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

