/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.BindContext;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.QualifiedRecord;
import org.neo4j.jdbc.internal.shaded.jooq.RecordQualifier;
import org.neo4j.jdbc.internal.shaded.jooq.RenderContext;
import org.neo4j.jdbc.internal.shaded.jooq.Scope;
import org.neo4j.jdbc.internal.shaded.jooq.conf.ParamType;
import org.neo4j.jdbc.internal.shaded.jooq.exception.SQLDialectNotSupportedException;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractParam;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Cast;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultBinding;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class QualifiedRecordConstant<R extends QualifiedRecord<R>>
extends AbstractParam<R>
implements QOM.UNotYetImplemented {
    final RecordQualifier<R> qualifier;

    QualifiedRecordConstant(R value, RecordQualifier<R> qualifier) {
        super(value, qualifier.getDataType());
        this.qualifier = qualifier;
    }

    @Override
    public void accept(Context<?> ctx) {
        if (ctx instanceof RenderContext) {
            this.toSQL0((RenderContext)ctx);
        } else {
            this.bind0((BindContext)ctx);
        }
    }

    final void toSQL0(RenderContext ctx) {
        ParamType paramType = ctx.paramType();
        if (this.isInline()) {
            ctx.paramType(ParamType.INLINED);
        }
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                this.toSQLInline(ctx);
                break;
            }
            default: {
                this.toSQLInline(ctx);
            }
        }
        if (this.isInline()) {
            ctx.paramType(paramType);
        }
    }

    private final void toSQLInline(RenderContext ctx) {
        Cast.renderCastIf(ctx, c -> {
            if (this.value == null) {
                c.visit(Keywords.K_NULL);
            } else {
                switch (c.family()) {
                    case POSTGRES: 
                    case YUGABYTEDB: {
                        c.visit(Keywords.K_ROW);
                        break;
                    }
                    default: {
                        c.visit(this.mappedQualifier(ctx));
                    }
                }
                c.sql('(');
                String separator = "";
                for (Field<?> field : ((QualifiedRecord)this.value).fields()) {
                    c.sql(separator);
                    c.visit(DSL.val(((QualifiedRecord)this.value).get(field), field));
                    separator = ", ";
                }
                c.sql(')');
            }
        }, c -> c.visit(this.mappedQualifier(ctx)), () -> DefaultBinding.DefaultRecordBinding.REQUIRE_RECORD_CAST.contains((Object)ctx.dialect()));
    }

    private final RecordQualifier<?> mappedQualifier(RenderContext ctx) {
        RecordQualifier<?> mapped = Tools.getMappedQualifier(ctx, this.qualifier);
        return mapped != null ? mapped : this.qualifier;
    }

    @Deprecated
    private final String getInlineConstructor(RenderContext ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                return "ROW";
            }
        }
        return Tools.getMappedUDTName((Scope)ctx, (QualifiedRecord)this.value);
    }

    final void bind0(BindContext ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                if (this.value == null) break;
                for (Field<?> field : ((QualifiedRecord)this.value).fields()) {
                    ctx.visit(DSL.val(((QualifiedRecord)this.value).get(field), field.getDataType()));
                }
                break;
            }
            default: {
                throw new SQLDialectNotSupportedException("UDTs not supported in dialect " + String.valueOf((Object)ctx.dialect()));
            }
        }
    }
}

