/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.jdbc.internal.shaded.jooq.CharacterSet;
import org.neo4j.jdbc.internal.shaded.jooq.Collation;
import org.neo4j.jdbc.internal.shaded.jooq.ConverterContext;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Generator;
import org.neo4j.jdbc.internal.shaded.jooq.Nullability;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.Row;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractRecord;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractRow;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class RecordDataType<R extends Record>
extends DefaultDataType<R> {
    final AbstractRow<R> row;

    RecordDataType(Row row) {
        this(row, Tools.recordType(row.size()), "record");
    }

    RecordDataType(Row row, Class<R> recordType, String name) {
        super(null, recordType, name, RecordDataType.nullability(row));
        this.row = (AbstractRow)row;
    }

    static final Nullability nullability(Row row) {
        return Tools.anyMatch(row.fields(), f -> f.getDataType().nullable()) ? Nullability.NULL : Nullability.NOT_NULL;
    }

    RecordDataType(DefaultDataType<R> t, AbstractRow<R> row, Integer precision, Integer scale, Integer length, Nullability nullability, boolean readonly, Generator<?, ?, R> generatedAlwaysAs, QOM.GenerationOption generationOption, QOM.GenerationLocation generationLocation, Collation collation, CharacterSet characterSet, boolean identity, Field<R> defaultValue) {
        super(t, precision, scale, length, nullability, readonly, generatedAlwaysAs, generationOption, generationLocation, collation, characterSet, identity, defaultValue);
        this.row = row;
    }

    @Override
    DefaultDataType<R> construct(Integer newPrecision, Integer newScale, Integer newLength, Nullability newNullability, boolean newReadonly, Generator<?, ?, R> newGeneratedAlwaysAs, QOM.GenerationOption newGenerationOption, QOM.GenerationLocation newGenerationLocation, Collation newCollation, CharacterSet newCharacterSet, boolean newIdentity, Field<R> newDefaultValue) {
        return new RecordDataType<R>(this, this.row, newPrecision, newScale, newLength, newNullability, newReadonly, newGeneratedAlwaysAs, newGenerationOption, newGenerationLocation, newCollation, newCharacterSet, newIdentity, newDefaultValue);
    }

    @Override
    public final Row getRow() {
        return this.row;
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return this.getType();
    }

    @Override
    final R convert(Object object, ConverterContext cc) {
        if (object instanceof Record && ((Record)object).fieldsRow().equals(this.row)) {
            return (R)((Record)object);
        }
        if (object instanceof Record || object instanceof Map || object instanceof List) {
            return (R)Tools.newRecord(true, this.getRecordType(), this.row, Tools.CONFIG.get()).operate(r -> {
                if (object instanceof Record) {
                    ((AbstractRecord)r).fromArray(((Record)object).intoArray());
                } else if (object instanceof Map) {
                    r.from(((Map)object).entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(Map.Entry::getValue).collect(Collectors.toList()));
                } else {
                    r.from(object);
                }
                return r;
            });
        }
        return (R)((Record)super.convert(object, cc));
    }
}

