/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Set;
import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Name;
import org.neo4j.jdbc.internal.shaded.jooq.QueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.Row;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.SelectFieldOrAsterisk;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractRowAsField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.RecordDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SelectFieldList;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class RowAsField<ROW extends Row, REC extends Record>
extends AbstractRowAsField<REC>
implements QOM.RowAsField<REC> {
    static final Set<SQLDialect> NO_NATIVE_SUPPORT = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE, SQLDialect.TRINO);
    final ROW row;

    RowAsField(ROW row) {
        this(row, DSL.name("nested"));
    }

    RowAsField(ROW row, Name as) {
        super(as, new RecordDataType((Row)row));
        this.row = row;
    }

    final ROW fields0() {
        return this.row;
    }

    @Override
    final Class<REC> getRecordType() {
        return Tools.recordType(this.row.size());
    }

    @Override
    final void acceptDefault(Context<?> ctx) {
        if (NO_NATIVE_SUPPORT.contains((Object)ctx.dialect())) {
            ctx.data(Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED, true, c -> c.visit(new SelectFieldList((SelectFieldOrAsterisk[])this.emulatedFields((Configuration)ctx.configuration()).fields.fields)));
        } else {
            ctx.data(Tools.BooleanDataKey.DATA_ROW_CONTENT, true, c -> c.visit(Keywords.K_ROW).sql(' ').visit((QueryPart)this.row));
        }
    }

    @Override
    public Field<REC> as(Name alias) {
        return new RowAsField<ROW, REC>(this.row, alias);
    }

    @Override
    public final Field<?> $aliased() {
        return new RowAsField<ROW, REC>(this.row);
    }

    @Override
    public final Name $alias() {
        return this.getQualifiedName();
    }

    @Override
    public final Row $row() {
        return this.row;
    }
}

