/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Set;
import org.neo4j.jdbc.internal.shaded.jooq.Clause;
import org.neo4j.jdbc.internal.shaded.jooq.Comparator;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Row;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.Select;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractCondition;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractRow;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.RowCondition;
import org.neo4j.jdbc.internal.shaded.jooq.impl.RowSubqueryCondition;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class RowIsDistinctFrom
extends AbstractCondition
implements QOM.UNotYetImplemented {
    private static final Set<SQLDialect> EMULATE_DISTINCT = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY);
    private static final Set<SQLDialect> EMULATE_DISTINCT_SELECT = SQLDialect.supportedBy(SQLDialect.HSQLDB, SQLDialect.POSTGRES, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> SUPPORT_DISTINCT_WITH_ARROW = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final Row lhs;
    private final Row rhsRow;
    private final Select<?> rhsSelect;
    private final boolean not;

    RowIsDistinctFrom(Row lhs, Row rhs, boolean not) {
        this.lhs = ((AbstractRow)lhs).convertTo(rhs);
        this.rhsRow = ((AbstractRow)rhs).convertTo(lhs);
        this.rhsSelect = null;
        this.not = not;
    }

    RowIsDistinctFrom(Row lhs, Select<?> rhs, boolean not) {
        this.lhs = lhs;
        this.rhsRow = null;
        this.rhsSelect = rhs;
        this.not = not;
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (EMULATE_DISTINCT.contains((Object)ctx.dialect()) || this.rhsSelect != null && EMULATE_DISTINCT_SELECT.contains((Object)ctx.dialect())) {
            Select intersect = DSL.select(this.lhs.fields()).intersect(this.rhsSelect != null ? this.rhsSelect : DSL.select(this.rhsRow.fields()));
            ctx.visit(this.not ? DSL.exists(intersect) : DSL.notExists(intersect));
        } else if (SUPPORT_DISTINCT_WITH_ARROW.contains((Object)ctx.dialect())) {
            if (!this.not) {
                ctx.visit(Keywords.K_NOT).sql('(');
            }
            ctx.visit(this.lhs).sql(" <=> ");
            if (this.rhsRow != null) {
                ctx.visit(this.rhsRow);
            } else {
                Tools.visitSubquery(ctx, this.rhsSelect, 256);
            }
            if (!this.not) {
                ctx.sql(')');
            }
        } else if (SQLDialect.SQLITE == ctx.family()) {
            ctx.visit(this.lhs).sql(' ').visit(Keywords.K_IS).sql(' ');
            if (!this.not) {
                ctx.visit(Keywords.K_NOT).sql(' ');
            }
            if (this.rhsRow != null) {
                ctx.visit(this.rhsRow);
            } else {
                Tools.visitSubquery(ctx, this.rhsSelect, 256);
            }
        } else {
            ctx.visit(this.rhsRow != null ? new RowCondition(this.lhs, this.rhsRow, this.not ? Comparator.IS_NOT_DISTINCT_FROM : Comparator.IS_DISTINCT_FROM) : new RowSubqueryCondition(this.lhs, this.rhsSelect, this.not ? Comparator.IS_NOT_DISTINCT_FROM : Comparator.IS_DISTINCT_FROM));
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }
}

