/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function2;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;

final class Rtrim
extends AbstractField<String>
implements QOM.Rtrim {
    final Field<String> string;
    final Field<String> characters;

    Rtrim(Field<String> string) {
        super(Names.N_RTRIM, Tools.allNotNull(SQLDataType.VARCHAR, string));
        this.string = Tools.nullSafeNotNull(string, SQLDataType.VARCHAR);
        this.characters = null;
    }

    Rtrim(Field<String> string, Field<String> characters) {
        super(Names.N_RTRIM, Tools.allNotNull(SQLDataType.VARCHAR, string, characters));
        this.string = Tools.nullSafeNotNull(string, SQLDataType.VARCHAR);
        this.characters = Tools.nullSafeNotNull(characters, SQLDataType.VARCHAR);
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.characters == null) {
            switch (ctx.family()) {
                case FIREBIRD: {
                    ctx.visit(Names.N_TRIM).sql('(').visit(Keywords.K_TRAILING).sql(' ').visit(Keywords.K_FROM).sql(' ').visit(this.string).sql(')');
                    break;
                }
                default: {
                    ctx.visit(DSL.function(Names.N_RTRIM, this.getDataType(), this.string));
                    break;
                }
            }
        } else {
            switch (ctx.family()) {
                case SQLITE: {
                    ctx.visit(DSL.function(Names.N_RTRIM, this.getDataType(), this.string, this.characters));
                    break;
                }
                default: {
                    ctx.visit(Names.N_TRIM).sql('(').visit(Keywords.K_TRAILING).sql(' ').visit(this.characters).sql(' ').visit(Keywords.K_FROM).sql(' ').visit(this.string).sql(')');
                }
            }
        }
    }

    @Override
    public final Field<String> $arg1() {
        return this.string;
    }

    @Override
    public final Field<String> $arg2() {
        return this.characters;
    }

    @Override
    public final QOM.Rtrim $arg1(Field<String> newValue) {
        return this.$constructor().apply((Field<String>)newValue, (Field<String>)this.$arg2());
    }

    @Override
    public final QOM.Rtrim $arg2(Field<String> newValue) {
        return this.$constructor().apply((Field<String>)this.$arg1(), (Field<String>)newValue);
    }

    @Override
    public final Function2<? super Field<String>, ? super Field<String>, ? extends QOM.Rtrim> $constructor() {
        return (a1, a2) -> new Rtrim((Field<String>)a1, (Field<String>)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Rtrim) {
            QOM.Rtrim o = (QOM.Rtrim)that;
            return StringUtils.equals(this.$string(), o.$string()) && StringUtils.equals(this.$characters(), o.$characters());
        }
        return super.equals(that);
    }
}

