/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.SelectFieldOrAsterisk;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractRow;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractTable;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AsteriskImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QueryPartList;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class SelectFieldList<F extends SelectFieldOrAsterisk>
extends QueryPartList<F> {
    SelectFieldList() {
    }

    SelectFieldList(Iterable<? extends F> wrappedList) {
        super(wrappedList);
    }

    SelectFieldList(F[] wrappedList) {
        super(wrappedList);
    }

    @Override
    public final boolean rendersContent(Context<?> ctx) {
        return true;
    }

    @Override
    protected final void toSQLEmptyList(Context<?> ctx) {
        ctx.visit(AsteriskImpl.INSTANCE.get());
    }

    @Override
    public final boolean declaresFields() {
        return true;
    }

    @Override
    protected void acceptElement(Context<?> ctx, F part) {
        if (part instanceof AbstractTable) {
            AbstractTable t = (AbstractTable)part;
            this.acceptElement0(ctx, t.tf());
        } else if (part instanceof AbstractRow) {
            AbstractRow r = (AbstractRow)part;
            this.acceptElement0(ctx, r.rf());
        } else {
            this.acceptElement0(ctx, part);
        }
    }

    private void acceptElement0(Context<?> ctx, F part) {
        if (ctx.declareFields() && part instanceof Field) {
            Field f = (Field)part;
            part = SelectFieldList.project(ctx, f);
        }
        Tools.visitAutoAliased(ctx, part, Context::declareFields, (c, t) -> super.acceptElement((Context<?>)c, t));
    }

    static final <T> Field<T> project(Context<?> ctx, Field<T> field) {
        switch (ctx.family()) {
            case HSQLDB: 
            case POSTGRES: 
            case YUGABYTEDB: {
                Field<T> f;
                if (!ctx.subquery() || !Tools.isInlineVal1(ctx, f = Tools.unalias(field), v -> v == null) || f.getDataType().isOther() || f.getDataType().isString()) break;
                Field cast = f.cast(f.getDataType());
                return f == field ? cast : cast.as((Field)field);
            }
        }
        return field;
    }
}

