/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.neo4j.jdbc.internal.shaded.jooq.ConditionProvider;
import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.DeleteQuery;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.ForeignKey;
import org.neo4j.jdbc.internal.shaded.jooq.InsertQuery;
import org.neo4j.jdbc.internal.shaded.jooq.Internal;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.Result;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.SelectQuery;
import org.neo4j.jdbc.internal.shaded.jooq.StoreQuery;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.TableField;
import org.neo4j.jdbc.internal.shaded.jooq.TableLike;
import org.neo4j.jdbc.internal.shaded.jooq.TableRecord;
import org.neo4j.jdbc.internal.shaded.jooq.UniqueKey;
import org.neo4j.jdbc.internal.shaded.jooq.UpdatableRecord;
import org.neo4j.jdbc.internal.shaded.jooq.conf.SettingsTools;
import org.neo4j.jdbc.internal.shaded.jooq.conf.UpdateUnchangedRecords;
import org.neo4j.jdbc.internal.shaded.jooq.exception.DataChangedException;
import org.neo4j.jdbc.internal.shaded.jooq.exception.NoDataFoundException;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractRecord;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractTable;
import org.neo4j.jdbc.internal.shaded.jooq.impl.BatchCRUD;
import org.neo4j.jdbc.internal.shaded.jooq.impl.RecordDelegate;
import org.neo4j.jdbc.internal.shaded.jooq.impl.TableRecordImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.JooqLogger;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;

@Internal
public class UpdatableRecordImpl<R extends UpdatableRecord<R>>
extends TableRecordImpl<R>
implements UpdatableRecord<R> {
    private static final JooqLogger log = JooqLogger.getLogger(UpdatableRecordImpl.class);
    private static final Set<SQLDialect> NO_SUPPORT_FOR_UPDATE = SQLDialect.supportedBy(SQLDialect.SQLITE);
    private static final Set<SQLDialect> NO_SUPPORT_MERGE_RETURNING = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.IGNITE);

    public UpdatableRecordImpl(Table<R> table) {
        super(table);
    }

    @Override
    public Record key() {
        AbstractRecord result = Tools.newRecord(this.fetched, AbstractRecord.class, Tools.row0(this.getPrimaryKey().getFieldsArray())).operate(null);
        result.setValues(result.fields.fields.fields, this);
        return result;
    }

    @Override
    public final <O extends TableRecord<O>> O fetchChild(ForeignKey<O, R> key) {
        return (O)((TableRecord)Tools.filterOne(this.fetchChildren(key)));
    }

    @Override
    public final <O extends TableRecord<O>> Result<O> fetchChildren(ForeignKey<O, R> key) {
        return key.fetchChildren((R)this);
    }

    @Override
    public final <O extends TableRecord<O>> Table<O> children(ForeignKey<O, R> key) {
        return key.children((R)this);
    }

    final UniqueKey<R> getPrimaryKey() {
        Table table = this.getTable();
        if (table instanceof AbstractTable) {
            AbstractTable t = (AbstractTable)table;
            return t.getPrimaryKeyWithEmbeddables();
        }
        return this.getTable().getPrimaryKey();
    }

    @Override
    public final int store() {
        return this.store(this.fields.fields.fields);
    }

    @Override
    public final int store(Field<?> ... storeFields) {
        int[] result = new int[1];
        RecordDelegate.delegate(this.configuration(), this, RecordDelegate.RecordLifecycleType.STORE).operate(record -> {
            result[0] = this.store0(storeFields);
            return record;
        });
        return result[0];
    }

    @Override
    public final int store(Collection<? extends Field<?>> storeFields) {
        return this.store(storeFields.toArray(Tools.EMPTY_FIELD));
    }

    @Override
    public final int update() {
        return this.update(this.fields.fields.fields);
    }

    @Override
    public int update(Field<?> ... storeFields) {
        return this.storeUpdate(storeFields, this.getPrimaryKey().getFieldsArray());
    }

    @Override
    public final int update(Collection<? extends Field<?>> storeFields) {
        return this.update(storeFields.toArray(Tools.EMPTY_FIELD));
    }

    @Override
    public final int merge() {
        return this.merge(this.fields.fields.fields);
    }

    @Override
    public int merge(Field<?> ... storeFields) {
        return this.storeMerge(storeFields, this.getPrimaryKey().getFieldsArray());
    }

    @Override
    public final int merge(Collection<? extends Field<?>> storeFields) {
        return this.merge(storeFields.toArray(Tools.EMPTY_FIELD));
    }

    private final int store0(Field<?>[] storeFields) {
        TableField<R, ?>[] keys = this.getPrimaryKey().getFieldsArray();
        boolean executeUpdate = false;
        if (SettingsTools.updatablePrimaryKeys(Tools.settings(this))) {
            executeUpdate = this.fetched;
        } else {
            for (TableField field : keys) {
                if (this.changed(field) || !field.getDataType().nullable() && this.get(field) == null) {
                    executeUpdate = false;
                    break;
                }
                executeUpdate = true;
            }
        }
        int result = 0;
        result = executeUpdate ? this.storeUpdate(storeFields, keys) : this.storeInsert(storeFields);
        return result;
    }

    private final int storeUpdate(Field<?>[] storeFields, TableField<R, ?>[] keys) {
        int[] result = new int[1];
        RecordDelegate.delegate(this.configuration(), this, RecordDelegate.RecordLifecycleType.UPDATE).operate(record -> {
            result[0] = this.storeUpdate0(storeFields, keys);
            return record;
        });
        return result[0];
    }

    private final int storeUpdate0(Field<?>[] storeFields, TableField<R, ?>[] keys) {
        return this.storeMergeOrUpdate0(storeFields, keys, (StoreQuery<R> & ConditionProvider)this.create().updateQuery(this.getTable()), false);
    }

    private final int storeMerge(Field<?>[] storeFields, TableField<R, ?>[] keys) {
        int[] result = new int[1];
        RecordDelegate.delegate(this.configuration(), this, RecordDelegate.RecordLifecycleType.MERGE).operate(record -> {
            result[0] = this.storeMerge0(storeFields, keys);
            return record;
        });
        return Math.min(result[0], 1);
    }

    private final int storeMerge0(Field<?>[] storeFields, TableField<R, ?>[] keys) {
        if (this.lockingActive()) {
            if (this.lockValuePresent()) {
                return this.storeUpdate0(storeFields, keys);
            }
            return this.storeInsert0(storeFields);
        }
        InsertQuery merge = this.create().insertQuery(this.getTable());
        merge.onDuplicateKeyUpdate(true);
        return this.storeMergeOrUpdate0(storeFields, keys, (StoreQuery<R> & ConditionProvider)merge, true);
    }

    private final boolean lockingActive() {
        return this.isExecuteWithOptimisticLocking() && (this.isTimestampOrVersionAvailable() || this.isExecuteWithOptimisticLockingIncludeUnversioned());
    }

    private final boolean lockValuePresent() {
        return this.getRecordVersion() != null || this.getRecordTimestamp() != null || this.getTable().getRecordVersion() == null && this.getTable().getRecordTimestamp() == null && this.fetched;
    }

    private final <Q extends StoreQuery<R> & ConditionProvider> int storeMergeOrUpdate0(Field<?>[] storeFields, TableField<R, ?>[] keys, Q query, boolean merge) {
        List<Field<?>> changedFields = this.addChangedValues(storeFields, query, merge);
        if (!merge) {
            Tools.addConditions(query, this, keys);
        }
        if (changedFields.isEmpty()) {
            switch (StringUtils.defaultIfNull(this.create().settings().getUpdateUnchangedRecords(), UpdateUnchangedRecords.NEVER)) {
                case NEVER: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Query is not executable", query);
                    }
                    return 0;
                }
                case SET_PRIMARY_KEY_TO_ITSELF: {
                    for (Field<Object> field : keys) {
                        query.addValue(field, field);
                    }
                    break;
                }
                case SET_NON_PRIMARY_KEY_TO_THEMSELVES: {
                    for (Field<Object> field : storeFields) {
                        if (Arrays.asList(keys).contains(field)) continue;
                        query.addValue(field, field);
                    }
                    break;
                }
                case SET_NON_PRIMARY_KEY_TO_RECORD_VALUES: {
                    for (Field<Object> field : storeFields) {
                        if (Arrays.asList(keys).contains(field)) continue;
                        this.changed(field, true);
                    }
                    this.addChangedValues(storeFields, query, merge);
                }
            }
        }
        BigInteger version = this.addRecordVersion(query, merge);
        Timestamp timestamp = this.addRecordTimestamp(query, merge);
        if (this.isExecuteWithOptimisticLocking()) {
            if (this.isTimestampOrVersionAvailable()) {
                this.addConditionForVersionAndTimestamp(query);
            } else if (this.isExecuteWithOptimisticLockingIncludeUnversioned()) {
                this.checkIfChanged(keys);
            }
        }
        Collection<Field<?>> key = merge && NO_SUPPORT_MERGE_RETURNING.contains((Object)this.create().dialect()) ? null : this.setReturningIfNeeded(query);
        try {
            int n = query.execute();
            this.checkIfChanged(n, version, timestamp);
            if (n > 0) {
                for (Field<?> changedField : changedFields) {
                    this.changed(changedField, false);
                }
                this.getReturningIfNeeded(query, key);
            }
            return n;
        }
        catch (BatchCRUD.QueryCollectorSignal queryCollectorSignal) {
            queryCollectorSignal.version = version;
            queryCollectorSignal.timestamp = timestamp;
            throw queryCollectorSignal;
        }
    }

    @Override
    public final int delete() {
        int[] result = new int[1];
        RecordDelegate.delegate(this.configuration(), this, RecordDelegate.RecordLifecycleType.DELETE).operate(record -> {
            result[0] = this.delete0();
            return record;
        });
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int delete0() {
        TableField<R, ?>[] keys = this.getPrimaryKey().getFieldsArray();
        try {
            DeleteQuery delete1 = this.create().deleteQuery(this.getTable());
            Tools.addConditions(delete1, this, keys);
            if (this.isExecuteWithOptimisticLocking()) {
                if (this.isTimestampOrVersionAvailable()) {
                    this.addConditionForVersionAndTimestamp(delete1);
                } else if (this.isExecuteWithOptimisticLockingIncludeUnversioned()) {
                    this.checkIfChanged(keys);
                }
            }
            int result = delete1.execute();
            this.checkIfChanged(result, null, null);
            int n = result;
            return n;
        }
        finally {
            this.changed(true);
            this.fetched = false;
        }
    }

    @Override
    public final void refresh() {
        this.refresh(this.fields.fields.fields);
    }

    @Override
    public final void refresh(Field<?> ... refreshFields) {
        SelectQuery<Record> select = this.create().selectQuery();
        select.addSelect(refreshFields);
        select.addFrom((TableLike<?>)this.getTable());
        Tools.addConditions(select, this, this.getPrimaryKey().getFieldsArray());
        if (select.execute() != 1) {
            throw new NoDataFoundException("Exactly one row expected for refresh. Record does not exist in database.");
        }
        AbstractRecord source = (AbstractRecord)select.getResult().get(0);
        RecordDelegate.delegate(this.configuration(), this, RecordDelegate.RecordLifecycleType.REFRESH).operate(record -> {
            this.setValues(refreshFields, source);
            return record;
        });
    }

    @Override
    public final void refresh(Collection<? extends Field<?>> refreshFields) {
        this.refresh(refreshFields.toArray(Tools.EMPTY_FIELD));
    }

    @Override
    public final R copy() {
        return (R)((UpdatableRecord)Tools.newRecord(false, this.getTable(), this.configuration()).operate(copy -> {
            List key = this.getPrimaryKey().getFields();
            for (Field<?> field : this.fields.fields.fields) {
                if (key.contains(field)) continue;
                copy.set(field, this.get(field));
            }
            return copy;
        }));
    }

    private final boolean isExecuteWithOptimisticLocking() {
        Configuration configuration = this.configuration();
        return configuration != null && Boolean.TRUE.equals(configuration.settings().isExecuteWithOptimisticLocking());
    }

    private final boolean isExecuteWithOptimisticLockingIncludeUnversioned() {
        Configuration configuration = this.configuration();
        return configuration == null || !Boolean.TRUE.equals(configuration.settings().isExecuteWithOptimisticLockingExcludeUnversioned());
    }

    private final void addConditionForVersionAndTimestamp(ConditionProvider query) {
        TableField v = this.getTable().getRecordVersion();
        TableField t = this.getTable().getRecordTimestamp();
        if (v != null) {
            Tools.addCondition(query, this, v);
        }
        if (t != null) {
            Tools.addCondition(query, this, t);
        }
    }

    private final void checkIfChanged(TableField<R, ?>[] keys) {
        UpdatableRecord record;
        SelectQuery select = this.create().selectQuery(this.getTable());
        Tools.addConditions(select, this, keys);
        if (!NO_SUPPORT_FOR_UPDATE.contains((Object)this.create().dialect())) {
            select.setForUpdate(true);
        }
        if ((record = (UpdatableRecord)select.fetchOne()) == null) {
            throw new DataChangedException("Database record no longer exists");
        }
        for (Field<?> field : this.fields.fields.fields) {
            Object thatObject;
            Object thisObject = this.original(field);
            if (StringUtils.equals(thisObject, thatObject = record.original(field))) continue;
            if (thisObject == null && !this.fetched) {
                throw new DataChangedException("Cannot detect whether unversioned record has been changed. Either make sure the record is fetched from the database, or use a version or timestamp column to version the record.");
            }
            throw new DataChangedException("Database record has been changed");
        }
    }

    private final void checkIfChanged(int result, BigInteger version, Timestamp timestamp) {
        if (result > 0) {
            this.setRecordVersionAndTimestamp(version, timestamp);
        } else if (this.isExecuteWithOptimisticLocking()) {
            throw new DataChangedException("Database record has been changed or doesn't exist any longer");
        }
    }
}

