/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.DataType;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function3;
import org.neo4j.jdbc.internal.shaded.jooq.XML;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;

final class XMLSerialize<T>
extends AbstractField<T>
implements QOM.XMLSerialize<T> {
    final boolean content;
    final Field<XML> value;
    final DataType<T> type;

    XMLSerialize(boolean content, Field<XML> value, DataType<T> type) {
        super(Names.N_XMLSERIALIZE, type);
        this.content = content;
        this.value = Tools.nullSafeNotNull(value, SQLDataType.XML);
        this.type = type;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(Names.N_XMLSERIALIZE).sql('(');
        if (this.content) {
            ctx.visit(Keywords.K_CONTENT).sql(' ');
        } else {
            ctx.visit(Keywords.K_DOCUMENT).sql(' ');
        }
        ctx.visit(this.value).sql(' ').visit(Keywords.K_AS).sql(' ').sql(this.type.getCastTypeName(ctx.configuration())).sql(')');
    }

    @Override
    public final Boolean $arg1() {
        return this.content;
    }

    @Override
    public final Field<XML> $arg2() {
        return this.value;
    }

    @Override
    public final DataType<T> $arg3() {
        return this.type;
    }

    @Override
    public final QOM.XMLSerialize<T> $arg1(Boolean newValue) {
        return this.$constructor().apply(newValue, (Field<XML>)this.$arg2(), (DataType<T>)this.$arg3());
    }

    @Override
    public final QOM.XMLSerialize<T> $arg2(Field<XML> newValue) {
        return this.$constructor().apply(this.$arg1(), newValue, (DataType<T>)this.$arg3());
    }

    @Override
    public final QOM.XMLSerialize<T> $arg3(DataType<T> newValue) {
        return this.$constructor().apply(this.$arg1(), (Field<XML>)this.$arg2(), newValue);
    }

    @Override
    public final Function3<? super Boolean, ? super Field<XML>, ? super DataType<T>, ? extends QOM.XMLSerialize<T>> $constructor() {
        return (a1, a2, a3) -> new XMLSerialize((boolean)a1, (Field<XML>)a2, a3);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.XMLSerialize) {
            QOM.XMLSerialize o = (QOM.XMLSerialize)that;
            return this.$content() == o.$content() && StringUtils.equals(this.$value(), o.$value()) && StringUtils.equals(this.$type(), o.$type());
        }
        return super.equals(that);
    }
}

