/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.translator.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Case;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Cypher;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExposesRelationships;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExposesReturning;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Finish;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ListExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Literal;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Node;
import org.neo4j.jdbc.internal.shaded.cypherdsl.NodeLabel;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PatternElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Property;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PropertyContainer;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Relationship;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RelationshipChain;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RelationshipPattern;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ResultStatement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SortItem;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Statement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.StatementBuilder;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.Configuration;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.Dialect;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.GeneralizedRenderer;
import org.neo4j.jdbc.internal.shaded.cypherdsl.renderer.Renderer;
import org.neo4j.jdbc.internal.shaded.jooq.Asterisk;
import org.neo4j.jdbc.internal.shaded.jooq.Condition;
import org.neo4j.jdbc.internal.shaded.jooq.CreateTableElementListStep;
import org.neo4j.jdbc.internal.shaded.jooq.DSLContext;
import org.neo4j.jdbc.internal.shaded.jooq.False;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Null;
import org.neo4j.jdbc.internal.shaded.jooq.Param;
import org.neo4j.jdbc.internal.shaded.jooq.Parser;
import org.neo4j.jdbc.internal.shaded.jooq.QualifiedAsterisk;
import org.neo4j.jdbc.internal.shaded.jooq.Query;
import org.neo4j.jdbc.internal.shaded.jooq.QueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.Row;
import org.neo4j.jdbc.internal.shaded.jooq.Select;
import org.neo4j.jdbc.internal.shaded.jooq.SelectField;
import org.neo4j.jdbc.internal.shaded.jooq.SelectFieldOrAsterisk;
import org.neo4j.jdbc.internal.shaded.jooq.SortField;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.TableField;
import org.neo4j.jdbc.internal.shaded.jooq.True;
import org.neo4j.jdbc.internal.shaded.jooq.conf.ParamType;
import org.neo4j.jdbc.internal.shaded.jooq.conf.Settings;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.ParserException;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.translator.impl.ParameterNameGenerator;
import org.neo4j.jdbc.translator.impl.SqlToCypherConfig;
import org.neo4j.jdbc.translator.spi.Cache;
import org.neo4j.jdbc.translator.spi.Translator;

final class SqlToCypher
implements Translator {
    static final Pattern ELEMENT_ID_PATTERN = Pattern.compile("(?i)v\\$(?:(?<prefix>.+?)_)?id");
    static final String ELEMENT_ID_FUNCTION_NAME = "elementId";
    static final String ELEMENT_ID_ALIAS = "v$id";
    static final Pattern PERCENT_OR_UNDERSCORE = Pattern.compile("[%_]");
    private static final Map<String, String> FUNCTION_MAPPING;
    private static final int STATEMENT_CACHE_SIZE = 64;
    private final SqlToCypherConfig config;
    private final Configuration rendererConfig;
    private final Cache<Query, String> cache = Cache.getInstance(64);

    static Translator defaultTranslator() {
        return new SqlToCypher(SqlToCypherConfig.defaultConfig());
    }

    static Translator with(SqlToCypherConfig config) {
        return new SqlToCypher(config);
    }

    private SqlToCypher(SqlToCypherConfig config) {
        this.config = config;
        this.rendererConfig = Configuration.newConfig().withPrettyPrint(this.config.isPrettyPrint()).alwaysEscapeNames(this.config.isAlwaysEscapeNames()).withDialect(Dialect.NEO4J_5).build();
    }

    @Override
    public void flushCache() {
        this.cache.flush();
    }

    @Override
    public int getOrder() {
        return Optional.ofNullable(this.config.getPrecedence()).orElseGet(() -> Translator.super.getOrder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String translate(String sql, DatabaseMetaData optionalDatabaseMetaData) {
        Query query;
        try {
            DSLContext dsl = this.createDSLContext();
            Parser parser = dsl.parser();
            query = parser.parseQuery(sql);
            if (query == null && sql != null && sql.trim().startsWith("//")) {
                return Renderer.getRenderer(this.rendererConfig, GeneralizedRenderer.class).render(Finish.create());
            }
        }
        catch (ParserException pe) {
            throw new IllegalArgumentException(pe);
        }
        if (this.config.isCacheEnabled()) {
            SqlToCypher sqlToCypher = this;
            synchronized (sqlToCypher) {
                return this.cache.computeIfAbsent(query, key -> this.translate0(query, optionalDatabaseMetaData));
            }
        }
        return this.translate0(query, optionalDatabaseMetaData);
    }

    private String translate0(Query query, DatabaseMetaData databaseMetaData) {
        return this.render(ContextAwareStatementBuilder.build(this.config, databaseMetaData, query));
    }

    private DSLContext createDSLContext() {
        Settings settings = this.config.asSettings();
        Optional.ofNullable(this.config.getParseNamedParamPrefix()).filter(Predicate.not(String::isBlank)).map(String::trim).ifPresent(settings::withParseNamedParamPrefix);
        DSLContext context = DSL.using(this.config.getSqlDialect(), settings);
        context.configuration().set(() -> {
            HashMap tables = new HashMap();
            this.config.getJoinColumnsToTypeMappings().forEach((k, v) -> {
                String[] tableAndColumnName = k.split("\\.");
                CreateTableElementListStep createTableStep = (CreateTableElementListStep)tables.computeIfAbsent(tableAndColumnName[0], DSL::createTable);
                createTableStep.column(DSL.field(tableAndColumnName[1]).comment("type=" + v));
            });
            this.config.getTableToLabelMappings().forEach((k, v) -> {
                CreateTableElementListStep createTableStep = (CreateTableElementListStep)tables.computeIfAbsent(k, DSL::createTable);
                createTableStep.comment("label=" + v);
            });
            return context.meta((Query[])tables.values().toArray(Query[]::new));
        });
        return context;
    }

    private String render(Statement statement) {
        return Renderer.getRenderer(this.rendererConfig).render(statement);
    }

    static {
        Logger.getLogger("org.neo4j.jdbc.internal.shaded.jooq.Constants").setLevel(Level.WARNING);
        Logger.getLogger("org.neo4j.jdbc.internal.shaded.jooq.Constants").setLevel(Level.WARNING);
        System.setProperty("org.neo4j.jdbc.internal.shaded.jooq.no-logo", "true");
        System.setProperty("org.neo4j.jdbc.internal.shaded.jooq.no-tips", "true");
        FUNCTION_MAPPING = Map.of("strpos", "apoc.text.indexOf");
    }

    static class ContextAwareStatementBuilder {
        private final Map<String, Expression> columnsAndValues = new LinkedHashMap<String, Expression>();
        private final Map<String, AtomicInteger> returnColumns = new HashMap<String, AtomicInteger>();
        private final SqlToCypherConfig config;
        private final DatabaseMetaData databaseMetaData;
        private final ParameterNameGenerator parameterNameGenerator = new ParameterNameGenerator();
        private final List<Table<?>> tables = new ArrayList();
        private final Map<SymbolicName, PatternElement> resolvedRelationships = new HashMap<SymbolicName, PatternElement>();
        private final AtomicBoolean useAliasForVColumn = new AtomicBoolean(true);

        static Statement build(SqlToCypherConfig config, DatabaseMetaData databaseMetaData, Query query) {
            if (query instanceof Select) {
                Select s = (Select)query;
                return new ContextAwareStatementBuilder(config, databaseMetaData).statement(s);
            }
            if (query instanceof QOM.Delete) {
                QOM.Delete d = (QOM.Delete)query;
                return new ContextAwareStatementBuilder(config, databaseMetaData).statement(d);
            }
            if (query instanceof QOM.Truncate) {
                QOM.Truncate t = (QOM.Truncate)query;
                return new ContextAwareStatementBuilder(config, databaseMetaData).statement(t);
            }
            if (query instanceof QOM.Insert) {
                QOM.Insert t = (QOM.Insert)query;
                return new ContextAwareStatementBuilder(config, databaseMetaData).statement(t);
            }
            if (query instanceof QOM.InsertReturning) {
                QOM.InsertReturning t = (QOM.InsertReturning)query;
                return new ContextAwareStatementBuilder(config, databaseMetaData).statement(t.$insert(), t.$returning());
            }
            if (query instanceof QOM.Update) {
                QOM.Update u = (QOM.Update)query;
                return new ContextAwareStatementBuilder(config, databaseMetaData).statement(u);
            }
            throw ContextAwareStatementBuilder.unsupported(query);
        }

        ContextAwareStatementBuilder(SqlToCypherConfig config, DatabaseMetaData databaseMetaData) {
            this.config = config;
            this.databaseMetaData = databaseMetaData;
        }

        private static IllegalArgumentException unsupported(QueryPart p) {
            String typeMsg = p != null ? " (Was of type " + p.getClass().getName() + ")" : "";
            return new IllegalArgumentException("Unsupported SQL expression: " + String.valueOf(p) + typeMsg);
        }

        private static Node nodeWithProperties(Node src, Map<String, Expression> properties) {
            return (Node)src.withProperties(properties.entrySet().stream().flatMap(e -> Stream.of(e.getKey(), e.getValue())).toArray());
        }

        private static SymbolicName symbolicName(String value) {
            return Cypher.name(value.toLowerCase(Locale.ROOT));
        }

        private static String relationshipTypeName(Field<?> lhsJoinColumn) {
            return Objects.requireNonNull(lhsJoinColumn.getQualifiedName().last()).toUpperCase(Locale.ROOT);
        }

        private Statement statement(QOM.Delete<?> d) {
            this.tables.clear();
            this.tables.add(d.$from());
            Node e = (Node)this.resolveTableOrJoinf(this.tables.get(0)).get(0);
            StatementBuilder.OngoingReadingWithoutWhere m1 = Cypher.match(e);
            StatementBuilder.OngoingReadingWithWhere m2 = d.$where() != null ? (StatementBuilder.OngoingReadingWithWhere)m1.where(this.condition(d.$where())) : (StatementBuilder.OngoingReadingWithWhere)((Object)m1);
            return m2.delete(e.asExpression()).build();
        }

        private Statement statement(QOM.Truncate<?> t) {
            this.tables.clear();
            this.tables.addAll(t.$table());
            Node e = (Node)this.resolveTableOrJoinf(this.tables.get(0)).get(0);
            return Cypher.match(e).detachDelete(e.asExpression()).build();
        }

        private ResultStatement statement(Select<?> incoming) {
            StatementBuilder.BuildableStatement<ResultStatement> buildableStatement;
            Select x;
            QOM.TableAlias tableAlias;
            boolean addLimit = false;
            Table<Object> table = incoming.$from().$first();
            if (table instanceof QOM.TableAlias && (table = (tableAlias = (QOM.TableAlias)table).$table()) instanceof QOM.DerivedTable) {
                QOM.DerivedTable d = (QOM.DerivedTable)table;
                addLimit = incoming.$where() != null;
                x = (Select)d.$arg1();
            } else {
                x = incoming;
            }
            this.tables.clear();
            this.tables.addAll(ContextAwareStatementBuilder.unnestFromClause(x.$from()));
            Supplier<List> resultColumnsSupplier = () -> x.$select().stream().flatMap(this::expression).toList();
            if (x.$from().isEmpty()) {
                return (ResultStatement)Cypher.returning(resultColumnsSupplier.get()).build();
            }
            StatementBuilder.OngoingReadingWithoutWhere m1 = Cypher.match(x.$from().stream().flatMap(t -> this.resolveTableOrJoinf((Table<?>)t).stream()).toList());
            StatementBuilder.OngoingReadingWithWhere m2 = x.$where() != null ? (StatementBuilder.OngoingReadingWithWhere)m1.where(this.condition(x.$where())) : (StatementBuilder.OngoingReadingWithWhere)((Object)m1);
            StatementBuilder.OngoingReadingAndReturn intermediate = x.$distinct() ? m2.returningDistinct(resultColumnsSupplier.get()) : m2.returning(resultColumnsSupplier.get());
            StatementBuilder.OngoingMatchAndReturnWithOrder returning = intermediate.orderBy(x.$orderBy().stream().map(this::expression).toList());
            Field<Number> field = x.$limit();
            if (!(field instanceof Param)) {
                buildableStatement = addLimit ? returning.limit(1) : returning;
            } else {
                Param param = (Param)field;
                buildableStatement = returning.limit(this.expression(param));
            }
            return (ResultStatement)buildableStatement.build();
        }

        private Statement statement(QOM.Insert<?> insert) {
            return this.statement(insert, List.of());
        }

        private Statement statement(QOM.Insert<?> insert, List<? extends SelectFieldOrAsterisk> returning) {
            boolean useMerge;
            this.tables.clear();
            this.tables.add(insert.$into());
            Node node = (Node)this.resolveTableOrJoinf(this.tables.get(0)).get(0);
            QOM.UnmodifiableList<Row> rows = insert.$values();
            boolean hasMergeProperties = !insert.$onConflict().isEmpty();
            boolean bl = useMerge = insert.$onDuplicateKeyIgnore() || hasMergeProperties;
            if (rows.size() == 1) {
                return this.buildSingleCreateStatement(insert, returning, node, useMerge, hasMergeProperties);
            }
            return this.buildUnwindCreateStatement(insert, returning, node, useMerge, hasMergeProperties);
        }

        private Statement buildSingleCreateStatement(QOM.Insert<?> insert, List<? extends SelectFieldOrAsterisk> returning, Node node, boolean useMerge, boolean hasMergeProperties) {
            Row row = Objects.requireNonNull(insert.$values().$first());
            QOM.UnmodifiableList<Field<?>> columns = insert.$columns();
            LinkedHashMap<String, Expression> nodeProperties = new LinkedHashMap<String, Expression>();
            for (int i = 0; i < columns.size(); ++i) {
                nodeProperties.put(((Field)columns.get(i)).getName(), this.expression(row.field(i)));
            }
            if (useMerge) {
                LinkedHashMap<String, Expression> mergeProperties = hasMergeProperties ? new LinkedHashMap<String, Expression>() : nodeProperties;
                insert.$onConflict().forEach(c -> {
                    mergeProperties.put(c.getName(), (Expression)nodeProperties.get(c.getName()));
                    nodeProperties.remove(c.getName());
                });
                ArrayList properties = new ArrayList();
                nodeProperties.forEach((k, v) -> properties.add(Cypher.set(node.property((String)k), v)));
                StatementBuilder.ExposesForeach merge = Cypher.merge(ContextAwareStatementBuilder.nodeWithProperties(node, mergeProperties));
                if (hasMergeProperties) {
                    merge = ((StatementBuilder.ExposesMergeAction)((Object)merge)).onCreate().set(properties);
                }
                if (!insert.$updateSet().isEmpty()) {
                    ArrayList updates = new ArrayList();
                    insert.$updateSet().forEach((c, v) -> {
                        ContextAwareStatementBuilder contextAwareStatementBuilder = this;
                        synchronized (contextAwareStatementBuilder) {
                            try {
                                this.columnsAndValues.putAll(nodeProperties);
                                updates.add(Cypher.set(node.property(((Field)c).getName()), this.expression((Field)v)));
                            }
                            finally {
                                nodeProperties.keySet().forEach(this.columnsAndValues::remove);
                            }
                        }
                    });
                    merge = ((StatementBuilder.ExposesMergeAction)((Object)merge)).onMatch().set(updates);
                }
                return this.addOptionalReturnAndBuild((ExposesReturning)((Object)merge), returning);
            }
            return this.addOptionalReturnAndBuild(Cypher.create(ContextAwareStatementBuilder.nodeWithProperties(node, nodeProperties)), returning);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Statement buildUnwindCreateStatement(QOM.Insert<?> insert, List<? extends SelectFieldOrAsterisk> returning, Node node, boolean useMerge, boolean hasMergeProperties) {
            if (useMerge && !hasMergeProperties) {
                throw new UnsupportedOperationException("MERGE is not supported when inserting multiple rows without using a property to merge on");
            }
            QOM.UnmodifiableList<Field<?>> columns = insert.$columns();
            ListExpression props = Cypher.listOf(insert.$values().stream().map(row -> {
                HashMap<String, Expression> result = new HashMap<String, Expression>(columns.size());
                for (int i = 0; i < columns.size(); ++i) {
                    result.put(((Field)columns.get(i)).getName(), this.expression(row.field(i)));
                }
                return Cypher.literalOf(result);
            }).toList());
            if (useMerge) {
                SymbolicName symName = Cypher.name("properties");
                LinkedHashMap<String, Expression> mergeProperties = new LinkedHashMap<String, Expression>();
                insert.$onConflict().forEach(c -> mergeProperties.put(c.getName(), Cypher.property((Expression)symName, Cypher.literalOf(c.getName()))));
                ArrayList properties = new ArrayList();
                columns.stream().filter(c -> !mergeProperties.containsKey(c.getName())).forEach(c -> properties.add(Cypher.set(node.property(c.getName()), Cypher.property((Expression)symName, c.getName()))));
                ArrayList updates = new ArrayList();
                ContextAwareStatementBuilder contextAwareStatementBuilder = this;
                synchronized (contextAwareStatementBuilder) {
                    try {
                        columns.forEach(c -> this.columnsAndValues.put(c.getName(), Cypher.property((Expression)symName, Cypher.literalOf(c.getName()))));
                        insert.$updateSet().forEach((c, v) -> updates.add(Cypher.set(node.property(((Field)c).getName()), this.expression((Field)v))));
                    }
                    finally {
                        columns.forEach(c -> this.columnsAndValues.remove(c.getName()));
                    }
                }
                return this.addOptionalReturnAndBuild(Cypher.unwind((Expression)props).as("properties").merge(ContextAwareStatementBuilder.nodeWithProperties(node, mergeProperties)).onCreate().set(properties).onMatch().set(updates), returning);
            }
            return this.addOptionalReturnAndBuild(Cypher.unwind((Expression)props).as("properties").create(node).set(node, (Expression)Cypher.name("properties")), returning);
        }

        private <T extends ExposesReturning & StatementBuilder.BuildableStatement<?>> Statement addOptionalReturnAndBuild(T exposesReturning, List<? extends SelectFieldOrAsterisk> returning) {
            if (returning == null || returning.isEmpty()) {
                return ((StatementBuilder.BuildableStatement<?>)exposesReturning).build();
            }
            return exposesReturning.returning(returning.stream().flatMap(this::expression).toList()).build();
        }

        private String uniqueColumnName(String s) {
            int cnt = this.returnColumns.computeIfAbsent(s, k -> new AtomicInteger(0)).getAndAccumulate(1, Integer::sum);
            return s + String.valueOf(cnt > 0 ? Integer.valueOf(cnt) : "");
        }

        private Statement statement(QOM.Update<?> update) {
            this.tables.clear();
            this.tables.add(update.$table());
            Node node = (Node)this.resolveTableOrJoinf(this.tables.get(0)).get(0);
            ArrayList updates = new ArrayList();
            update.$set().forEach((c, v) -> {
                updates.add(node.property(((Field)c).getName()));
                updates.add(this.expression((Field)v));
            });
            StatementBuilder.ExposesSet exposesSet = update.$where() != null ? (StatementBuilder.ExposesSet)Cypher.match(node).where(this.condition(update.$where())) : Cypher.match(node);
            return exposesSet.set(updates).build();
        }

        private Stream<Expression> expression(SelectFieldOrAsterisk t) {
            QualifiedAsterisk q;
            Object properties2;
            if (t instanceof SelectField) {
                TableField tf;
                SelectField theField;
                SelectField s = (SelectField)t;
                if (s instanceof QOM.FieldAlias) {
                    QOM.FieldAlias fa = (QOM.FieldAlias)s;
                    v0 = fa.$aliased();
                } else {
                    v0 = theField = s;
                }
                Expression col = theField instanceof TableField && (tf = (TableField)theField).getTable() == null ? this.findTableFieldInTables(tf, true, !(s instanceof QOM.FieldAlias)) : this.expression(s);
                if (s instanceof QOM.FieldAlias) {
                    QOM.FieldAlias fa = (QOM.FieldAlias)s;
                    col = col.as(fa.$alias().last());
                }
                return Stream.of(col);
            }
            if (t instanceof Asterisk) {
                List<Expression> properties2 = this.projectAllColumns();
                if (properties2.isEmpty()) {
                    properties2.add(Cypher.asterisk());
                }
                return properties2.stream();
            }
            if (t instanceof QualifiedAsterisk && (properties2 = this.resolveTableOrJoinf((q = (QualifiedAsterisk)t).$table()).get(0)) instanceof Node) {
                Node node = (Node)properties2;
                properties2 = new ArrayList();
                for (Table<?> table : this.tables) {
                    QOM.TableAlias tableAlias;
                    if (!(table instanceof QOM.TableAlias) || !(tableAlias = (QOM.TableAlias)table).getName().equals(q.$table().getName())) continue;
                    ((ArrayList)properties2).addAll(this.projectAllColumns(List.of(tableAlias)));
                    break;
                }
                if (((ArrayList)properties2).isEmpty()) {
                    SymbolicName symbolicName = node.getSymbolicName().orElseGet(() -> Cypher.name(q.$table().getName()));
                    ((ArrayList)properties2).add(symbolicName.project(Cypher.asterisk()).as(symbolicName));
                }
                return properties2.stream();
            }
            throw ContextAwareStatementBuilder.unsupported(t);
        }

        private List<Expression> projectAllColumns() {
            return this.projectAllColumns(this.tables);
        }

        private List<Expression> projectAllColumns(List<Table<?>> from) {
            ArrayList<Expression> properties = new ArrayList<Expression>();
            if (this.databaseMetaData == null) {
                return properties;
            }
            for (Table<?> table : from) {
                PropertyContainer pc = (PropertyContainer)((Object)this.resolveTableOrJoinf(table).get(0));
                String tableName = this.labelOrType(table);
                if (!(pc instanceof Relationship)) {
                    properties.addAll(this.findProperties(tableName, pc));
                    continue;
                }
                Relationship rel = (Relationship)pc;
                properties.add(this.makeFk(rel.getLeft()));
                properties.addAll(this.findProperties(tableName, pc));
                properties.add(this.makeFk(rel.getRight()));
            }
            return properties;
        }

        private Expression makeFk(Node node) {
            String nodeName = node.getLabels().get(0).getValue();
            return ((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call(SqlToCypher.ELEMENT_ID_FUNCTION_NAME).withArgs(node.asExpression())).asFunction().as(this.uniqueColumnName("v$" + nodeName.toLowerCase(Locale.ROOT) + "_id"));
        }

        private List<Expression> findProperties(String tableName, PropertyContainer pc) {
            ArrayList<Expression> properties = new ArrayList<Expression>();
            try (ResultSet columns = this.databaseMetaData.getColumns(null, null, tableName, null);){
                properties.add(this.makeId(pc, null));
                while (columns.next()) {
                    String columnName = columns.getString("COLUMN_NAME");
                    if ("YES".equalsIgnoreCase(columns.getString("IS_GENERATEDCOLUMN"))) continue;
                    properties.add(pc.property(columnName).as(this.uniqueColumnName(columnName)));
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            return properties;
        }

        private Expression makeId(PropertyContainer pc, String alias) {
            Expression function = ((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call(SqlToCypher.ELEMENT_ID_FUNCTION_NAME).withArgs(pc.asExpression())).asFunction();
            return this.useAliasForVColumn.get() ? function.as(this.uniqueColumnName(alias != null ? alias : SqlToCypher.ELEMENT_ID_ALIAS)) : function;
        }

        private static List<? extends Table<?>> unnestFromClause(List<? extends Table<?>> tables) {
            ArrayList result = new ArrayList();
            for (Table<?> table : tables) {
                if (table instanceof QOM.JoinTable) {
                    QOM.JoinTable join = (QOM.JoinTable)table;
                    result.addAll(ContextAwareStatementBuilder.unnestFromClause(List.of(join.$table1())));
                    result.addAll(ContextAwareStatementBuilder.unnestFromClause(List.of(join.$table2())));
                    continue;
                }
                result.add(table);
            }
            return result;
        }

        private Expression expression(SelectField<?> s) {
            if (s instanceof QOM.FieldAlias) {
                QOM.FieldAlias fa = (QOM.FieldAlias)s;
                return this.expression((Field<?>)fa.$aliased()).as(fa.$alias().last());
            }
            if (s instanceof Field) {
                Field f = (Field)s;
                return this.expression(f);
            }
            throw ContextAwareStatementBuilder.unsupported(s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SortItem expression(SortField<?> s) {
            try {
                Expression col;
                String direction;
                block6: {
                    this.useAliasForVColumn.set(false);
                    direction = s.$sortOrder().name().toUpperCase(Locale.ROOT);
                    Field<?> theField = s.$field();
                    col = null;
                    try {
                        col = this.expression(theField);
                    }
                    catch (IllegalArgumentException ex) {
                        TableField tf;
                        if (theField instanceof TableField && (tf = (TableField)theField).getTable() == null) {
                            col = this.findTableFieldInTables(tf, false, false);
                        }
                        if (!(s instanceof QOM.FieldAlias)) break block6;
                        QOM.FieldAlias fa = (QOM.FieldAlias)((Object)s);
                        if (col == null) break block6;
                        col = col.as(fa.$alias().last());
                    }
                }
                SortItem sortItem = Cypher.sort(col, "DEFAULT".equals(direction) ? SortItem.Direction.UNDEFINED : SortItem.Direction.valueOf(direction));
                return sortItem;
            }
            finally {
                this.useAliasForVColumn.set(true);
            }
        }

        private Expression findTableFieldInTables(TableField<?, ?> tf, boolean fallbackToFieldName, boolean doAlias) {
            Expression col = null;
            if (this.tables.size() == 1) {
                PropertyContainer propertyContainer = (PropertyContainer)((Object)this.resolveTableOrJoinf(this.tables.get(0)).get(0));
                if (ContextAwareStatementBuilder.isElementId(tf)) {
                    return this.makeId(propertyContainer, tf.getName());
                }
                if (ContextAwareStatementBuilder.isFkId(tf) != null && propertyContainer instanceof Relationship) {
                    Relationship rel = (Relationship)propertyContainer;
                    if (ContextAwareStatementBuilder.anyLabelMatches(rel.getLeft(), tf.getName())) {
                        return this.makeId(rel.getLeft(), tf.getName());
                    }
                    if (ContextAwareStatementBuilder.anyLabelMatches(rel.getRight(), tf.getName())) {
                        return this.makeId(rel.getRight(), tf.getName());
                    }
                }
                col = propertyContainer.getSymbolicName().filter(f -> !f.getValue().equals(tf.getName())).map(__ -> {
                    Property property = propertyContainer.property(tf.getName());
                    if (doAlias) {
                        return property.as(tf.getName());
                    }
                    return property;
                }).orElse(null);
            } else if (this.databaseMetaData != null) {
                boolean isId = ContextAwareStatementBuilder.isElementId(tf);
                String prefix = ContextAwareStatementBuilder.isFkId(tf);
                for (Table<?> table : this.tables) {
                    PropertyContainer pc;
                    String tableName = this.labelOrType(table);
                    if (isId) {
                        pc = (PropertyContainer)((Object)this.resolveTableOrJoinf(table).get(0));
                        return this.makeId(pc, tf.getName());
                    }
                    if (tableName.equalsIgnoreCase(prefix)) {
                        pc = (PropertyContainer)((Object)this.resolveTableOrJoinf(table).get(0));
                        return this.makeId(pc, tf.getName());
                    }
                    try {
                        ResultSet columns = this.databaseMetaData.getColumns(null, null, tableName, null);
                        try {
                            while (columns.next()) {
                                String columnName = columns.getString("COLUMN_NAME");
                                if (!columnName.equals(tf.getName())) continue;
                                PropertyContainer pc2 = (PropertyContainer)((Object)this.resolveTableOrJoinf(table).get(0));
                                col = pc2.property(tf.getName());
                            }
                        }
                        finally {
                            if (columns == null) continue;
                            columns.close();
                        }
                    }
                    catch (SQLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
            if (col == null && fallbackToFieldName) {
                col = Cypher.name(tf.getName());
            }
            return col;
        }

        private Expression expression(Field<?> f) {
            return this.expression(f, false);
        }

        private Expression expression(Field<?> f, boolean turnUnknownIntoNames) {
            QOM.ArrayGet g;
            Object Q1;
            QOM.Excluded excluded;
            if (f instanceof Param) {
                Param p = (Param)f;
                if (p.$inline()) {
                    return Cypher.literalOf(p.getValue());
                }
                String parameterName = p.getParamType() == ParamType.INDEXED || p.getParamType() == ParamType.FORCE_INDEXED ? this.parameterNameGenerator.newIndex() : this.parameterNameGenerator.newIndex(p.getParamName());
                return parameterName != null ? Cypher.parameter(parameterName, p.getValue()) : Cypher.anonParameter(p.getValue());
            }
            if (f instanceof TableField) {
                TableField tf = (TableField)f;
                if (tf.getTable() == null) {
                    Expression tableField = this.findTableFieldInTables(tf, turnUnknownIntoNames, false);
                    if (tableField == null) {
                        throw ContextAwareStatementBuilder.unsupported(tf);
                    }
                    return tableField;
                }
                PatternElement pe = this.resolveTableOrJoinf(tf.getTable()).get(0);
                if (pe instanceof PropertyContainer) {
                    PropertyContainer pc = (PropertyContainer)((Object)pe);
                    Matcher matcher = ELEMENT_ID_PATTERN.matcher(tf.getName());
                    if (matcher.matches()) {
                        PropertyContainer src = pc;
                        String prefix = matcher.group("prefix");
                        if (pc instanceof Relationship) {
                            Relationship rel = (Relationship)pc;
                            if (!"element".equalsIgnoreCase(prefix)) {
                                if (rel.getLeft().getLabels().get(0).getValue().equalsIgnoreCase(prefix)) {
                                    src = rel.getLeft();
                                } else if (rel.getRight().getLabels().get(0).getValue().equalsIgnoreCase(prefix)) {
                                    src = rel.getRight();
                                }
                            }
                        }
                        return this.makeId(src, tf.getName());
                    }
                    return pc.property(tf.getName());
                }
                throw ContextAwareStatementBuilder.unsupported(tf);
            }
            if (f instanceof QOM.Add) {
                QOM.Add e = (QOM.Add)f;
                return this.expression((Field)e.$arg1()).add(this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Sub) {
                QOM.Sub e = (QOM.Sub)f;
                return this.expression((Field)e.$arg1()).subtract(this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Mul) {
                QOM.Mul e = (QOM.Mul)f;
                return this.expression((Field)e.$arg1()).multiply(this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Square) {
                QOM.Square e = (QOM.Square)f;
                return this.expression((Field)e.$arg1()).multiply(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Div) {
                QOM.Div e = (QOM.Div)f;
                return this.expression((Field)e.$arg1()).divide(this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Neg) {
                QOM.Neg e = (QOM.Neg)f;
                throw ContextAwareStatementBuilder.unsupported(e);
            }
            if (f instanceof QOM.Abs) {
                QOM.Abs e = (QOM.Abs)f;
                return Cypher.abs(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Ceil) {
                QOM.Ceil e = (QOM.Ceil)f;
                return Cypher.ceil(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Floor) {
                QOM.Floor e = (QOM.Floor)f;
                return Cypher.floor(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Round) {
                QOM.Round e = (QOM.Round)f;
                if (e.$arg2() == null) {
                    return Cypher.round(this.expression((Field)e.$arg1()), new Expression[0]);
                }
                return Cypher.round(this.expression((Field)e.$arg1()), this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Sign) {
                QOM.Sign e = (QOM.Sign)f;
                return Cypher.sign(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Rand) {
                return Cypher.rand();
            }
            if (f instanceof QOM.Euler) {
                return Cypher.e();
            }
            if (f instanceof QOM.Exp) {
                QOM.Exp e = (QOM.Exp)f;
                return Cypher.exp(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Ln) {
                QOM.Ln e = (QOM.Ln)f;
                return Cypher.log(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Log) {
                QOM.Log e = (QOM.Log)f;
                return Cypher.log(this.expression((Field)e.$arg1())).divide(Cypher.log(this.expression((Field)e.$arg2())));
            }
            if (f instanceof QOM.Log10) {
                QOM.Log10 e = (QOM.Log10)f;
                return Cypher.log10(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Sqrt) {
                QOM.Sqrt e = (QOM.Sqrt)f;
                return Cypher.sqrt(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Acos) {
                QOM.Acos e = (QOM.Acos)f;
                return Cypher.acos(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Asin) {
                QOM.Asin e = (QOM.Asin)f;
                return Cypher.asin(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Atan) {
                QOM.Atan e = (QOM.Atan)f;
                return Cypher.atan(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Atan2) {
                QOM.Atan2 e = (QOM.Atan2)f;
                return Cypher.atan2(this.expression((Field)e.$arg1()), this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Cos) {
                QOM.Cos e = (QOM.Cos)f;
                return Cypher.cos(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Cot) {
                QOM.Cot e = (QOM.Cot)f;
                return Cypher.cot(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Degrees) {
                QOM.Degrees e = (QOM.Degrees)f;
                return Cypher.degrees(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Pi) {
                return Cypher.pi();
            }
            if (f instanceof QOM.Radians) {
                QOM.Radians e = (QOM.Radians)f;
                return Cypher.radians(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Sin) {
                QOM.Sin e = (QOM.Sin)f;
                return Cypher.sin(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Tan) {
                QOM.Tan e = (QOM.Tan)f;
                return Cypher.tan(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.CharLength) {
                QOM.CharLength e = (QOM.CharLength)f;
                return Cypher.size(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Left) {
                QOM.Left e = (QOM.Left)f;
                return Cypher.left(this.expression((Field)e.$arg1()), this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Lower) {
                QOM.Lower e = (QOM.Lower)f;
                return Cypher.toLower(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Ltrim) {
                QOM.Ltrim e = (QOM.Ltrim)f;
                return Cypher.ltrim(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Replace) {
                QOM.Replace e = (QOM.Replace)f;
                return Cypher.replace(this.expression((Field)e.$arg1()), this.expression((Field)e.$arg2()), this.expression((Field)e.$arg3()));
            }
            if (f instanceof QOM.Reverse) {
                QOM.Reverse e = (QOM.Reverse)f;
                return Cypher.reverse(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Right) {
                QOM.Right e = (QOM.Right)f;
                return Cypher.right(this.expression((Field)e.$arg1()), this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Rtrim) {
                QOM.Rtrim e = (QOM.Rtrim)f;
                return Cypher.rtrim(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Substring) {
                QOM.Substring e = (QOM.Substring)f;
                Expression length = this.expression((Field)e.$arg3());
                if (length != Cypher.literalNull()) {
                    return Cypher.substring(this.expression((Field)e.$arg1()), this.expression((Field)e.$arg2()), length);
                }
                return Cypher.substring(this.expression((Field)e.$arg1()), this.expression((Field)e.$arg2()), null);
            }
            if (f instanceof QOM.Trim) {
                QOM.Trim e = (QOM.Trim)f;
                if (e.$arg2() != null) {
                    throw ContextAwareStatementBuilder.unsupported(e);
                }
                return Cypher.trim(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Upper) {
                QOM.Upper e = (QOM.Upper)f;
                return Cypher.toUpper(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Coalesce) {
                QOM.Coalesce e = (QOM.Coalesce)f;
                return Cypher.coalesce((Expression[])((QOM.UnmodifiableList)e.$arg1()).stream().map(this::expression).toArray(Expression[]::new));
            }
            if (f instanceof QOM.Nvl) {
                QOM.Nvl e = (QOM.Nvl)f;
                return Cypher.coalesce(this.expression((Field)e.$arg1()), this.expression((Field)e.$arg2()));
            }
            if (f instanceof QOM.Nullif) {
                QOM.Nullif e = (QOM.Nullif)f;
                return Cypher.caseExpression().when(this.expression((Field)e.$arg1()).eq(this.expression((Field)e.$arg2()))).then(Cypher.literalNull()).elseDefault(this.expression((Field)e.$arg1()));
            }
            if (f instanceof QOM.Nvl2) {
                QOM.Nvl2 e = (QOM.Nvl2)f;
                return Cypher.caseExpression().when(this.expression((Field)e.$arg1()).isNotNull()).then(this.expression((Field)e.$arg2())).elseDefault(this.expression((Field)e.$arg3()));
            }
            if (f instanceof QOM.CaseSimple) {
                QOM.CaseSimple e = (QOM.CaseSimple)f;
                Case c = Cypher.caseExpression(this.expression(e.$value()));
                for (QOM.Tuple2 tuple2 : e.$when()) {
                    c = c.when(this.expression((Field)tuple2.$1())).then(this.expression((Field)tuple2.$2()));
                }
                if (e.$else() != null) {
                    c = ((Case.CaseEnding)c).elseDefault(this.expression(e.$else()));
                }
                return c;
            }
            if (f instanceof QOM.CaseSearched) {
                QOM.CaseSearched e = (QOM.CaseSearched)f;
                Case c = Cypher.caseExpression();
                for (QOM.Tuple2 tuple2 : e.$when()) {
                    c = c.when(this.condition((Condition)tuple2.$1())).then(this.expression((Field)tuple2.$2()));
                }
                if (e.$else() != null) {
                    c = ((Case.CaseEnding)c).elseDefault(this.expression(e.$else()));
                }
                return c;
            }
            if (f instanceof QOM.Cast) {
                QOM.Cast e = (QOM.Cast)f;
                if (e.$dataType().isString()) {
                    return Cypher.toString(this.expression(e.$field()));
                }
                if (e.$dataType().isBoolean()) {
                    return Cypher.toBoolean(this.expression(e.$field()));
                }
                if (e.$dataType().isFloat()) {
                    return Cypher.toFloat(this.expression(e.$field()));
                }
                if (e.$dataType().isInteger()) {
                    return Cypher.toInteger(this.expression(e.$field()));
                }
                throw ContextAwareStatementBuilder.unsupported(f);
            }
            if (f instanceof True) {
                return Cypher.literalTrue();
            }
            if (f instanceof False) {
                return Cypher.literalFalse();
            }
            if (f instanceof QOM.Null || f == null || f instanceof Null) {
                return Cypher.literalNull();
            }
            if (f instanceof QOM.Function) {
                QOM.Function func = (QOM.Function)f;
                return this.buildFunction(func);
            }
            if (f instanceof QOM.Excluded && this.columnsAndValues.containsKey((excluded = (QOM.Excluded)f).$field().getName())) {
                return this.columnsAndValues.get(excluded.$field().getName());
            }
            if (f instanceof QOM.Count) {
                QOM.Count c = (QOM.Count)f;
                Field<?> field = c.$field();
                Expression exp = field instanceof Asterisk || "*".equals(field.toString()) ? Cypher.asterisk() : this.expression(field);
                return c.$distinct() ? Cypher.countDistinct(exp) : Cypher.count(exp);
            }
            if (f instanceof Asterisk) {
                return Cypher.asterisk();
            }
            if (f instanceof QOM.Min) {
                QOM.Min m = (QOM.Min)f;
                return Cypher.min(this.expression(m.$field()));
            }
            if (f instanceof QOM.Max) {
                QOM.Max m = (QOM.Max)f;
                return Cypher.max(this.expression(m.$field()));
            }
            if (f instanceof QOM.Sum) {
                QOM.Sum s = (QOM.Sum)f;
                return Cypher.sum(this.expression(s.$field()));
            }
            if (f instanceof QOM.Avg) {
                QOM.Avg s = (QOM.Avg)f;
                return Cypher.avg(this.expression(s.$field()));
            }
            if (f instanceof QOM.StddevSamp) {
                QOM.StddevSamp s = (QOM.StddevSamp)f;
                return Cypher.stDev(this.expression(s.$field()));
            }
            if (f instanceof QOM.StddevPop) {
                QOM.StddevPop s = (QOM.StddevPop)f;
                return Cypher.stDevP(this.expression(s.$field()));
            }
            if (f instanceof QOM.Position) {
                QOM.Position p = (QOM.Position)f;
                return ((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call(FUNCTION_MAPPING.get("strpos")).withArgs(this.expression(p.$in()), this.expression((Field)p.$arg2()))).asFunction();
            }
            if (f instanceof QOM.ArrayGet && (Q1 = (g = (QOM.ArrayGet)f).$arg1()) instanceof TableField) {
                TableField tf = (TableField)Q1;
                return Cypher.valueAt(this.expression(tf), this.expression((Field)g.$arg2()));
            }
            if (f instanceof QOM.CurrentTimestamp) {
                return Cypher.localdatetime();
            }
            throw ContextAwareStatementBuilder.unsupported(f);
        }

        private Expression buildFunction(QOM.Function<?> func) {
            Function<Field, Expression> asExpression = v -> this.expression((Field<?>)v, true);
            Expression[] args = (Expression[])func.$args().stream().map(asExpression).toArray(Expression[]::new);
            return ((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call(FUNCTION_MAPPING.getOrDefault(func.getName().toLowerCase(Locale.ROOT), func.getName())).withArgs(args)).asFunction();
        }

        private <T> org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition(Condition c) {
            try {
                QOM.FieldCondition fc;
                Object object;
                this.useAliasForVColumn.set(false);
                if (c instanceof QOM.And) {
                    QOM.And a = (QOM.And)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.condition((Condition)a.$arg1()).and(this.condition((Condition)a.$arg2()));
                    return condition;
                }
                if (c instanceof QOM.Or) {
                    QOM.Or o = (QOM.Or)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.condition((Condition)o.$arg1()).or(this.condition((Condition)o.$arg2()));
                    return condition;
                }
                if (c instanceof QOM.Xor) {
                    QOM.Xor o = (QOM.Xor)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.condition((Condition)o.$arg1()).xor(this.condition((Condition)o.$arg2()));
                    return condition;
                }
                if (c instanceof QOM.Not) {
                    QOM.Not o = (QOM.Not)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.condition((Condition)o.$arg1()).not();
                    return condition;
                }
                if (c instanceof QOM.Eq) {
                    QOM.Eq e = (QOM.Eq)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.expression((Field)e.$arg1()).eq(this.expression((Field)e.$arg2()));
                    return condition;
                }
                if (c instanceof QOM.Gt) {
                    QOM.Gt e = (QOM.Gt)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.expression((Field)e.$arg1()).gt(this.expression((Field)e.$arg2()));
                    return condition;
                }
                if (c instanceof QOM.Ge) {
                    QOM.Ge e = (QOM.Ge)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.expression((Field)e.$arg1()).gte(this.expression((Field)e.$arg2()));
                    return condition;
                }
                if (c instanceof QOM.Lt) {
                    QOM.Lt e = (QOM.Lt)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.expression((Field)e.$arg1()).lt(this.expression((Field)e.$arg2()));
                    return condition;
                }
                if (c instanceof QOM.Le) {
                    QOM.Le e = (QOM.Le)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.expression((Field)e.$arg1()).lte(this.expression((Field)e.$arg2()));
                    return condition;
                }
                if (c instanceof QOM.Between) {
                    QOM.Between e = (QOM.Between)c;
                    if (e.$symmetric()) {
                        QOM.Between t = e;
                        org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.condition(t.$symmetric(false)).or(this.condition((Condition)((QOM.Between)t.$symmetric(false).$arg2((Field)t.$arg3())).$arg3((Field)t.$arg2())));
                        return condition;
                    }
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition t = this.expression((Field)e.$arg2()).lte(this.expression((Field)e.$arg1())).and(this.expression((Field)e.$arg1()).lte(this.expression((Field)e.$arg3())));
                    return t;
                }
                if (c instanceof QOM.Ne) {
                    QOM.Ne e = (QOM.Ne)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition t = this.expression((Field)e.$arg1()).ne(this.expression((Field)e.$arg2()));
                    return t;
                }
                if (c instanceof QOM.IsNull) {
                    QOM.IsNull e = (QOM.IsNull)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition t = this.expression((Field)e.$arg1()).isNull();
                    return t;
                }
                if (c instanceof QOM.IsNotNull) {
                    QOM.IsNotNull e = (QOM.IsNotNull)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition t = this.expression((Field)e.$arg1()).isNotNull();
                    return t;
                }
                if (c instanceof QOM.RowEq) {
                    QOM.RowEq e = (QOM.RowEq)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition result = null;
                    for (int i = 0; i < ((Row)e.$arg1()).size(); ++i) {
                        org.neo4j.jdbc.internal.shaded.cypherdsl.Condition r = this.expression(((Row)e.$arg1()).field(i)).eq(this.expression(((Row)e.$arg2()).field(i)));
                        result = result != null ? result.and(r) : r;
                    }
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition i = result;
                    return i;
                }
                if (c instanceof QOM.RowNe) {
                    QOM.RowNe e = (QOM.RowNe)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition result = null;
                    for (int i = 0; i < ((Row)e.$arg1()).size(); ++i) {
                        org.neo4j.jdbc.internal.shaded.cypherdsl.Condition r = this.expression(((Row)e.$arg1()).field(i)).ne(this.expression(((Row)e.$arg2()).field(i)));
                        result = result != null ? result.and(r) : r;
                    }
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = result;
                    return condition;
                }
                if (c instanceof QOM.RowGt) {
                    QOM.RowGt e = (QOM.RowGt)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.rowCondition((Row)e.$arg1(), (Row)e.$arg2(), Expression::gt, Expression::gt);
                    return condition;
                }
                if (c instanceof QOM.RowGe) {
                    QOM.RowGe e = (QOM.RowGe)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.rowCondition((Row)e.$arg1(), (Row)e.$arg2(), Expression::gt, Expression::gte);
                    return condition;
                }
                if (c instanceof QOM.RowLt) {
                    QOM.RowLt e = (QOM.RowLt)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.rowCondition((Row)e.$arg1(), (Row)e.$arg2(), Expression::lt, Expression::lt);
                    return condition;
                }
                if (c instanceof QOM.RowLe) {
                    QOM.RowLe e = (QOM.RowLe)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.rowCondition((Row)e.$arg1(), (Row)e.$arg2(), Expression::lt, Expression::lte);
                    return condition;
                }
                if (c instanceof QOM.RowIsNull) {
                    QOM.RowIsNull e = (QOM.RowIsNull)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = ((Row)e.$arg1()).$fields().stream().map(f -> this.expression((Field<?>)f).isNull()).reduce(org.neo4j.jdbc.internal.shaded.cypherdsl.Condition::and).orElseThrow();
                    return condition;
                }
                if (c instanceof QOM.RowIsNotNull) {
                    QOM.RowIsNotNull e = (QOM.RowIsNotNull)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = ((Row)e.$arg1()).$fields().stream().map(f -> this.expression((Field<?>)f).isNotNull()).reduce(org.neo4j.jdbc.internal.shaded.cypherdsl.Condition::and).orElseThrow();
                    return condition;
                }
                if (c instanceof QOM.Like) {
                    QOM.Like like = (QOM.Like)c;
                    org.neo4j.jdbc.internal.shaded.cypherdsl.Condition condition = this.like(like);
                    return condition;
                }
                if (c instanceof QOM.FieldCondition && (object = (fc = (QOM.FieldCondition)c).$field()) instanceof Param) {
                    Param param = (Param)object;
                    object = (Boolean.TRUE.equals(param.getValue()) ? Cypher.literalTrue() : Cypher.literalFalse()).asCondition();
                    return object;
                }
                if (c instanceof QOM.InList) {
                    QOM.InList il = (QOM.InList)c;
                    object = this.expression(il.$field()).in(Cypher.listOf(il.$list().stream().map(this::expression).toList()));
                    return object;
                }
                throw ContextAwareStatementBuilder.unsupported(c);
            }
            finally {
                this.useAliasForVColumn.set(true);
            }
        }

        private org.neo4j.jdbc.internal.shaded.cypherdsl.Condition like(QOM.Like like) {
            Literal rhs;
            Param p;
            Expression lhs = this.expression((Field)like.$arg1());
            Object object = like.$arg2();
            if (object instanceof Param && (p = (Param)object).$inline() && (object = p.getValue()) instanceof String) {
                final String s = (String)object;
                boolean sw = s.startsWith("%");
                boolean ew = s.endsWith("%");
                int length = s.length();
                var cnt = new LongSupplier(){
                    Long value;

                    @Override
                    public long getAsLong() {
                        if (this.value == null) {
                            this.value = PERCENT_OR_UNDERSCORE.matcher(s).results().count();
                        }
                        return this.value;
                    }
                };
                if (sw && ew && length > 2 && cnt.getAsLong() == 2L) {
                    return lhs.contains(Cypher.literalOf(s.substring(1, length - 1)));
                }
                if (sw && length > 1 && cnt.getAsLong() == 1L) {
                    return lhs.endsWith(Cypher.literalOf(s.substring(1)));
                }
                if (ew && length > 1 && cnt.getAsLong() == 1L) {
                    return lhs.startsWith(Cypher.literalOf(s.substring(0, length - 1)));
                }
                rhs = Cypher.literalOf(s.replaceAll("%+", ".*").replace("_", "."));
            } else {
                rhs = this.expression((Field)like.$arg2());
            }
            return lhs.matches(rhs);
        }

        private org.neo4j.jdbc.internal.shaded.cypherdsl.Condition rowCondition(Row r1, Row r2, BiFunction<? super Expression, ? super Expression, ? extends org.neo4j.jdbc.internal.shaded.cypherdsl.Condition> comp, BiFunction<? super Expression, ? super Expression, ? extends org.neo4j.jdbc.internal.shaded.cypherdsl.Condition> last) {
            org.neo4j.jdbc.internal.shaded.cypherdsl.Condition result = last.apply(this.expression(r1.field(r1.size() - 1)), this.expression(r2.field(r1.size() - 1)));
            for (int i = r1.size() - 2; i >= 0; --i) {
                Expression e1 = this.expression(r1.field(i));
                Expression e2 = this.expression(r2.field(i));
                result = comp.apply(e1, e2).or(e1.eq(e2).and(result));
            }
            return result;
        }

        private List<PatternElement> resolveTableOrJoinf(Table<?> t) {
            PatternElement relationship = this.resolvedRelationships.get(Cypher.name(t.getName()));
            if (relationship != null) {
                return List.of(relationship);
            }
            if (t instanceof QOM.JoinTable) {
                QOM.JoinTable joinTable = (QOM.JoinTable)t;
                return this.resolveJoin(joinTable);
            }
            if (t instanceof QOM.TableAlias) {
                PatternElement resolved;
                QOM.TableAlias ta = (QOM.TableAlias)t;
                List<PatternElement> patternElements = this.resolveTableOrJoinf((Table<?>)ta.$aliased());
                PatternElement patternElement = resolved = patternElements.size() == 1 ? patternElements.get(0) : null;
                if ((resolved instanceof Node || resolved instanceof Relationship) && !ta.$alias().empty()) {
                    return List.of(this.nodeOrPattern((Table<?>)ta.$aliased(), ta.$alias().last()));
                }
                throw ContextAwareStatementBuilder.unsupported(ta);
            }
            return List.of(this.nodeOrPattern(t, t.getName()));
        }

        private PatternElement nodeOrPattern(Table<?> t, String name) {
            String primaryLabel = this.labelOrType(t);
            SymbolicName symbolicName = ContextAwareStatementBuilder.symbolicName(Objects.requireNonNull(name));
            if (primaryLabel.contains("_") && this.databaseMetaData != null) {
                PatternElement relationship = this.resolvedRelationships.get(symbolicName);
                if (relationship != null) {
                    return relationship;
                }
                try {
                    ResultSet resultSet = this.databaseMetaData.getTables(null, null, primaryLabel, new String[]{"RELATIONSHIP"});
                    if (resultSet != null && resultSet.next()) {
                        String[] definition = resultSet.getString("REMARKS").split("\n");
                        relationship = ((Relationship)Cypher.node(definition[0], new String[0]).named("_lhs").relationshipTo(Cypher.node(definition[2], new String[0]).named("_rhs"), definition[1])).named(symbolicName);
                        this.resolvedRelationships.put(symbolicName, relationship);
                        return relationship;
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return Cypher.node(primaryLabel, new String[0]).named(symbolicName);
        }

        private List<PatternElement> resolveJoin(QOM.JoinTable<?, ? extends Table<?>> joinTable) {
            RelationshipPattern relationship;
            PatternElement lhs;
            JoinDetails join = JoinDetails.of(joinTable);
            String relType = null;
            SymbolicName relSymbolicName = null;
            Table<?> t1 = joinTable.$table1();
            if (t1 instanceof QOM.JoinTable) {
                QOM.JoinTable lhsJoin = (QOM.JoinTable)t1;
                lhs = this.resolveTableOrJoinf(lhsJoin.$table1()).get(0);
                JoinDetails eqJoin2 = JoinDetails.of(lhsJoin);
                RelationshipPattern relationship2 = this.tryToIntegrateNodeAndVirtualTable(lhs, this.resolveTableOrJoinf(lhsJoin.$table2()).get(0), eqJoin2.eq);
                if (relationship2 != null) {
                    lhs = relationship2;
                } else {
                    relType = this.labelOrType(lhsJoin.$table2());
                    Table<?> table = lhsJoin.$table2();
                    if (table instanceof QOM.TableAlias) {
                        QOM.TableAlias tableAlias = (QOM.TableAlias)table;
                        relSymbolicName = ContextAwareStatementBuilder.symbolicName(tableAlias.getName());
                    }
                }
            } else if (join.eq != null) {
                lhs = this.resolveTableOrJoinf(t1).get(0);
                relType = this.type(t1, (Field)join.eq.$arg2());
            } else {
                if (join.join != null && join.join.$using().isEmpty()) {
                    throw ContextAwareStatementBuilder.unsupported(joinTable);
                }
                lhs = this.resolveTableOrJoinf(t1).get(0);
                String string = relType = join.join != null ? this.type(t1, (Field)join.join.$using().get(0)) : null;
            }
            if (relSymbolicName == null && relType != null) {
                relSymbolicName = ContextAwareStatementBuilder.symbolicName(relType);
            }
            PatternElement rhs = this.resolveTableOrJoinf(joinTable.$table2()).get(0);
            if (lhs instanceof ExposesRelationships) {
                ExposesRelationships from = (ExposesRelationships)((Object)lhs);
                if (rhs instanceof Node) {
                    QOM.TableAlias ta;
                    QOM.JoinTable previousJoinTable;
                    Node to = (Node)rhs;
                    relationship = this.tryToIntegrateNodeAndVirtualTable(lhs, rhs, join.eq);
                    if (relationship != null) {
                        return List.of(relationship);
                    }
                    ArrayList<PatternElement> resolved = new ArrayList<PatternElement>();
                    Table<?> leftMost = joinTable.$table1();
                    while (leftMost instanceof QOM.JoinTable) {
                        QOM.JoinTable tab = (QOM.JoinTable)leftMost;
                        leftMost = tab.$table1();
                    }
                    PatternElement hlp = this.resolveTableOrJoinf(leftMost).get(0);
                    if (from instanceof Relationship) {
                        Relationship r = (Relationship)from;
                        if (hlp instanceof Node) {
                            Object object;
                            Node leftMostNode = (Node)hlp;
                            if (r.getLeft().getRequiredSymbolicName().equals(leftMostNode.getRequiredSymbolicName()) && (object = joinTable.$table1()) instanceof QOM.JoinTable && (object = this.nodeOrPattern((previousJoinTable = (QOM.JoinTable)object).$table2(), "ignored")) instanceof Relationship) {
                                Relationship targetRelationship = (Relationship)object;
                                resolved.add(lhs);
                                from = leftMostNode;
                                relType = targetRelationship.getDetails().getTypes().get(0);
                            }
                        }
                    }
                    Relationship.Direction direction = Relationship.Direction.LTR;
                    if (join.eq != null && (previousJoinTable = joinTable.$table2()) instanceof QOM.TableAlias && !(ta = (QOM.TableAlias)((Object)previousJoinTable)).$alias().empty() && Objects.equals(ta.$alias().last(), ((Field)join.eq.$arg2()).getQualifiedName().first())) {
                        direction = Relationship.Direction.RTL;
                    }
                    relationship = from.relationshipWith(to, direction, relType);
                    if (relSymbolicName != null) {
                        if (relationship instanceof Relationship) {
                            Relationship r = (Relationship)relationship;
                            relationship = r.named(relSymbolicName);
                        } else if (relationship instanceof RelationshipChain) {
                            RelationshipChain r = (RelationshipChain)relationship;
                            relationship = r.named(relSymbolicName);
                        }
                        this.resolvedRelationships.put(relSymbolicName, relationship);
                    }
                    resolved.add(relationship);
                    return resolved;
                }
            }
            if ((relationship = this.tryToIntegrateNodeAndVirtualTable(lhs, rhs, join.eq)) != null) {
                return List.of(relationship);
            }
            throw ContextAwareStatementBuilder.unsupported(joinTable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RelationshipPattern tryToIntegrateNodeAndVirtualTable(PatternElement lhs, PatternElement rhs, QOM.Eq<?> eq) {
            Relationship relationship;
            Relationship rel;
            Node hlp;
            Node node;
            ExposesRelationships<Relationship> hlp2;
            ExposesRelationships<Relationship> exposesRelationships = lhs instanceof Node ? (hlp2 = (Node)lhs) : (node = rhs instanceof Node ? (hlp = (Node)rhs) : null);
            if (lhs instanceof Relationship) {
                Relationship hlp3;
                v1 = hlp3 = (Relationship)lhs;
            } else if (rhs instanceof Relationship) {
                hlp2 = (Relationship)rhs;
                v1 = hlp2;
            } else {
                v1 = rel = null;
            }
            if (eq == null || node == null || rel == null) {
                return null;
            }
            if (ContextAwareStatementBuilder.isElementId((Field)eq.$arg1()) && ContextAwareStatementBuilder.anyLabelMatches(rel.getLeft(), ((Field)eq.$arg2()).$name().last()) || ContextAwareStatementBuilder.isElementId((Field)eq.$arg2()) && ContextAwareStatementBuilder.anyLabelMatches(rel.getLeft(), ((Field)eq.$arg1()).$name().last())) {
                relationship = ((Relationship)node.relationshipTo(rel.getRight(), (String[])rel.getDetails().getTypes().toArray(String[]::new))).named(rel.getRequiredSymbolicName());
                this.resolvedRelationships.put(relationship.getRequiredSymbolicName(), relationship);
                return relationship;
            }
            if (ContextAwareStatementBuilder.isElementId((Field)eq.$arg1()) && ContextAwareStatementBuilder.anyLabelMatches(rel.getRight(), ((Field)eq.$arg2()).$name().last()) || ContextAwareStatementBuilder.isElementId((Field)eq.$arg2()) && ContextAwareStatementBuilder.anyLabelMatches(rel.getRight(), ((Field)eq.$arg1()).$name().last())) {
                relationship = ((Relationship)rel.getLeft().relationshipTo(node, (String[])rel.getDetails().getTypes().toArray(String[]::new))).named(rel.getRequiredSymbolicName());
                this.resolvedRelationships.put(relationship.getRequiredSymbolicName(), relationship);
                return relationship;
            }
            if (ContextAwareStatementBuilder.fitsLeftOrRight(node, rel)) {
                try {
                    this.useAliasForVColumn.set(false);
                    Expression e1 = null;
                    Expression e2 = null;
                    PatternElement relationship2 = null;
                    if (ContextAwareStatementBuilder.isElementIdFor((Field)eq.$arg1(), rel.getLeft())) {
                        relationship2 = ((Relationship)node.relationshipTo(rel.getRight(), (String[])rel.getDetails().getTypes().toArray(String[]::new))).named(rel.getRequiredSymbolicName());
                        e1 = this.makeId(relationship2.getLeft(), null);
                        e2 = this.makeId((PropertyContainer)((Object)relationship2), null);
                    } else if (ContextAwareStatementBuilder.isElementIdFor((Field)eq.$arg1(), rel.getRight())) {
                        relationship2 = ((Relationship)rel.getLeft().relationshipTo(node, (String[])rel.getDetails().getTypes().toArray(String[]::new))).named(rel.getRequiredSymbolicName());
                        e1 = this.makeId(relationship2.getRight(), null);
                        e2 = this.makeId((PropertyContainer)((Object)relationship2), null);
                    }
                    if (relationship2 != null) {
                        relationship2 = (Relationship)relationship2.where(Cypher.isEqualTo(e1, e2));
                        this.resolvedRelationships.put(relationship2.getRequiredSymbolicName(), relationship2);
                        PatternElement patternElement = relationship2;
                        return patternElement;
                    }
                }
                finally {
                    this.useAliasForVColumn.set(true);
                }
            }
            return null;
        }

        static boolean isElementId(Field<?> field) {
            Matcher matcher = ELEMENT_ID_PATTERN.matcher(Objects.requireNonNull(field.$name().last()));
            if (!matcher.matches()) {
                return false;
            }
            String prefix = matcher.group("prefix");
            return prefix == null || prefix.isBlank() || "element".equalsIgnoreCase(prefix);
        }

        static boolean isElementIdFor(Field<?> field, Node node) {
            if (!ContextAwareStatementBuilder.isElementId(field)) {
                return false;
            }
            return node.getLabels().stream().anyMatch(l -> l.getValue().equals(field.$name().first()));
        }

        static String isFkId(Field<?> field) {
            Matcher matcher = ELEMENT_ID_PATTERN.matcher(Objects.requireNonNull(field.$name().last()));
            if (!matcher.matches()) {
                return null;
            }
            String prefix = matcher.group("prefix");
            return prefix != null && !prefix.isBlank() ? prefix : null;
        }

        private static boolean fitsLeftOrRight(Node node, Relationship relationship) {
            boolean result = node.getLabels().stream().map(NodeLabel::getValue).anyMatch(l -> relationship.getLeft().getLabels().stream().map(NodeLabel::getValue).anyMatch(r -> r.equals(l)));
            if (result) {
                return result;
            }
            return node.getLabels().stream().map(NodeLabel::getValue).anyMatch(l -> relationship.getRight().getLabels().stream().map(NodeLabel::getValue).anyMatch(r -> r.equals(l)));
        }

        private static boolean anyLabelMatches(Node node, String needle) {
            if (needle == null) {
                return false;
            }
            return node.getLabels().stream().map(NodeLabel::getValue).map(arg_0 -> ContextAwareStatementBuilder.lambda$anyLabelMatches$32("v$%s_id", arg_0)).anyMatch(needle::equalsIgnoreCase);
        }

        private String labelOrType(Table<?> tableOrAlias) {
            QueryPart queryPart;
            if (tableOrAlias instanceof QOM.TableAlias) {
                QOM.TableAlias ta = (QOM.TableAlias)tableOrAlias;
                queryPart = ta.$aliased();
            } else {
                queryPart = tableOrAlias;
            }
            Table<?> t = queryPart;
            String comment = t.getComment();
            if (!comment.isBlank()) {
                Map<String, String> config = Arrays.stream(comment.split(",")).map(s -> s.split("=")).collect(Collectors.toMap(a -> a[0], a -> a[1]));
                return config.getOrDefault("label", t.getName());
            }
            return this.config.getTableToLabelMappings().entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(t.getName())).findFirst().map(Map.Entry::getValue).orElseGet(t::getName);
        }

        private String type(Table<?> tableOrAlias, Field<?> field) {
            QueryPart queryPart;
            if (tableOrAlias instanceof QOM.TableAlias) {
                QOM.TableAlias ta = (QOM.TableAlias)tableOrAlias;
                queryPart = ta.$aliased();
            } else {
                queryPart = tableOrAlias;
            }
            Table<?> t = queryPart;
            String key = t.getName() + "." + field.getName();
            return this.config.getJoinColumnsToTypeMappings().entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(key)).findFirst().map(Map.Entry::getValue).orElseGet(() -> ContextAwareStatementBuilder.relationshipTypeName(field));
        }

        private static /* synthetic */ String lambda$anyLabelMatches$32(String rec$, Object xva$0) {
            return "v$%s_id".formatted(xva$0);
        }
    }

    record JoinDetails(QOM.Join<?> join, QOM.Eq<?> eq) {
        static JoinDetails of(QOM.JoinTable<?, ?> joinTable) {
            QOM.Eq $eq;
            Condition condition;
            QOM.Join $join;
            QOM.Join join = joinTable instanceof QOM.Join ? ($join = (QOM.Join)joinTable) : null;
            QOM.Eq eq = join != null && (condition = join.$on()) instanceof QOM.Eq ? ($eq = (QOM.Eq)condition) : null;
            return new JoinDetails(join, eq);
        }
    }
}

