/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.values;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.jdbc.values.AsValue;
import org.neo4j.jdbc.values.Entity;
import org.neo4j.jdbc.values.MapAccessorWithDefaultValue;
import org.neo4j.jdbc.values.Node;
import org.neo4j.jdbc.values.Path;
import org.neo4j.jdbc.values.Relationship;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.Values;

abstract class AbstractMapAccessorWithDefaultValue
implements MapAccessorWithDefaultValue {
    AbstractMapAccessorWithDefaultValue() {
    }

    @Override
    public Value get(String key, Value defaultValue) {
        return AbstractMapAccessorWithDefaultValue.get(this.get(key), defaultValue);
    }

    private static Value get(Value value, Value defaultValue) {
        if (value.equals(Values.NULL)) {
            return defaultValue;
        }
        return ((AsValue)((Object)value)).asValue();
    }

    @Override
    public Object get(String key, Object defaultValue) {
        return AbstractMapAccessorWithDefaultValue.get(this.get(key), defaultValue);
    }

    private static Object get(Value value, Object defaultValue) {
        if (value.equals(Values.NULL)) {
            return defaultValue;
        }
        return value.asObject();
    }

    @Override
    public Number get(String key, Number defaultValue) {
        return AbstractMapAccessorWithDefaultValue.get(this.get(key), defaultValue);
    }

    private static Number get(Value value, Number defaultValue) {
        if (value.equals(Values.NULL)) {
            return defaultValue;
        }
        return value.asNumber();
    }

    @Override
    public Entity get(String key, Entity defaultValue) {
        return AbstractMapAccessorWithDefaultValue.get(this.get(key), defaultValue);
    }

    private static Entity get(Value value, Entity defaultValue) {
        if (value.equals(Values.NULL)) {
            return defaultValue;
        }
        return value.asEntity();
    }

    @Override
    public Node get(String key, Node defaultValue) {
        return AbstractMapAccessorWithDefaultValue.get(this.get(key), defaultValue);
    }

    private static Node get(Value value, Node defaultValue) {
        if (value.equals(Values.NULL)) {
            return defaultValue;
        }
        return value.asNode();
    }

    @Override
    public Path get(String key, Path defaultValue) {
        return AbstractMapAccessorWithDefaultValue.get(this.get(key), defaultValue);
    }

    private static Path get(Value value, Path defaultValue) {
        if (value.equals(Values.NULL)) {
            return defaultValue;
        }
        return value.asPath();
    }

    @Override
    public Relationship get(String key, Relationship defaultValue) {
        return AbstractMapAccessorWithDefaultValue.get(this.get(key), defaultValue);
    }

    private static Relationship get(Value value, Relationship defaultValue) {
        if (value.equals(Values.NULL)) {
            return defaultValue;
        }
        return value.asRelationship();
    }

    @Override
    public List<Object> get(String key, List<Object> defaultValue) {
        return AbstractMapAccessorWithDefaultValue.get(this.get(key), defaultValue);
    }

    private static List<Object> get(Value value, List<Object> defaultValue) {
        if (value.equals(Values.NULL)) {
            return defaultValue;
        }
        return value.asList();
    }

    @Override
    public <T> List<T> get(String key, List<T> defaultValue, Function<Value, T> mapFunc) {
        return AbstractMapAccessorWithDefaultValue.get(this.get(key), defaultValue, mapFunc);
    }

    private static <T> List<T> get(Value value, List<T> defaultValue, Function<Value, T> mapFunc) {
        if (value.equals(Values.NULL)) {
            return defaultValue;
        }
        return value.asList(mapFunc);
    }

    @Override
    public Map<String, Object> get(String key, Map<String, Object> defaultValue) {
        return AbstractMapAccessorWithDefaultValue.get(this.get(key), defaultValue);
    }

    private static Map<String, Object> get(Value value, Map<String, Object> defaultValue) {
        if (value.equals(Values.NULL)) {
            return defaultValue;
        }
        return value.asMap();
    }

    @Override
    public <T> Map<String, T> get(String key, Map<String, T> defaultValue, Function<Value, T> mapFunc) {
        return AbstractMapAccessorWithDefaultValue.get(this.get(key), defaultValue, mapFunc);
    }

    private static <T> Map<String, T> get(Value value, Map<String, T> defaultValue, Function<Value, T> mapFunc) {
        if (value.equals(Values.NULL)) {
            return defaultValue;
        }
        return value.asMap(mapFunc);
    }

    @Override
    public int get(String key, int defaultValue) {
        return AbstractMapAccessorWithDefaultValue.get(this.get(key), defaultValue);
    }

    private static int get(Value value, int defaultValue) {
        if (value.equals(Values.NULL)) {
            return defaultValue;
        }
        return value.asInt();
    }

    @Override
    public long get(String key, long defaultValue) {
        return AbstractMapAccessorWithDefaultValue.get(this.get(key), defaultValue);
    }

    private static long get(Value value, long defaultValue) {
        if (value.equals(Values.NULL)) {
            return defaultValue;
        }
        return value.asLong();
    }

    @Override
    public boolean get(String key, boolean defaultValue) {
        return AbstractMapAccessorWithDefaultValue.get(this.get(key), defaultValue);
    }

    private static boolean get(Value value, boolean defaultValue) {
        if (value.equals(Values.NULL)) {
            return defaultValue;
        }
        return value.asBoolean();
    }

    @Override
    public String get(String key, String defaultValue) {
        return AbstractMapAccessorWithDefaultValue.get(this.get(key), defaultValue);
    }

    private static String get(Value value, String defaultValue) {
        if (value.equals(Values.NULL)) {
            return defaultValue;
        }
        return value.asString();
    }

    @Override
    public float get(String key, float defaultValue) {
        return AbstractMapAccessorWithDefaultValue.get(this.get(key), defaultValue);
    }

    private static float get(Value value, float defaultValue) {
        if (value.equals(Values.NULL)) {
            return defaultValue;
        }
        return value.asFloat();
    }

    @Override
    public double get(String key, double defaultValue) {
        return AbstractMapAccessorWithDefaultValue.get(this.get(key), defaultValue);
    }

    private static double get(Value value, double defaultValue) {
        if (value.equals(Values.NULL)) {
            return defaultValue;
        }
        return value.asDouble();
    }

    protected static <V> String formatPairs(Map<String, V> map) {
        Iterator<Map.Entry<String, V>> iterator = map.entrySet().iterator();
        switch (map.size()) {
            case 0: {
                return "{}";
            }
            case 1: {
                return String.format("{%s}", AbstractMapAccessorWithDefaultValue.keyValueString(iterator.next()));
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(AbstractMapAccessorWithDefaultValue.keyValueString(iterator.next()));
        while (iterator.hasNext()) {
            builder.append(',');
            builder.append(' ');
            builder.append(AbstractMapAccessorWithDefaultValue.keyValueString(iterator.next()));
        }
        builder.append("}");
        return builder.toString();
    }

    private static <V> String keyValueString(Map.Entry<String, V> entry) {
        return String.format("%s: %s", entry.getKey(), entry.getValue());
    }
}

