/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.values;

import java.util.Arrays;
import java.util.HexFormat;
import org.neo4j.jdbc.values.AbstractValue;
import org.neo4j.jdbc.values.Type;

public final class BytesValue
extends AbstractValue {
    private final byte[] val;
    private static final HexFormat FORMATTER = HexFormat.of().withUpperCase();

    BytesValue(byte[] val) {
        if (val == null) {
            throw new IllegalArgumentException("Cannot construct BytesValue from null");
        }
        this.val = val;
    }

    @Override
    public boolean isEmpty() {
        return this.val.length == 0;
    }

    @Override
    public int size() {
        return this.val.length;
    }

    public byte[] asObject() {
        return this.val;
    }

    @Override
    public byte[] asByteArray() {
        return this.val;
    }

    @Override
    public Type type() {
        return Type.BYTES;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BytesValue values = (BytesValue)o;
        return Arrays.equals(this.val, values.val);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.val);
    }

    @Override
    public String toString() {
        return "X'" + FORMATTER.formatHex(this.val) + "'";
    }
}

