/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.values;

import org.neo4j.jdbc.values.AbstractNumberValue;
import org.neo4j.jdbc.values.LossyCoercion;
import org.neo4j.jdbc.values.Type;

public final class IntegerValue
extends AbstractNumberValue<Long> {
    private final long val;

    IntegerValue(long val) {
        this.val = val;
    }

    @Override
    public Type type() {
        return Type.INTEGER;
    }

    @Override
    public Long asNumber() {
        return this.val;
    }

    @Override
    public long asLong() {
        return this.val;
    }

    @Override
    public int asInt() {
        if (this.val > Integer.MAX_VALUE || this.val < Integer.MIN_VALUE) {
            throw new LossyCoercion(this.type().name(), "Java int");
        }
        return (int)this.val;
    }

    @Override
    public double asDouble() {
        double doubleVal = this.val;
        if ((long)doubleVal != this.val) {
            throw new LossyCoercion(this.type().name(), "Java double");
        }
        return this.val;
    }

    @Override
    public float asFloat() {
        return this.val;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegerValue values = (IntegerValue)o;
        return this.val == values.val;
    }

    @Override
    public int hashCode() {
        return (int)(this.val ^ this.val >>> 32);
    }

    @Override
    public String toString() {
        return Long.toString(this.val);
    }
}

