/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.values;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.neo4j.jdbc.values.IsoDuration;

final class IsoDurationImpl
implements IsoDuration {
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final List<TemporalUnit> SUPPORTED_UNITS = List.of(ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.SECONDS, ChronoUnit.NANOS);
    private final long months;
    private final long days;
    private final long seconds;
    private final int nanoseconds;
    private static final int PERIOD_MASK = 28;
    private static final int DURATION_MASK = 3;
    private static final TemporalUnit[] ALL_SUPPORTED_UNITS = new TemporalUnit[]{ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.SECONDS, ChronoUnit.NANOS};
    private static final short FIELD_YEAR = 0;
    private static final short FIELD_MONTH = 1;
    private static final short FIELD_DAY = 2;
    private static final short FIELD_SECONDS = 3;
    private static final short FIELD_NANOS = 4;
    private static final BiFunction<TemporalAmount, TemporalUnit, Integer> TEMPORAL_UNIT_EXTRACTOR = (d, u) -> {
        if (!d.getUnits().contains(u)) {
            return 0;
        }
        return Math.toIntExact(d.get((TemporalUnit)u));
    };

    IsoDurationImpl(Period period) {
        this(period.toTotalMonths(), period.getDays(), Duration.ZERO);
    }

    IsoDurationImpl(Duration duration) {
        this(0L, 0L, duration);
    }

    IsoDurationImpl(long months, long days, long seconds, int nanoseconds) {
        this(months, days, Duration.ofSeconds(seconds, nanoseconds));
    }

    IsoDurationImpl(long months, long days, Duration duration) {
        this.months = months;
        this.days = days;
        this.seconds = duration.getSeconds();
        this.nanoseconds = duration.getNano();
    }

    @Override
    public long months() {
        return this.months;
    }

    @Override
    public long days() {
        return this.days;
    }

    @Override
    public long seconds() {
        return this.seconds;
    }

    @Override
    public int nanoseconds() {
        return this.nanoseconds;
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == ChronoUnit.MONTHS) {
            return this.months;
        }
        if (unit == ChronoUnit.DAYS) {
            return this.days;
        }
        if (unit == ChronoUnit.SECONDS) {
            return this.seconds;
        }
        if (unit == ChronoUnit.NANOS) {
            return this.nanoseconds;
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + String.valueOf(unit));
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return SUPPORTED_UNITS;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        if (this.months != 0L) {
            temporal = temporal.plus(this.months, ChronoUnit.MONTHS);
        }
        if (this.days != 0L) {
            temporal = temporal.plus(this.days, ChronoUnit.DAYS);
        }
        if (this.seconds != 0L) {
            temporal = temporal.plus(this.seconds, ChronoUnit.SECONDS);
        }
        if (this.nanoseconds != 0) {
            temporal = temporal.plus(this.nanoseconds, ChronoUnit.NANOS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        if (this.months != 0L) {
            temporal = temporal.minus(this.months, ChronoUnit.MONTHS);
        }
        if (this.days != 0L) {
            temporal = temporal.minus(this.days, ChronoUnit.DAYS);
        }
        if (this.seconds != 0L) {
            temporal = temporal.minus(this.seconds, ChronoUnit.SECONDS);
        }
        if (this.nanoseconds != 0) {
            temporal = temporal.minus(this.nanoseconds, ChronoUnit.NANOS);
        }
        return temporal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsoDurationImpl that = (IsoDurationImpl)o;
        return this.months == that.months && this.days == that.days && this.seconds == that.seconds && this.nanoseconds == that.nanoseconds;
    }

    public int hashCode() {
        return Objects.hash(this.months, this.days, this.seconds, this.nanoseconds);
    }

    private String defaultStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        sb.append('P');
        sb.append(this.months).append('M');
        sb.append(this.days).append('D');
        sb.append('T');
        if (this.seconds < 0L && this.nanoseconds > 0) {
            if (this.seconds == -1L) {
                sb.append("-0");
            } else {
                sb.append(this.seconds + 1L);
            }
        } else {
            sb.append(this.seconds);
        }
        if (this.nanoseconds > 0) {
            int pos = sb.length();
            if (this.seconds < 0L) {
                sb.append(2000000000L - (long)this.nanoseconds);
            } else {
                sb.append(1000000000L + (long)this.nanoseconds);
            }
            sb.setCharAt(pos, '.');
        }
        sb.append('S');
        return sb.toString();
    }

    public String toString() {
        int[] values = new int[ALL_SUPPORTED_UNITS.length];
        int type = 0;
        for (int i = 0; i < ALL_SUPPORTED_UNITS.length; ++i) {
            values[i] = TEMPORAL_UNIT_EXTRACTOR.apply(this, ALL_SUPPORTED_UNITS[i]);
            type |= values[i] == 0 ? 0 : 16 >> i;
        }
        boolean couldBePeriod = IsoDurationImpl.couldBePeriod(type);
        boolean couldBeDuration = IsoDurationImpl.couldBeDuration(type);
        if (couldBePeriod && !couldBeDuration) {
            return Period.of(values[0], values[1], values[2]).normalized().toString();
        }
        if (couldBeDuration && !couldBePeriod) {
            return "DURATION '" + Duration.ofSeconds(values[3]).plusNanos(values[4]).toString() + "'";
        }
        return this.defaultStringRepresentation();
    }

    private static boolean couldBePeriod(int type) {
        return (0x1C & type) > 0;
    }

    private static boolean couldBeDuration(int type) {
        return (3 & type) > 0;
    }
}

