/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.lang.management.ManagementFactory;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.remote.JMXServiceURL;
import org.neo4j.helpers.Service;
import org.neo4j.jmx.impl.KernelBean;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementSupport;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelExtension;

public final class JmxExtension
extends KernelExtension<JmxData> {
    public static final String KEY = "kernel jmx";
    private static final Logger log = Logger.getLogger(JmxExtension.class.getName());

    public JmxExtension() {
        super(KEY);
    }

    protected JmxData load(KernelData kernel) {
        ManagementSupport support = ManagementSupport.load();
        MBeanServer mbs = support.getMBeanServer();
        LinkedList<Neo4jMBean> beans = new LinkedList<Neo4jMBean>();
        for (ManagementBeanProvider provider : Service.load(ManagementBeanProvider.class)) {
            try {
                Neo4jMBean bean = provider.loadBean(kernel, support);
                if (bean == null) continue;
                mbs.registerMBean(bean, bean.objectName);
                beans.add(bean);
            }
            catch (Exception e) {
                log.info("Failed to register JMX Bean " + (Object)((Object)provider));
            }
        }
        try {
            KernelBean bean = new KernelBean(kernel, support);
            mbs.registerMBean(bean, bean.objectName);
            beans.add(0, bean);
        }
        catch (Exception e) {
            log.info("Failed to register Kernel JMX Bean");
        }
        return new JmxData(kernel, support, beans.toArray(new Neo4jMBean[beans.size()]));
    }

    protected void unload(JmxData data) {
        data.shutdown();
    }

    public JMXServiceURL getConnectionURL(KernelData kernel) {
        return ((JmxData)this.getState(kernel)).url;
    }

    public static final class JmxData {
        private final Neo4jMBean[] beans;
        private final JMXServiceURL url;
        private final ManagementSupport support;

        private JmxData(KernelData kernel, ManagementSupport support, Neo4jMBean[] beans) {
            this.support = support;
            this.beans = beans;
            this.url = support.getJMXServiceURL(kernel);
        }

        void shutdown() {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            for (Neo4jMBean bean : this.beans) {
                try {
                    mbs.unregisterMBean(bean.objectName);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Failed to unregister JMX Bean " + bean, e);
                }
            }
        }

        public <T> T getManagementBean(Class<T> beanInterface) {
            if (this.support.getClass() != ManagementSupport.class && this.beans.length > 0 && this.beans[0] instanceof KernelBean) {
                return this.support.makeProxy((KernelBean)this.beans[0], beanInterface);
            }
            for (Neo4jMBean bean : this.beans) {
                if (!beanInterface.isInstance(bean)) continue;
                return beanInterface.cast(bean);
            }
            throw new UnsupportedOperationException("Cannot access management beans");
        }
    }
}

