/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.neo4j.helpers.Service;
import org.neo4j.jmx.ManagementInterface;
import org.neo4j.jmx.impl.KernelBean;
import org.neo4j.kernel.KernelData;

public class ManagementSupport {
    static final ManagementSupport load() {
        ManagementSupport support = new ManagementSupport();
        Iterator i$ = Service.load(ManagementSupport.class).iterator();
        while (i$.hasNext()) {
            ManagementSupport candidate;
            support = candidate = (ManagementSupport)i$.next();
        }
        return support;
    }

    protected MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    protected <T> T makeProxy(KernelBean kernel, Class<T> beanInterface) {
        throw new UnsupportedOperationException("Cannot create management bean proxies.");
    }

    protected boolean supportsMxBeans() {
        return false;
    }

    protected JMXServiceURL getJMXServiceURL(KernelData kernel) {
        return null;
    }

    public final ObjectName createObjectName(String instanceId, Class<?> beanInterface) {
        return this.createObjectName(instanceId, this.getBeanName(beanInterface));
    }

    public final ObjectName createMBeanQuery(String instanceId) {
        return this.createObjectName(instanceId, "*");
    }

    protected String getBeanName(Class<?> beanInterface) {
        return ManagementSupport.beanName(beanInterface);
    }

    protected ObjectName createObjectName(String instanceId, String beanName) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("instance", "kernel#" + instanceId);
        properties.put("name", beanName);
        try {
            return new ObjectName("org.neo4j", properties);
        }
        catch (MalformedObjectNameException e) {
            return null;
        }
    }

    static String beanName(Class<?> iface) {
        ManagementInterface management;
        if (iface.isInterface() && (management = iface.getAnnotation(ManagementInterface.class)) != null) {
            return management.name();
        }
        throw new IllegalArgumentException(iface + " is not a Neo4j Management Been interface");
    }
}

