/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import java.io.File;
import java.io.IOException;
import javax.management.NotCompliantMBeanException;
import org.neo4j.jmx.StoreFile;
import org.neo4j.jmx.impl.ManagementBeanProvider;
import org.neo4j.jmx.impl.ManagementData;
import org.neo4j.jmx.impl.Neo4jMBean;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;

public final class StoreFileBean
extends ManagementBeanProvider {
    public StoreFileBean() {
        super(StoreFile.class);
    }

    @Override
    protected Neo4jMBean createMBean(ManagementData management) throws NotCompliantMBeanException {
        return new StoreFileImpl(management);
    }

    private static class StoreFileImpl
    extends Neo4jMBean
    implements StoreFile {
        private static final String NODE_STORE = "neostore.nodestore.db";
        private static final String RELATIONSHIP_STORE = "neostore.relationshipstore.db";
        private static final String PROPERTY_STORE = "neostore.propertystore.db";
        private static final String ARRAY_STORE = "neostore.propertystore.db.arrays";
        private static final String STRING_STORE = "neostore.propertystore.db.strings";
        private File storePath;
        private LogFile logFile;

        StoreFileImpl(ManagementData management) throws NotCompliantMBeanException {
            super(management, new String[0]);
            DataSourceManager dataSourceManager = (DataSourceManager)management.resolveDependency(DataSourceManager.class);
            dataSourceManager.addListener(new DataSourceManager.Listener(){

                public void registered(NeoStoreDataSource ds) {
                    StoreFileImpl.this.logFile = (LogFile)ds.getDependencyResolver().resolveDependency(LogFile.class);
                    StoreFileImpl.this.storePath = this.resolvePath(ds);
                }

                public void unregistered(NeoStoreDataSource ds) {
                    StoreFileImpl.this.logFile = null;
                    StoreFileImpl.this.storePath = null;
                }

                private File resolvePath(NeoStoreDataSource ds) {
                    try {
                        return ds.getStoreDir().getCanonicalFile().getAbsoluteFile();
                    }
                    catch (IOException e) {
                        return ds.getStoreDir().getAbsoluteFile();
                    }
                }
            });
        }

        @Override
        public long getTotalStoreSize() {
            return this.storePath == null ? 0L : StoreFileImpl.sizeOf(this.storePath);
        }

        @Override
        public long getLogicalLogSize() {
            return this.logFile == null ? 0L : StoreFileImpl.sizeOf(this.logFile.currentLogFile());
        }

        private static long sizeOf(File file) {
            if (file.isFile()) {
                return file.length();
            }
            if (file.isDirectory()) {
                long size = 0L;
                File[] files = file.listFiles();
                if (files == null) {
                    return 0L;
                }
                for (File child : files) {
                    size += StoreFileImpl.sizeOf(child);
                }
                return size;
            }
            return 0L;
        }

        private long sizeOf(String name) {
            return StoreFileImpl.sizeOf(new File(this.storePath, name));
        }

        @Override
        public long getArrayStoreSize() {
            if (this.storePath == null) {
                return 0L;
            }
            return this.sizeOf(ARRAY_STORE);
        }

        @Override
        public long getNodeStoreSize() {
            if (this.storePath == null) {
                return 0L;
            }
            return this.sizeOf(NODE_STORE);
        }

        @Override
        public long getPropertyStoreSize() {
            if (this.storePath == null) {
                return 0L;
            }
            return this.sizeOf(PROPERTY_STORE);
        }

        @Override
        public long getRelationshipStoreSize() {
            if (this.storePath == null) {
                return 0L;
            }
            return this.sizeOf(RELATIONSHIP_STORE);
        }

        @Override
        public long getStringStoreSize() {
            if (this.storePath == null) {
                return 0L;
            }
            return this.sizeOf(STRING_STORE);
        }
    }
}

