/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.txstate.validation;

import java.util.Arrays;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.recordstorage.RecordDatabaseFile;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.kernel.api.exceptions.Status;

public class TransactionConflictException
extends TransientFailureException {
    private static final String GENERIC_MESSAGE = "Transaction conflict validation failed.";
    private DatabaseFile databaseFile;
    private long observedVersion;
    private long highestClosed;

    private TransactionConflictException(ErrorGqlStatusObject gqlStatusObject, DatabaseFile databaseFile, VersionContext versionContext, long pageId) {
        super(gqlStatusObject, TransactionConflictException.createMessage(databaseFile.getName(), pageId, versionContext));
        this.databaseFile = databaseFile;
        this.observedVersion = versionContext.chainHeadVersion();
        this.highestClosed = versionContext.highestClosed();
    }

    private TransactionConflictException(ErrorGqlStatusObject gqlStatusObject, String message, Exception cause) {
        super(gqlStatusObject, message, (Throwable)cause);
    }

    private TransactionConflictException(ErrorGqlStatusObject gqlStatusObject, Exception cause) {
        this(gqlStatusObject, GENERIC_MESSAGE, cause);
    }

    private TransactionConflictException(ErrorGqlStatusObject gqlStatusObject, RecordDatabaseFile databaseFile, long pageId) {
        super(gqlStatusObject, TransactionConflictException.createPageIdPagedMessage(databaseFile.getName(), pageId));
        this.databaseFile = databaseFile;
    }

    public static TransactionConflictException transactionConflict(Exception e) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N11).build();
        return new TransactionConflictException(gql, e);
    }

    public static TransactionConflictException transactionConflict(RecordDatabaseFile databaseFile, long pageId) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N11).build();
        return new TransactionConflictException(gql, databaseFile, pageId);
    }

    public static TransactionConflictException transactionConflict(RecordDatabaseFile databaseFile, VersionContext versionContext, long pageId) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N11).build();
        return new TransactionConflictException(gql, (DatabaseFile)databaseFile, versionContext, pageId);
    }

    public static TransactionConflictException concurrentModification(Exception e) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N11).build();
        return new TransactionConflictException(gql, "Concurrent modification exception. Constraint to be removed already removed by another transaction.", e);
    }

    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    public DatabaseFile getDatabaseFile() {
        return this.databaseFile;
    }

    public long getObservedVersion() {
        return this.observedVersion;
    }

    public long getHighestClosed() {
        return this.highestClosed;
    }

    public Status status() {
        return Status.Transaction.Outdated;
    }

    private static String createPageIdPagedMessage(String databaseFileName, long pageId) {
        return "Concurrent modification exception. Page " + pageId + " in '" + databaseFileName + "' store is already locked by other transaction validator.";
    }

    private static String createMessage(String databaseFileName, long pageId, VersionContext versionContext) {
        return "Concurrent modification exception. Page " + pageId + " in '" + databaseFileName + "' store is modified already by transaction " + versionContext.chainHeadVersion() + ", while ongoing transaction highest visible is: " + versionContext.highestClosed() + ", with not yet visible transaction ids are: " + Arrays.toString(versionContext.notVisibleTransactionIds()) + ".";
    }
}

