/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.Objects;
import org.neo4j.storageengine.api.StoreVersionUserStringProvider;

public class StoreVersionIdentifier
implements StoreVersionUserStringProvider {
    private final String storageEngineName;
    private final String formatName;
    private final int majorVersion;
    private final int minorVersion;

    public StoreVersionIdentifier(String storageEngineName, String formatName, int majorVersion, int minorVersion) {
        this.storageEngineName = storageEngineName;
        this.formatName = formatName;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public String getStorageEngineName() {
        return this.storageEngineName;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    boolean isSameOrUpgradeSuccessor(StoreVersionIdentifier anotherVersionIdentifier) {
        return this.majorVersion == anotherVersionIdentifier.majorVersion && this.minorVersion <= anotherVersionIdentifier.minorVersion && this.storageEngineName.equals(anotherVersionIdentifier.storageEngineName) && this.formatName.equals(anotherVersionIdentifier.formatName);
    }

    @Override
    public String getStoreVersionUserString() {
        return StoreVersionUserStringProvider.formatVersion(this.storageEngineName, this.formatName, this.majorVersion, this.minorVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreVersionIdentifier that = (StoreVersionIdentifier)o;
        return this.majorVersion == that.majorVersion && this.minorVersion == that.minorVersion && this.storageEngineName.equals(that.storageEngineName) && this.formatName.equals(that.formatName);
    }

    public int hashCode() {
        return Objects.hash(this.storageEngineName, this.formatName, this.majorVersion, this.minorVersion);
    }

    public String toString() {
        return this.getStoreVersionUserString();
    }
}

