/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.procs;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.helpers.collection.Iterables;

public class QualifiedName {
    private final String[] namespace;
    private final String name;
    private final String description;

    public QualifiedName(String[] namespace, String name) {
        this.namespace = namespace;
        this.name = name;
        this.description = QualifiedName.buildDescription(namespace, name);
    }

    public QualifiedName(String name) {
        this(ArrayUtils.EMPTY_STRING_ARRAY, name);
    }

    public QualifiedName(String ns1, String name) {
        this(new String[]{ns1}, name);
    }

    public QualifiedName(String ns1, String ns2, String name) {
        this(new String[]{ns1, ns2}, name);
    }

    public QualifiedName(String ns1, String ns2, String ns3, String name) {
        this(new String[]{ns1, ns2, ns3}, name);
    }

    public QualifiedName(String ns1, String ns2, String ns3, String ns4, String name) {
        this(new String[]{ns1, ns2, ns3, ns4}, name);
    }

    public String[] namespace() {
        return this.namespace;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)o;
        return Arrays.equals(this.namespace, that.namespace) && this.name.equals(that.name);
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.namespace) + this.name.hashCode();
    }

    private static String buildDescription(String[] namespace, String name) {
        String strNamespace = namespace.length > 0 ? Iterables.toString(Arrays.asList(namespace), (String)".") + "." : "";
        return String.format("%s%s", strNamespace, name);
    }
}

