/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestBase;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class ConstraintTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    protected abstract LabelSchemaDescriptor labelSchemaDescriptor(int var1, int ... var2);

    protected abstract ConstraintDescriptor uniqueConstraintDescriptor(int var1, int ... var2);

    @Before
    public void setup() {
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            for (ConstraintDefinition definition : graphDb.schema().getConstraints()) {
                definition.drop();
            }
            tx.success();
        }
    }

    @Test
    public void shouldFindConstraintsBySchema() throws Exception {
        this.addConstraints("FOO", "prop");
        try (Transaction tx = this.session.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("FOO");
            int prop = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            LabelSchemaDescriptor descriptor = this.labelSchemaDescriptor(label, prop);
            List constraints = Iterators.asList((Iterator)tx.schemaRead().constraintsGetForSchema((SchemaDescriptor)descriptor));
            MatcherAssert.assertThat((Object)constraints, (Matcher)Matchers.hasSize((int)1));
            MatcherAssert.assertThat((Object)((ConstraintDescriptor)constraints.get(0)).schema().getPropertyId(), (Matcher)Matchers.equalTo((Object)prop));
        }
    }

    @Test
    public void shouldFindConstraintsByLabel() throws Exception {
        this.addConstraints("FOO", "prop1", "FOO", "prop2");
        try (Transaction tx = this.session.beginTransaction();){
            int label = tx.tokenWrite().labelGetOrCreateForName("FOO");
            List constraints = Iterators.asList((Iterator)tx.schemaRead().constraintsGetForLabel(label));
            MatcherAssert.assertThat((Object)constraints, (Matcher)Matchers.hasSize((int)2));
        }
    }

    @Test
    public void shouldBeAbleCheckExistenceOfConstraints() throws Exception {
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            graphDb.schema().constraintFor(Label.label((String)"FOO")).assertPropertyIsUnique("prop1").create();
            ConstraintDefinition dropped = graphDb.schema().constraintFor(Label.label((String)"FOO")).assertPropertyIsUnique("prop2").create();
            dropped.drop();
            tx.success();
        }
        tx = this.session.beginTransaction();
        var2_2 = null;
        try {
            int label = tx.tokenWrite().labelGetOrCreateForName("FOO");
            int prop1 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop1");
            int prop2 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop2");
            Assert.assertTrue((boolean)tx.schemaRead().constraintExists(this.uniqueConstraintDescriptor(label, prop1)));
            Assert.assertFalse((boolean)tx.schemaRead().constraintExists(this.uniqueConstraintDescriptor(label, prop2)));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldFindAllConstraints() throws Exception {
        this.addConstraints("FOO", "prop1", "BAR", "prop2", "BAZ", "prop3");
        try (Transaction tx = this.session.beginTransaction();){
            List constraints = Iterators.asList((Iterator)tx.schemaRead().constraintsGetAll());
            MatcherAssert.assertThat((Object)constraints, (Matcher)Matchers.hasSize((int)3));
        }
    }

    @Test
    public void shouldCheckUniquenessWhenAddingLabel() throws Exception {
        int label;
        long nodeNotConflicting;
        long nodeConflicting;
        this.addConstraints("FOO", "prop");
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            Node conflict = graphDb.createNode();
            conflict.setProperty("prop", (Object)1337);
            nodeConflicting = conflict.getId();
            Node ok = graphDb.createNode();
            ok.setProperty("prop", (Object)42);
            nodeNotConflicting = ok.getId();
            Node existing = graphDb.createNode();
            existing.addLabel(Label.label((String)"FOO"));
            existing.setProperty("prop", (Object)1337);
            tx.success();
        }
        try (Transaction tx = this.session.beginTransaction();){
            label = tx.tokenWrite().labelGetOrCreateForName("FOO");
            Assert.assertTrue((boolean)tx.dataWrite().nodeAddLabel(nodeNotConflicting, label));
            try {
                tx.dataWrite().nodeAddLabel(nodeConflicting, label);
                Assert.fail();
            }
            catch (ConstraintValidationException ok) {
                // empty catch block
            }
            tx.success();
        }
        tx = this.session.beginTransaction();
        var7_4 = null;
        try (NodeCursor nodeCursor = tx.cursors().allocateNodeCursor();){
            tx.dataRead().singleNode(nodeNotConflicting, nodeCursor);
            Assert.assertTrue((boolean)nodeCursor.next());
            Assert.assertTrue((boolean)nodeCursor.labels().contains(label));
            tx.dataRead().singleNode(nodeConflicting, nodeCursor);
            Assert.assertTrue((boolean)nodeCursor.next());
            Assert.assertFalse((boolean)nodeCursor.labels().contains(label));
        }
        catch (Throwable throwable) {
            var7_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldCheckUniquenessWhenAddingProperties() throws Exception {
        int property;
        long nodeNotConflicting;
        long nodeConflicting;
        this.addConstraints("FOO", "prop");
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            Node conflict = graphDb.createNode();
            conflict.addLabel(Label.label((String)"FOO"));
            nodeConflicting = conflict.getId();
            Node ok = graphDb.createNode();
            ok.addLabel(Label.label((String)"BAR"));
            nodeNotConflicting = ok.getId();
            Node existing = graphDb.createNode();
            existing.addLabel(Label.label((String)"FOO"));
            existing.setProperty("prop", (Object)1337);
            tx.success();
        }
        try (Transaction tx = this.session.beginTransaction();){
            property = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            tx.dataWrite().nodeSetProperty(nodeNotConflicting, property, (Value)Values.intValue((int)1337));
            try {
                tx.dataWrite().nodeSetProperty(nodeConflicting, property, (Value)Values.intValue((int)1337));
                Assert.fail();
            }
            catch (ConstraintValidationException ok) {
                // empty catch block
            }
            tx.success();
        }
        tx = this.session.beginTransaction();
        var7_4 = null;
        try (NodeCursor nodeCursor = tx.cursors().allocateNodeCursor();
             PropertyCursor propertyCursor = tx.cursors().allocatePropertyCursor();){
            tx.dataRead().singleNode(nodeNotConflicting, nodeCursor);
            Assert.assertTrue((boolean)nodeCursor.next());
            nodeCursor.properties(propertyCursor);
            Assert.assertTrue((boolean)this.hasKey(propertyCursor, property));
            tx.dataRead().singleNode(nodeConflicting, nodeCursor);
            Assert.assertTrue((boolean)nodeCursor.next());
            nodeCursor.properties(propertyCursor);
            Assert.assertFalse((boolean)this.hasKey(propertyCursor, property));
        }
        catch (Throwable throwable) {
            var7_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private boolean hasKey(PropertyCursor propertyCursor, int key) {
        while (propertyCursor.next()) {
            if (propertyCursor.propertyKey() != key) continue;
            return true;
        }
        return false;
    }

    private void addConstraints(String ... labelProps) {
        assert (labelProps.length % 2 == 0);
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            for (int i = 0; i < labelProps.length; i += 2) {
                graphDb.schema().constraintFor(Label.label((String)labelProps[i])).assertPropertyIsUnique(labelProps[i + 1]).create();
            }
            tx.success();
        }
    }
}

