/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestBase;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class GraphPropertiesTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Test
    public void shouldBeAbleToWriteNewGraphProperty() throws Exception {
        try (Transaction tx = this.session.beginTransaction();){
            int prop = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            MatcherAssert.assertThat((Object)tx.dataWrite().graphSetProperty(prop, (Value)Values.stringValue((String)"hello")), (Matcher)Matchers.equalTo((Object)Values.NO_VALUE));
            tx.success();
        }
        var3_2 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)testSupport.graphProperties().getProperty("prop"), (Matcher)Matchers.equalTo((Object)"hello"));
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldBeAbleToReplaceExistingGraphProperty() throws Exception {
        int prop;
        try (Transaction tx = this.session.beginTransaction();){
            prop = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            MatcherAssert.assertThat((Object)tx.dataWrite().graphSetProperty(prop, (Value)Values.stringValue((String)"hello")), (Matcher)Matchers.equalTo((Object)Values.NO_VALUE));
            tx.success();
        }
        tx = this.session.beginTransaction();
        var3_2 = null;
        try {
            MatcherAssert.assertThat((Object)tx.dataWrite().graphSetProperty(prop, (Value)Values.stringValue((String)"good bye")), (Matcher)Matchers.equalTo((Object)Values.stringValue((String)"hello")));
            tx.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var3_2 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)testSupport.graphProperties().getProperty("prop"), (Matcher)Matchers.equalTo((Object)"good bye"));
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldBeAbleToRemoveExistingGraphProperty() throws Exception {
        int prop;
        try (Transaction tx = this.session.beginTransaction();){
            prop = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            MatcherAssert.assertThat((Object)tx.dataWrite().graphSetProperty(prop, (Value)Values.stringValue((String)"hello")), (Matcher)Matchers.equalTo((Object)Values.NO_VALUE));
            tx.success();
        }
        tx = this.session.beginTransaction();
        var3_2 = null;
        try {
            MatcherAssert.assertThat((Object)tx.dataWrite().graphRemoveProperty(prop), (Matcher)Matchers.equalTo((Object)Values.stringValue((String)"hello")));
            tx.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var3_2 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            Assert.assertFalse((boolean)testSupport.graphProperties().hasProperty("prop"));
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldBeAbleToReadExistingGraphProperties() throws Exception {
        int prop3;
        int prop2;
        int prop1;
        try (Transaction tx = this.session.beginTransaction();){
            prop1 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop1");
            prop2 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop2");
            prop3 = tx.tokenWrite().propertyKeyGetOrCreateForName("prop3");
            tx.dataWrite().graphSetProperty(prop1, (Value)Values.stringValue((String)"hello"));
            tx.dataWrite().graphSetProperty(prop2, (Value)Values.stringValue((String)"world"));
            tx.dataWrite().graphSetProperty(prop3, (Value)Values.stringValue((String)"etc"));
            tx.success();
        }
        tx = this.session.beginTransaction();
        var5_2 = null;
        try (PropertyCursor cursor = tx.cursors().allocatePropertyCursor();){
            tx.dataRead().graphProperties(cursor);
            Assert.assertTrue((boolean)cursor.next());
            MatcherAssert.assertThat((Object)cursor.propertyKey(), (Matcher)Matchers.equalTo((Object)prop1));
            MatcherAssert.assertThat((Object)cursor.propertyValue(), (Matcher)Matchers.equalTo((Object)Values.stringValue((String)"hello")));
            Assert.assertTrue((boolean)cursor.next());
            MatcherAssert.assertThat((Object)cursor.propertyKey(), (Matcher)Matchers.equalTo((Object)prop2));
            MatcherAssert.assertThat((Object)cursor.propertyValue(), (Matcher)Matchers.equalTo((Object)Values.stringValue((String)"world")));
            Assert.assertTrue((boolean)cursor.next());
            MatcherAssert.assertThat((Object)cursor.propertyKey(), (Matcher)Matchers.equalTo((Object)prop3));
            MatcherAssert.assertThat((Object)cursor.propertyValue(), (Matcher)Matchers.equalTo((Object)Values.stringValue((String)"etc")));
            Assert.assertFalse((boolean)cursor.next());
        }
        catch (Throwable throwable) {
            var5_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldSeeNewGraphPropertyInTransaction() throws Exception {
        try (Transaction tx = this.session.beginTransaction();
             PropertyCursor cursor = tx.cursors().allocatePropertyCursor();){
            int prop = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            MatcherAssert.assertThat((Object)tx.dataWrite().graphSetProperty(prop, (Value)Values.stringValue((String)"hello")), (Matcher)Matchers.equalTo((Object)Values.NO_VALUE));
            tx.dataRead().graphProperties(cursor);
            Assert.assertTrue((boolean)cursor.next());
            MatcherAssert.assertThat((Object)cursor.propertyKey(), (Matcher)Matchers.equalTo((Object)prop));
            MatcherAssert.assertThat((Object)cursor.propertyValue(), (Matcher)Matchers.equalTo((Object)Values.stringValue((String)"hello")));
        }
    }

    @Test
    public void shouldSeeUpdatedGraphPropertyInTransaction() throws Exception {
        int prop;
        try (Transaction tx = this.session.beginTransaction();){
            prop = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            MatcherAssert.assertThat((Object)tx.dataWrite().graphSetProperty(prop, (Value)Values.stringValue((String)"hello")), (Matcher)Matchers.equalTo((Object)Values.NO_VALUE));
            tx.success();
        }
        tx = this.session.beginTransaction();
        var3_2 = null;
        try (PropertyCursor cursor = tx.cursors().allocatePropertyCursor();){
            MatcherAssert.assertThat((Object)tx.dataWrite().graphSetProperty(prop, (Value)Values.stringValue((String)"good bye")), (Matcher)Matchers.equalTo((Object)Values.stringValue((String)"hello")));
            tx.dataRead().graphProperties(cursor);
            Assert.assertTrue((boolean)cursor.next());
            MatcherAssert.assertThat((Object)cursor.propertyKey(), (Matcher)Matchers.equalTo((Object)prop));
            MatcherAssert.assertThat((Object)cursor.propertyValue(), (Matcher)Matchers.equalTo((Object)Values.stringValue((String)"good bye")));
            Assert.assertFalse((boolean)cursor.next());
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotSeeRemovedGraphPropertyInTransaction() throws Exception {
        int prop;
        try (Transaction tx = this.session.beginTransaction();){
            prop = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            MatcherAssert.assertThat((Object)tx.dataWrite().graphSetProperty(prop, (Value)Values.stringValue((String)"hello")), (Matcher)Matchers.equalTo((Object)Values.NO_VALUE));
            tx.success();
        }
        tx = this.session.beginTransaction();
        var3_2 = null;
        try (PropertyCursor cursor = tx.cursors().allocatePropertyCursor();){
            MatcherAssert.assertThat((Object)tx.dataWrite().graphRemoveProperty(prop), (Matcher)Matchers.equalTo((Object)Values.stringValue((String)"hello")));
            tx.dataRead().graphProperties(cursor);
            Assert.assertFalse((boolean)cursor.next());
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotWriteWhenSettingPropertyToSameValue() throws Exception {
        int prop;
        TextValue theValue = Values.stringValue((String)"The Value");
        try (Transaction tx = this.session.beginTransaction();){
            prop = tx.tokenWrite().propertyKeyGetOrCreateForName("prop");
            tx.dataWrite().graphSetProperty(prop, (Value)theValue);
            tx.success();
        }
        tx = this.session.beginTransaction();
        MatcherAssert.assertThat((Object)tx.dataWrite().graphSetProperty(prop, (Value)theValue), (Matcher)Matchers.equalTo((Object)theValue));
        tx.success();
        MatcherAssert.assertThat((Object)tx.closeTransaction(), (Matcher)Matchers.equalTo((Object)0L));
    }
}

