/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import org.junit.Assert;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.internal.kernel.api.NodeIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;

public class IndexReadAsserts {
    static void assertNodes(NodeIndexCursor node, PrimitiveLongSet uniqueIds, long ... expected) {
        uniqueIds.clear();
        for (long count : expected) {
            Assert.assertTrue((String)("at least " + expected.length + " nodes"), (boolean)node.next());
            Assert.assertTrue((boolean)uniqueIds.add(node.nodeReference()));
        }
        Assert.assertFalse((String)("no more than " + expected.length + " nodes"), (boolean)node.next());
        Assert.assertEquals((String)"all nodes are unique", (long)expected.length, (long)uniqueIds.size());
        for (long expectedNode : expected) {
            Assert.assertTrue((String)("expected node " + expectedNode), (boolean)uniqueIds.contains(expectedNode));
        }
    }

    static void assertNodeCount(NodeIndexCursor node, int expectedCount, PrimitiveLongSet uniqueIds) {
        uniqueIds.clear();
        for (int i = 0; i < expectedCount; ++i) {
            Assert.assertTrue((String)("at least " + expectedCount + " nodes"), (boolean)node.next());
            Assert.assertTrue((boolean)uniqueIds.add(node.nodeReference()));
        }
        Assert.assertFalse((String)("no more than " + expectedCount + " nodes"), (boolean)node.next());
    }

    static void assertFoundRelationships(RelationshipIndexCursor edge, int edges, PrimitiveLongSet uniqueIds) {
        for (int i = 0; i < edges; ++i) {
            Assert.assertTrue((String)("at least " + edges + " relationships"), (boolean)edge.next());
            Assert.assertTrue((boolean)uniqueIds.add(edge.relationshipReference()));
        }
        Assert.assertFalse((String)("no more than " + edges + " relationships"), (boolean)edge.next());
    }
}

