/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.io.IOException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.Modes;
import org.neo4j.internal.kernel.api.Session;
import org.neo4j.internal.kernel.api.security.LoginContext;

public abstract class KernelAPIWriteTestBase<WriteSupport extends KernelAPIWriteTestSupport> {
    protected static final TemporaryFolder folder = new TemporaryFolder();
    protected static KernelAPIWriteTestSupport testSupport;
    protected Session session;
    protected Modes modes;
    protected static GraphDatabaseService graphDb;

    public abstract WriteSupport newTestSupport();

    @Before
    public void setupGraph() throws IOException {
        if (testSupport == null) {
            folder.create();
            testSupport = this.newTestSupport();
            testSupport.setup(folder.getRoot());
            graphDb = testSupport.graphBackdoor();
        }
        testSupport.clearGraph();
        Kernel kernel = testSupport.kernelToTest();
        this.session = kernel.beginSession(LoginContext.AUTH_DISABLED);
        this.modes = kernel.modes();
    }

    @After
    public void closeSession() {
        this.session.close();
    }

    @AfterClass
    public static void tearDown() {
        if (testSupport != null) {
            testSupport.tearDown();
            folder.delete();
            testSupport = null;
        }
    }
}

