/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestBase;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class NodeWriteTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private static final String propertyKey = "prop";
    private static final String labelName = "Town";

    @Test
    public void shouldCreateNode() throws Exception {
        long node;
        try (Transaction tx = this.session.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.success();
        }
        var4_2 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            Assert.assertEquals((long)node, (long)graphDb.getNodeById(node).getId());
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldRollbackOnFailure() throws Exception {
        long node;
        try (Transaction tx = this.session.beginTransaction();){
            node = tx.dataWrite().nodeCreate();
            tx.failure();
        }
        try {
            var4_3 = null;
            try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
                graphDb.getNodeById(node);
                Assert.fail((String)"There should be no node");
            }
            catch (Throwable throwable) {
                var4_3 = throwable;
                throw throwable;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void shouldRemoveNode() throws Exception {
        long node = this.createNode();
        try (Transaction tx = this.session.beginTransaction();){
            tx.dataWrite().nodeDelete(node);
            tx.success();
        }
        var4_3 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            try {
                graphDb.getNodeById(node);
                Assert.fail((String)"Did not remove node");
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldNotRemoveNodeThatDoesNotExist() throws Exception {
        long node = 0L;
        try (Transaction tx = this.session.beginTransaction();){
            Assert.assertFalse((boolean)tx.dataWrite().nodeDelete(node));
            tx.failure();
        }
        tx = this.session.beginTransaction();
        var4_3 = null;
        try {
            Assert.assertFalse((boolean)tx.dataWrite().nodeDelete(node));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldAddLabelNode() throws Exception {
        long node = this.createNode();
        try (Transaction tx = this.session.beginTransaction();){
            int labelId = tx.token().labelGetOrCreateForName(labelName);
            Assert.assertTrue((boolean)tx.dataWrite().nodeAddLabel(node, labelId));
            tx.success();
        }
        this.assertLabels(node, labelName);
    }

    @Test
    public void shouldAddLabelNodeOnce() throws Exception {
        long node = this.createNodeWithLabel(labelName);
        try (Transaction tx = this.session.beginTransaction();){
            int labelId = tx.token().labelGetOrCreateForName(labelName);
            Assert.assertFalse((boolean)tx.dataWrite().nodeAddLabel(node, labelId));
            tx.success();
        }
        this.assertLabels(node, labelName);
    }

    @Test
    public void shouldRemoveLabel() throws Exception {
        long nodeId = this.createNodeWithLabel(labelName);
        try (Transaction tx = this.session.beginTransaction();){
            int labelId = tx.token().labelGetOrCreateForName(labelName);
            Assert.assertTrue((boolean)tx.dataWrite().nodeRemoveLabel(nodeId, labelId));
            tx.success();
        }
        this.assertNoLabels(nodeId);
    }

    @Test
    public void shouldNotAddLabelToNonExistingNode() throws Exception {
        long node = 1337L;
        try (Transaction tx = this.session.beginTransaction();){
            int labelId = tx.token().labelGetOrCreateForName(labelName);
            this.exception.expect(KernelException.class);
            tx.dataWrite().nodeAddLabel(node, labelId);
        }
    }

    @Test
    public void shouldRemoveLabelOnce() throws Exception {
        int labelId;
        long nodeId = this.createNodeWithLabel(labelName);
        try (Transaction tx = this.session.beginTransaction();){
            labelId = tx.token().labelGetOrCreateForName(labelName);
            Assert.assertTrue((boolean)tx.dataWrite().nodeRemoveLabel(nodeId, labelId));
            tx.success();
        }
        tx = this.session.beginTransaction();
        var5_3 = null;
        try {
            labelId = tx.token().labelGetOrCreateForName(labelName);
            Assert.assertFalse((boolean)tx.dataWrite().nodeRemoveLabel(nodeId, labelId));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.assertNoLabels(nodeId);
    }

    @Test
    public void shouldAddPropertyToNode() throws Exception {
        long node = this.createNode();
        try (Transaction tx = this.session.beginTransaction();){
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            MatcherAssert.assertThat((Object)tx.dataWrite().nodeSetProperty(node, token, (Value)Values.stringValue((String)"hello")), (Matcher)Matchers.equalTo((Object)Values.NO_VALUE));
            tx.success();
        }
        this.assertProperty(node, propertyKey, "hello");
    }

    @Test
    public void shouldRollbackSetNodeProperty() throws Exception {
        long node = this.createNode();
        try (Transaction tx = this.session.beginTransaction();){
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            MatcherAssert.assertThat((Object)tx.dataWrite().nodeSetProperty(node, token, (Value)Values.stringValue((String)"hello")), (Matcher)Matchers.equalTo((Object)Values.NO_VALUE));
            tx.failure();
        }
        this.assertNoProperty(node, propertyKey);
    }

    @Test
    public void shouldThrowWhenSettingPropertyOnDeletedNode() throws Exception {
        long node = this.createNode();
        this.deleteNode(node);
        try (Transaction tx = this.session.beginTransaction();){
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            tx.dataWrite().nodeSetProperty(node, token, (Value)Values.stringValue((String)"hello"));
            Assert.fail((String)"Expected EntityNotFoundException");
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void shouldUpdatePropertyToNode() throws Exception {
        long node = this.createNodeWithProperty(propertyKey, 42);
        try (Transaction tx = this.session.beginTransaction();){
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            MatcherAssert.assertThat((Object)tx.dataWrite().nodeSetProperty(node, token, (Value)Values.stringValue((String)"hello")), (Matcher)Matchers.equalTo((Object)Values.intValue((int)42)));
            tx.success();
        }
        this.assertProperty(node, propertyKey, "hello");
    }

    @Test
    public void shouldRemovePropertyFromNode() throws Exception {
        long node = this.createNodeWithProperty(propertyKey, 42);
        try (Transaction tx = this.session.beginTransaction();){
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            MatcherAssert.assertThat((Object)tx.dataWrite().nodeRemoveProperty(node, token), (Matcher)Matchers.equalTo((Object)Values.intValue((int)42)));
            tx.success();
        }
        this.assertNoProperty(node, propertyKey);
    }

    @Test
    public void shouldRemoveNonExistingPropertyFromNode() throws Exception {
        long node = this.createNode();
        try (Transaction tx = this.session.beginTransaction();){
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            MatcherAssert.assertThat((Object)tx.dataWrite().nodeRemoveProperty(node, token), (Matcher)Matchers.equalTo((Object)Values.NO_VALUE));
            tx.success();
        }
        this.assertNoProperty(node, propertyKey);
    }

    @Test
    public void shouldRemovePropertyFromNodeTwice() throws Exception {
        long node = this.createNodeWithProperty(propertyKey, 42);
        try (Transaction tx = this.session.beginTransaction();){
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            MatcherAssert.assertThat((Object)tx.dataWrite().nodeRemoveProperty(node, token), (Matcher)Matchers.equalTo((Object)Values.intValue((int)42)));
            MatcherAssert.assertThat((Object)tx.dataWrite().nodeRemoveProperty(node, token), (Matcher)Matchers.equalTo((Object)Values.NO_VALUE));
            tx.success();
        }
        this.assertNoProperty(node, propertyKey);
    }

    @Test
    public void shouldUpdatePropertyToNodeInTransaction() throws Exception {
        long node = this.createNode();
        try (Transaction tx = this.session.beginTransaction();){
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            MatcherAssert.assertThat((Object)tx.dataWrite().nodeSetProperty(node, token, (Value)Values.stringValue((String)"hello")), (Matcher)Matchers.equalTo((Object)Values.NO_VALUE));
            MatcherAssert.assertThat((Object)tx.dataWrite().nodeSetProperty(node, token, (Value)Values.stringValue((String)"world")), (Matcher)Matchers.equalTo((Object)Values.stringValue((String)"hello")));
            MatcherAssert.assertThat((Object)tx.dataWrite().nodeSetProperty(node, token, (Value)Values.intValue((int)1337)), (Matcher)Matchers.equalTo((Object)Values.stringValue((String)"world")));
            tx.success();
        }
        this.assertProperty(node, propertyKey, 1337);
    }

    @Test
    public void shouldRemoveReSetAndTwiceRemovePropertyOnNode() throws Exception {
        long node = this.createNodeWithProperty(propertyKey, "bar");
        try (Transaction tx = this.session.beginTransaction();){
            int prop = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            tx.dataWrite().nodeRemoveProperty(node, prop);
            tx.dataWrite().nodeSetProperty(node, prop, Values.of((Object)"bar"));
            tx.dataWrite().nodeRemoveProperty(node, prop);
            tx.dataWrite().nodeRemoveProperty(node, prop);
            tx.success();
        }
        this.assertNoProperty(node, propertyKey);
    }

    @Test
    public void shouldNotWriteWhenSettingPropertyToSameValue() throws Exception {
        TextValue theValue = Values.stringValue((String)"The Value");
        long nodeId = this.createNodeWithProperty(propertyKey, theValue.asObject());
        Transaction tx = this.session.beginTransaction();
        int property = tx.token().propertyKeyGetOrCreateForName(propertyKey);
        MatcherAssert.assertThat((Object)tx.dataWrite().nodeSetProperty(nodeId, property, (Value)theValue), (Matcher)Matchers.equalTo((Object)theValue));
        tx.success();
        MatcherAssert.assertThat((Object)tx.closeTransaction(), (Matcher)Matchers.equalTo((Object)0L));
    }

    @Test
    public void shouldSetAndReadLargeByteArrayPropertyToNode() throws Exception {
        int prop;
        long node = this.createNode();
        Value largeByteArray = Values.of((Object)new byte[100000]);
        try (Transaction tx = this.session.beginTransaction();){
            prop = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            MatcherAssert.assertThat((Object)tx.dataWrite().nodeSetProperty(node, prop, largeByteArray), (Matcher)Matchers.equalTo((Object)Values.NO_VALUE));
            tx.success();
        }
        tx = this.session.beginTransaction();
        var6_4 = null;
        try (NodeCursor nodeCursor = tx.cursors().allocateNodeCursor();
             PropertyCursor propertyCursor = tx.cursors().allocatePropertyCursor();){
            tx.dataRead().singleNode(node, nodeCursor);
            Assert.assertTrue((boolean)nodeCursor.next());
            nodeCursor.properties(propertyCursor);
            Assert.assertTrue((boolean)propertyCursor.next());
            Assert.assertEquals((long)propertyCursor.propertyKey(), (long)prop);
            MatcherAssert.assertThat((Object)propertyCursor.propertyValue(), (Matcher)Matchers.equalTo((Object)largeByteArray));
        }
        catch (Throwable throwable) {
            var6_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private long createNode() {
        long node;
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            node = graphDb.createNode().getId();
            ctx.success();
        }
        return node;
    }

    private void deleteNode(long node) {
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            graphDb.getNodeById(node).delete();
            ctx.success();
        }
    }

    private long createNodeWithLabel(String labelName) {
        long node;
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            node = graphDb.createNode(new Label[]{Label.label((String)labelName)}).getId();
            ctx.success();
        }
        return node;
    }

    private long createNodeWithProperty(String propertyKey, Object value) {
        Node node;
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            node = graphDb.createNode();
            node.setProperty(propertyKey, value);
            ctx.success();
        }
        return node.getId();
    }

    private void assertNoLabels(long nodeId) {
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)graphDb.getNodeById(nodeId).getLabels(), (Matcher)Matchers.equalTo((Object)Iterables.empty()));
        }
    }

    private void assertLabels(long nodeId, String label) {
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)graphDb.getNodeById(nodeId).getLabels(), (Matcher)Matchers.containsInAnyOrder((Object[])new Label[]{Label.label((String)label)}));
        }
    }

    private void assertNoProperty(long node, String propertyKey) {
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            Assert.assertFalse((boolean)graphDb.getNodeById(node).hasProperty(propertyKey));
        }
    }

    private void assertProperty(long node, String propertyKey, Object value) {
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)graphDb.getNodeById(node).getProperty(propertyKey), (Matcher)Matchers.equalTo((Object)value));
        }
    }
}

