/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.KernelAPIReadTestBase;
import org.neo4j.internal.kernel.api.KernelAPIReadTestSupport;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;

public abstract class RelationshipScanCursorTestBase<G extends KernelAPIReadTestSupport>
extends KernelAPIReadTestBase<G> {
    private static List<Long> RELATIONSHIP_IDS;
    private static long none;
    private static long loop;
    private static long one;
    private static long c;
    private static long d;

    @Override
    void createTestGraph(GraphDatabaseService graphDb) {
        Relationship deleted;
        try (Transaction tx = graphDb.beginTx();){
            Node a = graphDb.createNode();
            Node b = graphDb.createNode();
            Node c = graphDb.createNode();
            Node d = graphDb.createNode();
            Node e = graphDb.createNode();
            Node f = graphDb.createNode();
            a.createRelationshipTo(b, RelationshipType.withName((String)"CIRCLE"));
            b.createRelationshipTo(c, RelationshipType.withName((String)"CIRCLE"));
            one = c.createRelationshipTo(d, RelationshipType.withName((String)"CIRCLE")).getId();
            d.createRelationshipTo(e, RelationshipType.withName((String)"CIRCLE"));
            e.createRelationshipTo(f, RelationshipType.withName((String)"CIRCLE"));
            f.createRelationshipTo(a, RelationshipType.withName((String)"CIRCLE"));
            a.createRelationshipTo(b, RelationshipType.withName((String)"TRIANGLE"));
            a.createRelationshipTo(c, RelationshipType.withName((String)"TRIANGLE"));
            b.createRelationshipTo(c, RelationshipType.withName((String)"TRIANGLE"));
            deleted = c.createRelationshipTo(b, RelationshipType.withName((String)"TRIANGLE"));
            none = deleted.getId();
            RelationshipScanCursorTestBase.c = c.getId();
            RelationshipScanCursorTestBase.d = d.getId();
            d.createRelationshipTo(e, RelationshipType.withName((String)"TRIANGLE"));
            e.createRelationshipTo(f, RelationshipType.withName((String)"TRIANGLE"));
            f.createRelationshipTo(d, RelationshipType.withName((String)"TRIANGLE"));
            loop = a.createRelationshipTo(a, RelationshipType.withName((String)"LOOP")).getId();
            tx.success();
        }
        RELATIONSHIP_IDS = new ArrayList<Long>();
        tx = graphDb.beginTx();
        var4_3 = null;
        try {
            deleted.delete();
            for (Relationship relationship : graphDb.getAllRelationships()) {
                RELATIONSHIP_IDS.add(relationship.getId());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldScanRelationships() {
        ArrayList<Long> ids = new ArrayList<Long>();
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor();){
            this.read.allRelationshipsScan(relationships);
            while (relationships.next()) {
                ids.add(relationships.relationshipReference());
            }
        }
        Assert.assertEquals(RELATIONSHIP_IDS, ids);
    }

    @Test
    public void shouldAccessRelationshipByReference() {
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor();){
            for (long id : RELATIONSHIP_IDS) {
                this.read.singleRelationship(id, relationships);
                Assert.assertTrue((String)"should access defined relationship", (boolean)relationships.next());
                Assert.assertEquals((String)"should access the correct relationship", (long)id, (long)relationships.relationshipReference());
                Assert.assertFalse((String)"should only access a single relationship", (boolean)relationships.next());
            }
        }
    }

    @Test
    public void shouldNotAccessDeletedRelationship() {
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor();){
            this.read.singleRelationship(none, relationships);
            Assert.assertFalse((String)"should not access deleted relationship", (boolean)relationships.next());
        }
    }

    @Test
    public void shouldNotAccessNegativeReferences() {
        try (RelationshipScanCursor relationship = this.cursors.allocateRelationshipScanCursor();){
            this.read.singleRelationship(-2L, relationship);
            Assert.assertFalse((String)"should not access negative reference relationship", (boolean)relationship.next());
        }
    }

    @Test
    public void shouldAccessRelationshipLabels() {
        HashMap<Integer, Integer> counts = new HashMap<Integer, Integer>();
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor();){
            this.read.allRelationshipsScan(relationships);
            while (relationships.next()) {
                counts.compute(relationships.type(), (k, v) -> v == null ? 1 : v + 1);
            }
        }
        Assert.assertEquals((long)3L, (long)counts.size());
        int[] values = new int[3];
        int i = 0;
        Iterator iterator = counts.values().iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            values[i++] = value;
        }
        Arrays.sort(values);
        Assert.assertArrayEquals((int[])new int[]{1, 6, 6}, (int[])values);
    }

    @Test
    public void shouldAccessNodes() {
        try (RelationshipScanCursor relationships = this.cursors.allocateRelationshipScanCursor();){
            this.read.singleRelationship(one, relationships);
            Assert.assertTrue((boolean)relationships.next());
            Assert.assertEquals((long)c, (long)relationships.sourceNodeReference());
            Assert.assertEquals((long)d, (long)relationships.targetNodeReference());
            Assert.assertFalse((boolean)relationships.next());
            this.read.singleRelationship(loop, relationships);
            Assert.assertTrue((boolean)relationships.next());
            Assert.assertEquals((long)relationships.sourceNodeReference(), (long)relationships.targetNodeReference());
            Assert.assertFalse((boolean)relationships.next());
        }
    }
}

