/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestBase;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class RelationshipWriteTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldCreateRelationship() throws Exception {
        long r;
        long n2;
        long n1;
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            n1 = graphDb.createNode().getId();
            n2 = graphDb.createNode().getId();
            tx.success();
        }
        try (Transaction tx = this.session.beginTransaction();){
            int label = tx.token().relationshipTypeGetOrCreateForName("R");
            r = tx.dataWrite().relationshipCreate(n1, label, n2);
            tx.success();
        }
        var8_10 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            List relationships = Iterables.asList((Iterable)graphDb.getNodeById(n1).getRelationships());
            Assert.assertEquals((long)1L, (long)relationships.size());
            Assert.assertEquals((long)((Relationship)relationships.get(0)).getId(), (long)r);
        }
        catch (Throwable throwable) {
            var8_10 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldCreateRelationshipBetweenInTransactionNodes() throws Exception {
        long r;
        long n1;
        try (Transaction tx = this.session.beginTransaction();){
            n1 = tx.dataWrite().nodeCreate();
            long n2 = tx.dataWrite().nodeCreate();
            int label = tx.token().relationshipTypeGetOrCreateForName("R");
            r = tx.dataWrite().relationshipCreate(n1, label, n2);
            tx.success();
        }
        var8_2 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            List relationships = Iterables.asList((Iterable)graphDb.getNodeById(n1).getRelationships());
            Assert.assertEquals((long)1L, (long)relationships.size());
            Assert.assertEquals((long)((Relationship)relationships.get(0)).getId(), (long)r);
        }
        catch (Throwable throwable) {
            var8_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldRollbackRelationshipOnFailure() throws Exception {
        long n2;
        long n1;
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            n1 = graphDb.createNode().getId();
            n2 = graphDb.createNode().getId();
            tx.success();
        }
        tx = this.session.beginTransaction();
        var6_2 = null;
        try {
            int label = tx.token().relationshipTypeGetOrCreateForName("R");
            tx.dataWrite().relationshipCreate(n1, label, n2);
            tx.failure();
        }
        catch (Throwable throwable) {
            var6_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var6_2 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            Assert.assertEquals((long)0L, (long)graphDb.getNodeById(n1).getDegree());
        }
        catch (Throwable throwable) {
            var6_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldDeleteRelationship() throws Exception {
        long r;
        long n1;
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            Node node1 = graphDb.createNode();
            Node node2 = graphDb.createNode();
            n1 = node1.getId();
            r = node1.createRelationshipTo(node2, RelationshipType.withName((String)"R")).getId();
            tx.success();
        }
        tx = this.session.beginTransaction();
        var6_2 = null;
        try {
            Assert.assertTrue((String)"should delete relationship", (boolean)tx.dataWrite().relationshipDelete(r));
            tx.success();
        }
        catch (Throwable throwable) {
            var6_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var6_2 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            Assert.assertEquals((long)0L, (long)graphDb.getNodeById(n1).getDegree());
        }
        catch (Throwable throwable) {
            var6_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldNotDeleteRelationshipThatDoesNotExist() throws Exception {
        long relationship = 0L;
        try (Transaction tx = this.session.beginTransaction();){
            Assert.assertFalse((boolean)tx.dataWrite().relationshipDelete(relationship));
            tx.failure();
        }
        tx = this.session.beginTransaction();
        var4_3 = null;
        try {
            Assert.assertFalse((boolean)tx.dataWrite().relationshipDelete(relationship));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldDeleteRelationshipAddedInTransaction() throws Exception {
        long n2;
        long n1;
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            n1 = graphDb.createNode().getId();
            n2 = graphDb.createNode().getId();
            tx.success();
        }
        tx = this.session.beginTransaction();
        var6_2 = null;
        try {
            int label = tx.token().relationshipTypeGetOrCreateForName("R");
            long r = tx.dataWrite().relationshipCreate(n1, label, n2);
            Assert.assertTrue((boolean)tx.dataWrite().relationshipDelete(r));
            tx.success();
        }
        catch (Throwable throwable) {
            var6_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var6_2 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            Assert.assertEquals((long)0L, (long)graphDb.getNodeById(n1).getDegree());
        }
        catch (Throwable throwable) {
            var6_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldAddPropertyToRelationship() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            Node node1 = graphDb.createNode();
            Node node2 = graphDb.createNode();
            relationshipId = node1.createRelationshipTo(node2, RelationshipType.withName((String)"R")).getId();
            tx.success();
        }
        tx = this.session.beginTransaction();
        var5_3 = null;
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            MatcherAssert.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.stringValue((String)"hello")), (Matcher)Matchers.equalTo((Object)Values.NO_VALUE));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var5_3 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)graphDb.getRelationshipById(relationshipId).getProperty("prop"), (Matcher)Matchers.equalTo((Object)"hello"));
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldUpdatePropertyToRelationship() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            Node node1 = graphDb.createNode();
            Node node2 = graphDb.createNode();
            Relationship r = node1.createRelationshipTo(node2, RelationshipType.withName((String)"R"));
            r.setProperty(propertyKey, (Object)42);
            relationshipId = r.getId();
            tx.success();
        }
        tx = this.session.beginTransaction();
        var5_3 = null;
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            MatcherAssert.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.stringValue((String)"hello")), (Matcher)Matchers.equalTo((Object)Values.intValue((int)42)));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var5_3 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)graphDb.getRelationshipById(relationshipId).getProperty("prop"), (Matcher)Matchers.equalTo((Object)"hello"));
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldRemovePropertyFromRelationship() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            Node node1 = graphDb.createNode();
            Node node2 = graphDb.createNode();
            Relationship proxy = node1.createRelationshipTo(node2, RelationshipType.withName((String)"R"));
            relationshipId = proxy.getId();
            proxy.setProperty(propertyKey, (Object)42);
            tx.success();
        }
        tx = this.session.beginTransaction();
        var5_3 = null;
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            MatcherAssert.assertThat((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, token), (Matcher)Matchers.equalTo((Object)Values.intValue((int)42)));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var5_3 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            Assert.assertFalse((boolean)graphDb.getRelationshipById(relationshipId).hasProperty("prop"));
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldRemoveNonExistingPropertyFromRelationship() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            Node node1 = graphDb.createNode();
            Node node2 = graphDb.createNode();
            Relationship proxy = node1.createRelationshipTo(node2, RelationshipType.withName((String)"R"));
            relationshipId = proxy.getId();
            tx.success();
        }
        tx = this.session.beginTransaction();
        var5_3 = null;
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            MatcherAssert.assertThat((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, token), (Matcher)Matchers.equalTo((Object)Values.NO_VALUE));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var5_3 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            Assert.assertFalse((boolean)graphDb.getRelationshipById(relationshipId).hasProperty("prop"));
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldRemovePropertyFromRelationshipTwice() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            Node node1 = graphDb.createNode();
            Node node2 = graphDb.createNode();
            Relationship proxy = node1.createRelationshipTo(node2, RelationshipType.withName((String)"R"));
            relationshipId = proxy.getId();
            proxy.setProperty(propertyKey, (Object)42);
            tx.success();
        }
        tx = this.session.beginTransaction();
        var5_3 = null;
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            MatcherAssert.assertThat((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, token), (Matcher)Matchers.equalTo((Object)Values.intValue((int)42)));
            MatcherAssert.assertThat((Object)tx.dataWrite().relationshipRemoveProperty(relationshipId, token), (Matcher)Matchers.equalTo((Object)Values.NO_VALUE));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var5_3 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            Assert.assertFalse((boolean)graphDb.getRelationshipById(relationshipId).hasProperty("prop"));
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldUpdatePropertyToRelationshipInTransaction() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        try (org.neo4j.graphdb.Transaction tx = graphDb.beginTx();){
            Node node1 = graphDb.createNode();
            Node node2 = graphDb.createNode();
            relationshipId = node1.createRelationshipTo(node2, RelationshipType.withName((String)"R")).getId();
            tx.success();
        }
        tx = this.session.beginTransaction();
        var5_3 = null;
        try {
            int token = tx.token().propertyKeyGetOrCreateForName(propertyKey);
            MatcherAssert.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.stringValue((String)"hello")), (Matcher)Matchers.equalTo((Object)Values.NO_VALUE));
            MatcherAssert.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.stringValue((String)"world")), (Matcher)Matchers.equalTo((Object)Values.stringValue((String)"hello")));
            MatcherAssert.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, token, (Value)Values.intValue((int)1337)), (Matcher)Matchers.equalTo((Object)Values.stringValue((String)"world")));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var5_3 = null;
        try (org.neo4j.graphdb.Transaction ignore = graphDb.beginTx();){
            MatcherAssert.assertThat((Object)graphDb.getRelationshipById(relationshipId).getProperty("prop"), (Matcher)Matchers.equalTo((Object)1337));
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldNotWriteWhenSettingPropertyToSameValue() throws Exception {
        long relationshipId;
        String propertyKey = "prop";
        TextValue theValue = Values.stringValue((String)"The Value");
        try (org.neo4j.graphdb.Transaction ctx = graphDb.beginTx();){
            Node node1 = graphDb.createNode();
            Node node2 = graphDb.createNode();
            Relationship r = node1.createRelationshipTo(node2, RelationshipType.withName((String)"R"));
            r.setProperty(propertyKey, theValue.asObject());
            relationshipId = r.getId();
            ctx.success();
        }
        Transaction tx = this.session.beginTransaction();
        int property = tx.token().propertyKeyGetOrCreateForName(propertyKey);
        MatcherAssert.assertThat((Object)tx.dataWrite().relationshipSetProperty(relationshipId, property, (Value)theValue), (Matcher)Matchers.equalTo((Object)theValue));
        tx.success();
        MatcherAssert.assertThat((Object)tx.closeTransaction(), (Matcher)Matchers.equalTo((Object)0L));
    }
}

