/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import java.util.Collections;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.CapableIndexReference;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestBase;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public abstract class SchemaReadWriteTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    private int label;
    private int label2;
    private int type;
    private int prop1;
    private int prop2;
    private int prop3;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        try (Transaction transaction = this.session.beginTransaction();){
            SchemaRead schemaRead = transaction.schemaRead();
            SchemaWrite schemaWrite = transaction.schemaWrite();
            Iterator constraints = schemaRead.constraintsGetAll();
            while (constraints.hasNext()) {
                schemaWrite.constraintDrop((ConstraintDescriptor)constraints.next());
            }
            Iterator indexes = schemaRead.indexesGetAll();
            while (indexes.hasNext()) {
                schemaWrite.indexDrop((IndexReference)indexes.next());
            }
            TokenWrite tokenWrite = transaction.tokenWrite();
            this.label = tokenWrite.labelGetOrCreateForName("label");
            this.label2 = tokenWrite.labelGetOrCreateForName("label2");
            this.type = tokenWrite.relationshipTypeGetOrCreateForName("relationship");
            this.prop1 = tokenWrite.propertyKeyGetOrCreateForName("prop1");
            this.prop2 = tokenWrite.propertyKeyGetOrCreateForName("prop2");
            this.prop3 = tokenWrite.propertyKeyGetOrCreateForName("prop3");
            transaction.success();
        }
    }

    @Test
    public void shouldNotFindNonExistentIndex() throws Exception {
        try (Transaction transaction = this.session.beginTransaction();){
            SchemaRead schemaRead = transaction.schemaRead();
            MatcherAssert.assertThat((Object)schemaRead.index(this.label, new int[]{this.prop1}), (Matcher)Matchers.equalTo((Object)CapableIndexReference.NO_INDEX));
        }
    }

    @Test
    public void shouldCreateIndex() throws Exception {
        IndexReference index;
        try (Transaction transaction = this.session.beginTransaction();){
            index = transaction.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1), null);
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            MatcherAssert.assertThat((Object)schemaRead.index(this.label, new int[]{this.prop1}), (Matcher)Matchers.equalTo((Object)index));
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldGetUndecidedVersionAndKeyFromIndexReference() throws Exception {
        try (Transaction transaction = this.session.beginTransaction();){
            transaction.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1), null);
            CapableIndexReference index = transaction.schemaRead().index(this.label, new int[]{this.prop1});
            MatcherAssert.assertThat((Object)index.providerKey(), (Matcher)Matchers.equalTo((Object)"Undecided"));
            MatcherAssert.assertThat((Object)index.providerVersion(), (Matcher)Matchers.equalTo((Object)"0"));
        }
    }

    @Test
    public void createdIndexShouldPopulateInTx() throws Exception {
        try (Transaction tx = this.session.beginTransaction();){
            IndexReference index = tx.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1), null);
            MatcherAssert.assertThat((Object)tx.schemaRead().indexGetState(index), (Matcher)Matchers.equalTo((Object)InternalIndexState.POPULATING));
            tx.success();
        }
    }

    @Test
    public void shouldDropIndex() throws Exception {
        IndexReference index;
        try (Transaction transaction = this.session.beginTransaction();){
            index = transaction.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1), null);
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            transaction.schemaWrite().indexDrop(index);
            transaction.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            MatcherAssert.assertThat((Object)schemaRead.index(this.label, new int[]{this.prop1}), (Matcher)Matchers.equalTo((Object)CapableIndexReference.NO_INDEX));
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldFailIfExistingIndex() throws Exception {
        try (Transaction transaction = this.session.beginTransaction();){
            transaction.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1), null);
            transaction.success();
        }
        this.exception.expect(SchemaKernelException.class);
        transaction = this.session.beginTransaction();
        var2_2 = null;
        try {
            transaction.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1), null);
            transaction.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var2_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldSeeIndexFromTransaction() throws Exception {
        try (Transaction transaction = this.session.beginTransaction();){
            transaction.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1), null);
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var2_2 = null;
        try {
            transaction.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop2), null);
            SchemaRead schemaRead = transaction.schemaRead();
            CapableIndexReference index = schemaRead.index(this.label, new int[]{this.prop2});
            MatcherAssert.assertThat((Object)index.properties(), (Matcher)Matchers.equalTo((Object)new int[]{this.prop2}));
            MatcherAssert.assertThat((Object)2, (Matcher)Matchers.equalTo((Object)Iterators.asList((Iterator)schemaRead.indexesGetAll()).size()));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var2_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldNotSeeDroppedIndexFromTransaction() throws Exception {
        IndexReference index;
        try (Transaction transaction = this.session.beginTransaction();){
            index = transaction.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1), null);
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            transaction.schemaWrite().indexDrop(index);
            SchemaRead schemaRead = transaction.schemaRead();
            MatcherAssert.assertThat((Object)schemaRead.index(this.label, new int[]{this.prop2}), (Matcher)Matchers.equalTo((Object)CapableIndexReference.NO_INDEX));
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldListAllIndexes() throws Exception {
        IndexReference toDrop;
        IndexReference toRetain2;
        IndexReference toRetain;
        try (Transaction tx = this.session.beginTransaction();){
            toRetain = tx.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1), null);
            toRetain2 = tx.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(this.label2, this.prop1), null);
            toDrop = tx.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop2), null);
            tx.success();
        }
        tx = this.session.beginTransaction();
        var6_2 = null;
        try {
            IndexReference created = tx.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(this.label2, this.prop2), null);
            tx.schemaWrite().indexDrop(toDrop);
            Iterable allIndexes = () -> tx.schemaRead().indexesGetAll();
            MatcherAssert.assertThat(allIndexes, (Matcher)Matchers.containsInAnyOrder((Object[])new IndexReference[]{toRetain, toRetain2, created}));
            tx.success();
        }
        catch (Throwable throwable) {
            var6_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldListIndexesByLabel() throws Exception {
        IndexReference droppedInTx;
        IndexReference inStore;
        int wrongLabel;
        try (Transaction tx = this.session.beginTransaction();){
            wrongLabel = tx.tokenWrite().labelGetOrCreateForName("wrongLabel");
            tx.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)this.labelDescriptor(wrongLabel, this.prop1));
            inStore = tx.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1), null);
            droppedInTx = tx.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop2), null);
            tx.success();
        }
        tx = this.session.beginTransaction();
        var6_2 = null;
        try {
            IndexReference createdInTx = tx.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop3), null);
            tx.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(wrongLabel, this.prop2), null);
            tx.schemaWrite().indexDrop(droppedInTx);
            Iterable indexes = () -> tx.schemaRead().indexesGetForLabel(this.label);
            MatcherAssert.assertThat(indexes, (Matcher)Matchers.containsInAnyOrder((Object[])new IndexReference[]{inStore, createdInTx}));
            tx.success();
        }
        catch (Throwable throwable) {
            var6_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldCreateUniquePropertyConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (Transaction transaction = this.session.beginTransaction();){
            constraint = transaction.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1));
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assert.assertTrue((boolean)schemaRead.constraintExists(constraint));
            Iterator constraints = schemaRead.constraintsGetForLabel(this.label);
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)constraints), (Matcher)Matchers.equalTo(Collections.singletonList(constraint)));
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldDropUniquePropertyConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (Transaction transaction = this.session.beginTransaction();){
            constraint = transaction.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1));
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            transaction.schemaWrite().constraintDrop(constraint);
            transaction.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assert.assertFalse((boolean)schemaRead.constraintExists(constraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldFailToCreateUniqueConstraintIfExistingIndex() throws Exception {
        try (Transaction transaction = this.session.beginTransaction();){
            transaction.schemaWrite().indexCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1), null);
            transaction.success();
        }
        this.exception.expect(SchemaKernelException.class);
        transaction = this.session.beginTransaction();
        var2_2 = null;
        try {
            transaction.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1));
            transaction.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var2_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldFailToCreateUniqueConstraintIfConstraintNotSatisfied() throws Exception {
        try (Transaction transaction = this.session.beginTransaction();){
            Write write = transaction.dataWrite();
            long node1 = write.nodeCreate();
            write.nodeAddLabel(node1, this.label);
            write.nodeSetProperty(node1, this.prop1, (Value)Values.intValue((int)42));
            long node2 = write.nodeCreate();
            write.nodeAddLabel(node2, this.label);
            write.nodeSetProperty(node2, this.prop1, (Value)Values.intValue((int)42));
            transaction.success();
        }
        this.exception.expect(SchemaKernelException.class);
        transaction = this.session.beginTransaction();
        var2_2 = null;
        try {
            transaction.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var2_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldSeeUniqueConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (Transaction transaction = this.session.beginTransaction();){
            existing = transaction.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1));
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            ConstraintDescriptor newConstraint = transaction.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop2));
            SchemaRead schemaRead = transaction.schemaRead();
            Assert.assertTrue((boolean)schemaRead.constraintExists(existing));
            Assert.assertTrue((boolean)schemaRead.constraintExists(newConstraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{existing, newConstraint}));
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldNotSeeDroppedUniqueConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (Transaction transaction = this.session.beginTransaction();){
            existing = transaction.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1));
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            transaction.schemaWrite().constraintDrop(existing);
            SchemaRead schemaRead = transaction.schemaRead();
            Assert.assertFalse((boolean)schemaRead.constraintExists(existing));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldCreateNodeKeyConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (Transaction transaction = this.session.beginTransaction();){
            constraint = transaction.schemaWrite().nodeKeyConstraintCreate(this.labelDescriptor(this.label, this.prop1));
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assert.assertTrue((boolean)schemaRead.constraintExists(constraint));
            Iterator constraints = schemaRead.constraintsGetForLabel(this.label);
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)constraints), (Matcher)Matchers.equalTo(Collections.singletonList(constraint)));
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldDropNodeKeyConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (Transaction transaction = this.session.beginTransaction();){
            constraint = transaction.schemaWrite().nodeKeyConstraintCreate(this.labelDescriptor(this.label, this.prop1));
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            transaction.schemaWrite().constraintDrop(constraint);
            transaction.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assert.assertFalse((boolean)schemaRead.constraintExists(constraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldFailToNodeKeyConstraintIfConstraintNotSatisfied() throws Exception {
        try (Transaction transaction = this.session.beginTransaction();){
            Write write = transaction.dataWrite();
            long node = write.nodeCreate();
            write.nodeAddLabel(node, this.label);
            transaction.success();
        }
        this.exception.expect(SchemaKernelException.class);
        transaction = this.session.beginTransaction();
        var2_2 = null;
        try {
            transaction.schemaWrite().nodeKeyConstraintCreate(this.labelDescriptor(this.label, this.prop1));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var2_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldSeeNodeKeyConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (Transaction transaction = this.session.beginTransaction();){
            existing = transaction.schemaWrite().nodeKeyConstraintCreate(this.labelDescriptor(this.label, this.prop1));
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            ConstraintDescriptor newConstraint = transaction.schemaWrite().nodeKeyConstraintCreate(this.labelDescriptor(this.label, this.prop2));
            SchemaRead schemaRead = transaction.schemaRead();
            Assert.assertTrue((boolean)schemaRead.constraintExists(existing));
            Assert.assertTrue((boolean)schemaRead.constraintExists(newConstraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{existing, newConstraint}));
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldNotSeeDroppedNodeKeyConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (Transaction transaction = this.session.beginTransaction();){
            existing = transaction.schemaWrite().nodeKeyConstraintCreate(this.labelDescriptor(this.label, this.prop1));
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            transaction.schemaWrite().constraintDrop(existing);
            SchemaRead schemaRead = transaction.schemaRead();
            Assert.assertFalse((boolean)schemaRead.constraintExists(existing));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldCreateNodePropertyExistenceConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (Transaction transaction = this.session.beginTransaction();){
            constraint = transaction.schemaWrite().nodePropertyExistenceConstraintCreate(this.labelDescriptor(this.label, this.prop1));
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assert.assertTrue((boolean)schemaRead.constraintExists(constraint));
            Iterator constraints = schemaRead.constraintsGetForLabel(this.label);
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)constraints), (Matcher)Matchers.equalTo(Collections.singletonList(constraint)));
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldDropNodePropertyExistenceConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (Transaction transaction = this.session.beginTransaction();){
            constraint = transaction.schemaWrite().nodePropertyExistenceConstraintCreate(this.labelDescriptor(this.label, this.prop1));
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            transaction.schemaWrite().constraintDrop(constraint);
            transaction.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assert.assertFalse((boolean)schemaRead.constraintExists(constraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldFailToCreatePropertyExistenceConstraintIfConstraintNotSatisfied() throws Exception {
        try (Transaction transaction = this.session.beginTransaction();){
            Write write = transaction.dataWrite();
            long node = write.nodeCreate();
            write.nodeAddLabel(node, this.label);
            transaction.success();
        }
        this.exception.expect(SchemaKernelException.class);
        transaction = this.session.beginTransaction();
        var2_2 = null;
        try {
            transaction.schemaWrite().nodePropertyExistenceConstraintCreate(this.labelDescriptor(this.label, this.prop1));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var2_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldSeeNodePropertyExistenceConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (Transaction transaction = this.session.beginTransaction();){
            existing = transaction.schemaWrite().nodePropertyExistenceConstraintCreate(this.labelDescriptor(this.label, this.prop1));
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            ConstraintDescriptor newConstraint = transaction.schemaWrite().nodePropertyExistenceConstraintCreate(this.labelDescriptor(this.label, this.prop2));
            SchemaRead schemaRead = transaction.schemaRead();
            Assert.assertTrue((boolean)schemaRead.constraintExists(existing));
            Assert.assertTrue((boolean)schemaRead.constraintExists(newConstraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{existing, newConstraint}));
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldNotSeeDroppedNodePropertyExistenceConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (Transaction transaction = this.session.beginTransaction();){
            existing = transaction.schemaWrite().nodePropertyExistenceConstraintCreate(this.labelDescriptor(this.label, this.prop1));
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            transaction.schemaWrite().constraintDrop(existing);
            SchemaRead schemaRead = transaction.schemaRead();
            Assert.assertFalse((boolean)schemaRead.constraintExists(existing));
            MatcherAssert.assertThat((Object)schemaRead.index(this.label, new int[]{this.prop2}), (Matcher)Matchers.equalTo((Object)CapableIndexReference.NO_INDEX));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldCreateRelationshipPropertyExistenceConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (Transaction transaction = this.session.beginTransaction();){
            constraint = transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(this.typeDescriptor(this.type, this.prop1));
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assert.assertTrue((boolean)schemaRead.constraintExists(constraint));
            Iterator constraints = schemaRead.constraintsGetForRelationshipType(this.type);
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)constraints), (Matcher)Matchers.equalTo(Collections.singletonList(constraint)));
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldDropRelationshipPropertyExistenceConstraint() throws Exception {
        ConstraintDescriptor constraint;
        try (Transaction transaction = this.session.beginTransaction();){
            constraint = transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(this.typeDescriptor(this.type, this.prop1));
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            transaction.schemaWrite().constraintDrop(constraint);
            transaction.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            SchemaRead schemaRead = transaction.schemaRead();
            Assert.assertFalse((boolean)schemaRead.constraintExists(constraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForRelationshipType(this.type)), (Matcher)Matchers.empty());
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldFailToCreateRelationshipPropertyExistenceConstraintIfConstraintNotSatisfied() throws Exception {
        try (Transaction transaction = this.session.beginTransaction();){
            Write write = transaction.dataWrite();
            write.relationshipCreate(write.nodeCreate(), this.type, write.nodeCreate());
            transaction.success();
        }
        this.exception.expect(SchemaKernelException.class);
        transaction = this.session.beginTransaction();
        var2_2 = null;
        try {
            transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(this.typeDescriptor(this.type, this.prop1));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var2_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldSeeRelationshipPropertyExistenceConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (Transaction transaction = this.session.beginTransaction();){
            existing = transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(this.typeDescriptor(this.type, this.prop1));
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            ConstraintDescriptor newConstraint = transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(this.typeDescriptor(this.type, this.prop2));
            SchemaRead schemaRead = transaction.schemaRead();
            Assert.assertTrue((boolean)schemaRead.constraintExists(existing));
            Assert.assertTrue((boolean)schemaRead.constraintExists(newConstraint));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForRelationshipType(this.type)), (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{existing, newConstraint}));
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldNotSeeDroppedRelationshipPropertyExistenceConstraintFromTransaction() throws Exception {
        ConstraintDescriptor existing;
        try (Transaction transaction = this.session.beginTransaction();){
            existing = transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(this.typeDescriptor(this.type, this.prop1));
            transaction.success();
        }
        transaction = this.session.beginTransaction();
        var3_2 = null;
        try {
            transaction.schemaWrite().constraintDrop(existing);
            SchemaRead schemaRead = transaction.schemaRead();
            Assert.assertFalse((boolean)schemaRead.constraintExists(existing));
            MatcherAssert.assertThat((Object)schemaRead.index(this.type, new int[]{this.prop2}), (Matcher)Matchers.equalTo((Object)CapableIndexReference.NO_INDEX));
            MatcherAssert.assertThat((Object)Iterators.asList((Iterator)schemaRead.constraintsGetForLabel(this.label)), (Matcher)Matchers.empty());
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_2 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shouldListAllConstraints() throws Exception {
        ConstraintDescriptor toDrop;
        ConstraintDescriptor toRetain2;
        ConstraintDescriptor toRetain;
        try (Transaction tx = this.session.beginTransaction();){
            toRetain = tx.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1));
            toRetain2 = tx.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)this.labelDescriptor(this.label2, this.prop1));
            toDrop = tx.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop2));
            tx.success();
        }
        tx = this.session.beginTransaction();
        var6_2 = null;
        try {
            ConstraintDescriptor created = tx.schemaWrite().nodePropertyExistenceConstraintCreate(this.labelDescriptor(this.label, this.prop1));
            tx.schemaWrite().constraintDrop(toDrop);
            Iterable allConstraints = () -> tx.schemaRead().constraintsGetAll();
            MatcherAssert.assertThat(allConstraints, (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{toRetain, toRetain2, created}));
            tx.success();
        }
        catch (Throwable throwable) {
            var6_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldListConstraintsByLabel() throws Exception {
        ConstraintDescriptor droppedInTx;
        ConstraintDescriptor inStore;
        int wrongLabel;
        try (Transaction tx = this.session.beginTransaction();){
            wrongLabel = tx.tokenWrite().labelGetOrCreateForName("wrongLabel");
            tx.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)this.labelDescriptor(wrongLabel, this.prop1));
            inStore = tx.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop1));
            droppedInTx = tx.schemaWrite().uniquePropertyConstraintCreate((SchemaDescriptor)this.labelDescriptor(this.label, this.prop2));
            tx.success();
        }
        tx = this.session.beginTransaction();
        var6_2 = null;
        try {
            ConstraintDescriptor createdInTx = tx.schemaWrite().nodePropertyExistenceConstraintCreate(this.labelDescriptor(this.label, this.prop1));
            tx.schemaWrite().nodePropertyExistenceConstraintCreate(this.labelDescriptor(wrongLabel, this.prop1));
            tx.schemaWrite().constraintDrop(droppedInTx);
            Iterable allConstraints = () -> tx.schemaRead().constraintsGetForLabel(this.label);
            MatcherAssert.assertThat(allConstraints, (Matcher)Matchers.containsInAnyOrder((Object[])new ConstraintDescriptor[]{inStore, createdInTx}));
            tx.success();
        }
        catch (Throwable throwable) {
            var6_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    protected abstract RelationTypeSchemaDescriptor typeDescriptor(int var1, int ... var2);

    protected abstract LabelSchemaDescriptor labelDescriptor(int var1, int ... var2);
}

