/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestBase;
import org.neo4j.internal.kernel.api.KernelAPIWriteTestSupport;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;

public abstract class TransactionTestBase<G extends KernelAPIWriteTestSupport>
extends KernelAPIWriteTestBase<G> {
    @Test
    public void shouldRollbackWhenTxIsNotSuccess() throws Exception {
        long nodeId;
        try (Transaction tx = this.session.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            int labelId = tx.tokenWrite().labelGetOrCreateForName("labello");
            tx.dataWrite().nodeAddLabel(nodeId, labelId);
        }
        this.assertNoNode(nodeId);
    }

    @Test
    public void shouldRollbackWhenTxIsFailed() throws Exception {
        long nodeId;
        try (Transaction tx = this.session.beginTransaction();){
            nodeId = tx.dataWrite().nodeCreate();
            int labelId = tx.tokenWrite().labelGetOrCreateForName("labello");
            tx.dataWrite().nodeAddLabel(nodeId, labelId);
            tx.failure();
        }
        this.assertNoNode(nodeId);
    }

    @Test
    public void shouldRollbackAndThrowWhenTxIsBothFailedAndSuccess() throws Exception {
        Transaction tx = this.session.beginTransaction();
        long nodeId = tx.dataWrite().nodeCreate();
        int labelId = tx.tokenWrite().labelGetOrCreateForName("labello");
        tx.dataWrite().nodeAddLabel(nodeId, labelId);
        tx.failure();
        tx.success();
        try {
            tx.close();
            Assert.fail((String)"Expected TransactionFailureException");
        }
        catch (TransactionFailureException transactionFailureException) {
            // empty catch block
        }
        this.assertNoNode(nodeId);
    }

    private void assertNoNode(long nodeId) throws TransactionFailureException {
        try (Transaction tx = this.session.beginTransaction();
             NodeCursor cursor = tx.cursors().allocateNodeCursor();){
            tx.dataRead().singleNode(nodeId, cursor);
            Assert.assertFalse((boolean)cursor.next());
        }
    }
}

